/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.widget.HTMLPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.yapbam.gui.LocalizationData;

public class ErrorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox chckbxDontAskMe;

    public ErrorPanel() {
        JComponent label;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        JPanel panel = new JPanel();
        panel.setBorder(null);
        GridBagConstraints gbcPanel = new GridBagConstraints();
        gbcPanel.insets = new Insets(0, 0, 5, 5);
        gbcPanel.fill = 1;
        gbcPanel.gridx = 0;
        gbcPanel.gridy = 0;
        this.add((Component)panel, gbcPanel);
        GridBagLayout gblPanel = new GridBagLayout();
        panel.setLayout(gblPanel);
        JLabel icon = new JLabel();
        GridBagConstraints gbcIcon = new GridBagConstraints();
        gbcIcon.anchor = 17;
        gbcIcon.fill = 3;
        gbcIcon.insets = new Insets(0, 0, 0, 5);
        gbcIcon.gridx = 0;
        gbcIcon.gridy = 0;
        panel.add((Component)icon, gbcIcon);
        icon.setIcon(this.getIcon());
        if (this.hasExtendedMessage()) {
            label = new HTMLPane(this.getMessage());
            ((Component)label).setPreferredSize(new Dimension(400 * this.getFont().getSize() / 12, 220 * this.getFont().getSize() / 12));
        } else {
            label = new JLabel(this.getMessage());
        }
        GridBagConstraints gbcLabel = new GridBagConstraints();
        gbcLabel.insets = new Insets(0, 10, 0, 0);
        gbcLabel.anchor = 17;
        gbcLabel.fill = 2;
        gbcLabel.gridx = 1;
        gbcLabel.gridy = 0;
        panel.add((Component)label, gbcLabel);
        this.chckbxDontAskMe = new JCheckBox(this.getDontAskMeText());
        this.chckbxDontAskMe.setHorizontalAlignment(4);
        this.chckbxDontAskMe.setToolTipText(this.getDontAskMeTooltip());
        GridBagConstraints gbcChckbxDontAskMe = new GridBagConstraints();
        gbcChckbxDontAskMe.insets = new Insets(0, 0, 5, 5);
        gbcChckbxDontAskMe.fill = 2;
        gbcChckbxDontAskMe.anchor = 13;
        gbcChckbxDontAskMe.gridx = 0;
        gbcChckbxDontAskMe.gridy = 1;
        this.add((Component)this.chckbxDontAskMe, gbcChckbxDontAskMe);
    }

    protected String getDontAskMeTooltip() {
        return LocalizationData.get("GenericCheckBox.rememberDecision.tooltip");
    }

    protected String getDontAskMeText() {
        return LocalizationData.get("GenericCheckBox.rememberDecision");
    }

    protected Icon getIcon() {
        return UIManager.getIcon("OptionPane.errorIcon");
    }

    protected String getMessage() {
        String message = LocalizationData.get("ErrorManager.sendReport.message");
        if (this.hasExtendedMessage()) {
            String mailMessage = Formatter.format("<br><br>Vous pouvez \u00e9galement nous envoyer un mail \u00e0 l''adresse <b>bug@yapbam.net</b> en nous indiquant ce que vous tentiez de faire lorsque ce bug est survenu et, si possible, comment le reproduire.<br>Merci de mentionner la r\u00e9f\u00e9rence suivante dans le titre du mail : {0}", new SimpleDateFormat("dd/MM/yyyy-HH:mm:ss-Z").format(new Date())) + "</html>";
            message = message.replace("</html>", mailMessage);
        }
        return message;
    }

    private boolean hasExtendedMessage() {
        return "fr".equals(LocalizationData.getLocale().getLanguage());
    }

    public boolean isDontAskMeSelected() {
        return this.chckbxDontAskMe.isSelected();
    }

    public void setDontAskMeVisible(boolean visible) {
        this.chckbxDontAskMe.setVisible(visible);
    }
}

