/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.widget.IntegerWidget;
import com.fathzer.soft.ajlib.swing.widget.date.DateWidget;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigInteger;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.yapbam.date.helpers.DateStepper;
import net.yapbam.date.helpers.DayDateStepper;
import net.yapbam.date.helpers.MonthDateStepper;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.widget.AutoSelectFocusListener;

public class GenerationPanel
extends JPanel {
    public static final String ACTIVATED_PROPERTY = "activated";
    public static final String DATE_STEPPER_PROPERTY = "dateStepper";
    public static final String NEXT_DATE_PROPERTY = "nextDate";
    private static final int YEARLY_INDEX = 0;
    private static final int MONTHLY_INDEX = 1;
    private static final int DAILY_INDEX = 2;
    private static final long serialVersionUID = 1L;
    private JCheckBox activatedBox = null;
    private DateWidget date = null;
    private JLabel jLabel1 = null;
    private IntegerWidget nb = null;
    private JComboBox kind = null;
    private JPanel jPanel = null;
    private JLabel jLabel2 = null;
    private IntegerWidget day = null;
    private DateStepper currentDateStepper;
    private Date currentNextDate;
    private JLabel jLabel3 = null;
    private DateWidget lastDate = null;

    public GenerationPanel() {
        this.initialize();
    }

    private void initialize() {
        this.jLabel3 = new JLabel();
        this.jLabel3.setText(LocalizationData.get("PeriodicalTransactionDialog.until"));
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridwidth = 3;
        gridBagConstraints11.anchor = 17;
        gridBagConstraints11.gridy = 1;
        this.jLabel1 = new JLabel();
        this.jLabel1.setText(LocalizationData.get("PeriodicalTransactionDialog.period"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridx = 2;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints1.anchor = 13;
        gridBagConstraints1.gridy = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(LocalizationData.get("PeriodicalTransactionDialog.nextDate"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        this.setSize(400, 165);
        this.setLayout(new GridBagLayout());
        this.setActivated(true);
        this.add((Component)this.getActivatedBox(), gridBagConstraints);
        this.add((Component)jLabel, gridBagConstraints1);
        this.add((Component)this.getDate(), gridBagConstraints2);
        this.add((Component)this.getJPanel(), gridBagConstraints11);
        this.updateDateStepper();
        this.currentNextDate = this.getDate().getDate();
    }

    private JCheckBox getActivatedBox() {
        if (this.activatedBox == null) {
            this.activatedBox = new JCheckBox();
            this.activatedBox.setText(LocalizationData.get("PeriodicalTransactionDialog.activated"));
            this.activatedBox.setSelected(true);
            this.activatedBox.setToolTipText(LocalizationData.get("PeriodicalTransactionDialog.activated.toolTip"));
            this.activatedBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    GenerationPanel.this.firePropertyChange(GenerationPanel.ACTIVATED_PROPERTY, !GenerationPanel.this.activatedBox.isSelected(), GenerationPanel.this.activatedBox.isSelected());
                }
            });
        }
        return this.activatedBox;
    }

    public boolean isActivated() {
        return this.getActivatedBox().isSelected();
    }

    public void setActivated(boolean activated) {
        this.getActivatedBox().setSelected(activated);
    }

    private DateWidget getDate() {
        if (this.date == null) {
            this.date = new DateWidget();
            this.date.setLocale(LocalizationData.getLocale());
            this.date.addPropertyChangeListener("date", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Date old = GenerationPanel.this.currentNextDate;
                    GenerationPanel.this.currentNextDate = GenerationPanel.this.date.getDate();
                    if (!GenerationPanel.this.areEquals(old, GenerationPanel.this.currentNextDate)) {
                        GenerationPanel.this.firePropertyChange(GenerationPanel.NEXT_DATE_PROPERTY, old, GenerationPanel.this.currentNextDate);
                    }
                }
            });
            this.date.getDateField().addFocusListener(AutoSelectFocusListener.INSTANCE);
            this.date.setToolTipText(LocalizationData.get("PeriodicalTransactionDialog.nextDate.toolTip"));
        }
        return this.date;
    }

    public Date getNextDate() {
        return this.currentNextDate;
    }

    public boolean getNextDateIsValid() {
        return this.getDate().isContentValid();
    }

    public void setNextDate(Date next) {
        if (!this.areEquals(next, this.currentNextDate)) {
            Date old = this.currentNextDate;
            this.currentNextDate = next;
            this.getDate().setDate(this.currentNextDate);
            this.firePropertyChange(NEXT_DATE_PROPERTY, old, this.currentNextDate);
        }
    }

    private boolean areEquals(Date d1, Date d2) {
        if (d1 == null) {
            return d2 == null;
        }
        return d1.equals(d2);
    }

    private IntegerWidget getNb() {
        if (this.nb == null) {
            this.nb = new IntegerWidget(BigInteger.ONE, IntegerWidget.INTEGER_MAX_VALUE);
            this.nb.addFocusListener(AutoSelectFocusListener.INSTANCE);
            this.nb.addPropertyChangeListener("VALUE_PROPERTY", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GenerationPanel.this.updateDateStepper();
                }
            });
            this.nb.setColumns(2);
            this.nb.setToolTipText(LocalizationData.get("PeriodicalTransactionDialog.step.toolTip"));
        }
        return this.nb;
    }

    private JComboBox getKind() {
        if (this.kind == null) {
            String[] kinds = new String[]{LocalizationData.get("PeriodicalTransactionDialog.years"), LocalizationData.get("PeriodicalTransactionDialog.months"), LocalizationData.get("PeriodicalTransactionDialog.days")};
            this.kind = new JComboBox<String>(kinds);
            this.kind.setSelectedIndex(1);
            this.kind.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean visible = GenerationPanel.this.isMonthly() || GenerationPanel.this.isYearly();
                    GenerationPanel.this.jLabel2.setVisible(visible);
                    GenerationPanel.this.day.setVisible(visible);
                    GenerationPanel.this.updateDateStepper();
                }
            });
        }
        return this.kind;
    }

    private void updateDateStepper() {
        DateStepper newStepper;
        if (this.nb.getValue() == null) {
            newStepper = null;
        } else if (this.isMonthly() || this.isYearly()) {
            if (this.day.getValue() == null) {
                newStepper = null;
            } else {
                int value = this.nb.getValue().intValue();
                newStepper = new MonthDateStepper(this.isMonthly() ? value : value * 12, this.day.getValue().intValue(), this.getLastDate().getDate());
            }
        } else {
            newStepper = new DayDateStepper(this.nb.getValue().intValue(), this.getLastDate().getDate());
        }
        if (!NullUtils.areEquals(newStepper, this.currentDateStepper)) {
            DateStepper old = this.currentDateStepper;
            this.currentDateStepper = newStepper;
            this.firePropertyChange(DATE_STEPPER_PROPERTY, old, this.currentDateStepper);
        }
    }

    public DateStepper getDateStepper() {
        return this.currentDateStepper;
    }

    public void setDateStepper(DateStepper nextDateBuilder) {
        if (NullUtils.areEquals(nextDateBuilder, this.currentDateStepper)) {
            return;
        }
        if (nextDateBuilder instanceof MonthDateStepper) {
            MonthDateStepper monthStepper = (MonthDateStepper)nextDateBuilder;
            if (monthStepper.getPeriod() % 12 == 0) {
                this.nb.setValue(monthStepper.getPeriod() / 12);
                this.kind.setSelectedIndex(0);
            } else {
                this.nb.setValue(monthStepper.getPeriod());
                this.kind.setSelectedIndex(1);
            }
            this.day.setValue(monthStepper.getDay());
            this.getLastDate().setDate(nextDateBuilder.getLastDate());
        } else if (nextDateBuilder instanceof DayDateStepper) {
            this.kind.setSelectedIndex(2);
            this.nb.setValue(((DayDateStepper)nextDateBuilder).getStep());
            this.getLastDate().setDate(nextDateBuilder.getLastDate());
        } else if (nextDateBuilder == null) {
            this.kind.setSelectedIndex(1);
            this.nb.setText("");
            this.day.setText("");
        } else {
            throw new IllegalArgumentException();
        }
        DateStepper old = this.currentDateStepper;
        this.currentDateStepper = nextDateBuilder;
        this.firePropertyChange(DATE_STEPPER_PROPERTY, old, this.currentDateStepper);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 3;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints9.gridx = 6;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.gridx = 5;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 3;
            gridBagConstraints7.gridx = 4;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints7.weightx = 1.0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 3;
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints6.gridy = 0;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText(LocalizationData.get("PeriodicalTransactionDialog.the"));
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 3;
            gridBagConstraints5.weightx = 1.0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints4.gridx = -1;
            gridBagConstraints4.gridy = -1;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.fill = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridx = -1;
            gridBagConstraints3.gridy = -1;
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.jLabel1, gridBagConstraints3);
            this.jPanel.add((Component)this.getNb(), gridBagConstraints4);
            this.jPanel.add((Component)this.getKind(), gridBagConstraints5);
            this.jPanel.add((Component)this.jLabel2, gridBagConstraints6);
            this.jPanel.add((Component)this.getDay(), gridBagConstraints7);
            this.jPanel.add((Component)this.jLabel3, gridBagConstraints8);
            this.jPanel.add((Component)this.getLastDate(), gridBagConstraints9);
        }
        return this.jPanel;
    }

    private IntegerWidget getDay() {
        if (this.day == null) {
            this.day = new IntegerWidget(BigInteger.ONE, BigInteger.valueOf(31L));
            this.day.addFocusListener(AutoSelectFocusListener.INSTANCE);
            this.day.addPropertyChangeListener("VALUE_PROPERTY", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GenerationPanel.this.updateDateStepper();
                }
            });
            this.day.setToolTipText(LocalizationData.get("PeriodicalTransactionDialog.day.toolTip"));
            this.day.setColumns(2);
        }
        return this.day;
    }

    private boolean isYearly() {
        return this.kind.getSelectedIndex() == 0;
    }

    private boolean isMonthly() {
        return this.kind.getSelectedIndex() == 1;
    }

    private DateWidget getLastDate() {
        if (this.lastDate == null) {
            this.lastDate = new DateWidget();
            this.lastDate.setLocale(LocalizationData.getLocale());
            this.lastDate.setDate(null);
            this.lastDate.setToolTipText(LocalizationData.get("PeriodicalTransactionDialog.lastDate.toolTip"));
            this.lastDate.getDateField().addFocusListener(AutoSelectFocusListener.INSTANCE);
            this.lastDate.addPropertyChangeListener("date", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GenerationPanel.this.updateDateStepper();
                }
            });
        }
        return this.lastDate;
    }

    public boolean getLastDateIsValid() {
        return this.getLastDate().isContentValid();
    }
}

