/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.widget.date.DateWidget;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.yapbam.data.AbstractTransaction;
import net.yapbam.data.Category;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.data.SubTransaction;
import net.yapbam.data.Transaction;
import net.yapbam.date.helpers.DateStepper;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.dialogs.AbstractPredefinedComputer;
import net.yapbam.gui.dialogs.AbstractTransactionDialog;
import net.yapbam.gui.dialogs.AlertDialog;
import net.yapbam.gui.dialogs.CheckNumberWidget;
import net.yapbam.gui.dialogs.EditAccountDialog;
import net.yapbam.gui.dialogs.SubTransactionPanel;
import net.yapbam.gui.dialogs.transaction.AmountWizard;
import net.yapbam.gui.dialogs.transaction.CategoryAndType;
import net.yapbam.gui.dialogs.transaction.EditionWizard;
import net.yapbam.gui.dialogs.transaction.ModeWizard;
import net.yapbam.gui.preferences.EditingSettings;

public class TransactionDialog
extends AbstractTransactionDialog<Transaction> {
    private static final long serialVersionUID = 1L;
    private DateWidget date;
    private JTextField transactionNumber;
    private CheckNumberWidget checkNumber;
    private DateWidget defDate;
    private JTextField statement;
    private boolean checkNumberIsVisible;
    private boolean editionMode;
    private static final int DATE_CHANGED = 1;
    private static final int VALUE_DATE_CHANGED = 2;
    private JButton nextButton;

    public static Transaction open(GlobalData data, Window owner, Transaction transaction, boolean edit, boolean autoAdd, boolean withNextButton) {
        if (edit && withNextButton) {
            throw new IllegalArgumentException();
        }
        if (data.getAccountsNumber() == 0) {
            EditAccountDialog.open(data, owner, LocalizationData.get("TransactionDialog.needAccount"));
            if (data.getAccountsNumber() == 0) {
                return null;
            }
        }
        TransactionDialog dialog = new TransactionDialog(owner, data, transaction, edit);
        if (withNextButton) {
            dialog.nextButton.setVisible(true);
            dialog.getRootPane().setDefaultButton(dialog.nextButton);
        }
        dialog.setVisible(true);
        Transaction newTransaction = dialog.getTransaction();
        if (newTransaction != null && autoAdd) {
            EditingSettings editingOptions = Preferences.INSTANCE.getEditionSettings();
            if (editingOptions.isAlertOnModifyChecked() && transaction != null && transaction.getStatement() != null) {
                boolean alert = !transaction.getAccount().equals(newTransaction.getAccount());
                alert = alert || GlobalData.AMOUNT_COMPARATOR.compare(transaction.getAmount(), newTransaction.getAmount()) != 0;
                alert = alert || !transaction.getValueDate().equals(newTransaction.getValueDate());
                alert = alert || !NullUtils.areEquals(transaction.getNumber(), newTransaction.getNumber());
                boolean bl = alert = alert || !NullUtils.areEquals(transaction.getStatement(), newTransaction.getStatement());
                if (alert) {
                    AlertDialog alertDial = new AlertDialog(owner, LocalizationData.get("ModifyCheckedTransactionAlert.title"), LocalizationData.get("ModifyCheckedTransactionAlert.message"));
                    alertDial.setVisible(true);
                    if (alertDial.getResult() == null) {
                        return null;
                    }
                    if (((Boolean)alertDial.getResult()).booleanValue()) {
                        editingOptions.setAlertOnModifyChecked(false);
                        Preferences.INSTANCE.setEditingOptions(editingOptions);
                    }
                }
            }
            data.add(newTransaction);
            if (transaction != null) {
                data.remove(transaction);
            }
        }
        return newTransaction;
    }

    public TransactionDialog(Window owner, final GlobalData data, Transaction transaction, boolean edit) {
        super(owner, edit ? LocalizationData.get("TransactionDialog.title.edit") : LocalizationData.get("TransactionDialog.title.new"), data, transaction);
        this.editionMode = edit;
        this.amount.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean negativeOld;
                Double newValue = (Double)evt.getNewValue();
                Double oldValue = (Double)evt.getOldValue();
                boolean negativeNew = newValue != null && newValue < 0.0;
                boolean bl = negativeOld = oldValue != null && oldValue < 0.0;
                if (negativeNew && !negativeOld || negativeOld && !negativeNew) {
                    TransactionDialog.this.setTransactionNumberWidget();
                }
            }
        });
        if (this.useCheckbook() && !edit) {
            this.checkNumber.setAccount(data, this.getAccount());
        }
        this.setPredefinedDescriptionComputer(new AbstractPredefinedComputer(data){

            @Override
            protected void process(Transaction transaction) {
                double ranking = EditionWizard.getRankingBasedOnDate(this.now, transaction);
                if (!transaction.getAccount().equals(TransactionDialog.this.getAccount())) {
                    ranking /= 100.0;
                }
                super.add(transaction.getDescription(), ranking);
            }
        });
        this.subtransactionsPanel.setPredefinedDescriptionComputer(new AbstractPredefinedComputer(data){

            @Override
            protected void process(Transaction transaction) {
                double ranking = EditionWizard.getRankingBasedOnDate(this.now, transaction);
                if (!transaction.getAccount().equals(TransactionDialog.this.getAccount())) {
                    ranking /= 100.0;
                }
                super.add(transaction.getDescription(), ranking / 10.0);
                for (int i = 0; i < transaction.getSubTransactionSize(); ++i) {
                    super.add(transaction.getSubTransaction(i).getDescription(), ranking);
                }
            }
        });
        this.subtransactionsPanel.setPredefinedDescriptionUpdater(new SubTransactionPanel.PredefinedDescriptionUpdater(){
            private String lastDescription;
            private Category category;
            private double amount;

            @Override
            public Category getCategory(String description) {
                this.update(description);
                return this.category;
            }

            @Override
            public double getAmount(String description, double amount) {
                this.amount = amount;
                this.update(description);
                return this.amount;
            }

            private void update(String description) {
                if (description == null) {
                    this.category = null;
                    this.amount = 0.0;
                    return;
                }
                if (!NullUtils.areEquals(this.lastDescription, description)) {
                    this.lastDescription = description;
                    long now = System.currentTimeMillis();
                    HashMap<CategoryAndType, Double> map = new HashMap<CategoryAndType, Double>();
                    GlobalData gData = data;
                    for (int i = 0; i < gData.getTransactionsNumber(); ++i) {
                        Transaction transaction = gData.getTransaction(i);
                        double ranking = EditionWizard.getRankingBasedOnDate(now, transaction);
                        if (!transaction.getAccount().equals(TransactionDialog.this.getAccount())) {
                            ranking /= 100.0;
                        }
                        if (transaction.getDescription().equalsIgnoreCase(description)) {
                            this.add(map, transaction.getCategory(), transaction.getAmount() > 0.0, ranking / 10.0);
                        }
                        for (int j = 0; j < transaction.getSubTransactionSize(); ++j) {
                            SubTransaction sub = transaction.getSubTransaction(j);
                            if (!sub.getDescription().equalsIgnoreCase(description)) continue;
                            this.add(map, sub.getCategory(), sub.getAmount() > 0.0, ranking);
                        }
                    }
                    CategoryAndType ct = (CategoryAndType)EditionWizard.getHeaviest(map);
                    this.category = ct.getCategory();
                    if (!ct.isReceipt() && this.amount > 0.0) {
                        this.amount = -this.amount;
                    } else if (ct.isReceipt()) {
                        if (GlobalData.AMOUNT_COMPARATOR.compare(this.amount, 0.0) == 0) {
                            this.amount = Double.MIN_VALUE;
                        } else if (this.amount < 0.0) {
                            this.amount = Math.abs(this.amount);
                        }
                    }
                }
            }

            private void add(Map<CategoryAndType, Double> map, Category category, boolean receipt, double ranking) {
                CategoryAndType ct = new CategoryAndType(receipt, category);
                ranking = map.containsKey(ct) ? map.get(ct) + ranking : ranking;
                map.put(ct, ranking);
            }
        });
        if (this.statement.getText().length() == 0) {
            this.autoFillStatement();
        }
    }

    public void setTransactionDate(Date date) {
        this.date.setDate(date);
    }

    public void setStatement(String statement) {
        this.statement.setText(statement == null ? "" : statement);
    }

    @Override
    protected void setContent(AbstractTransaction transaction) {
        super.setContent(transaction);
        this.ignoreEvents = true;
        Transaction t = (Transaction)transaction;
        this.date.setDate(t.getDate());
        this.transactionNumber.setText(t.getNumber());
        this.checkNumber.setText(t.getNumber());
        this.defDate.setDate(t.getValueDate());
        this.statement.setText(t.getStatement());
        this.ignoreEvents = false;
    }

    @Override
    protected Transaction buildResult() {
        String number;
        double amount = this.getAmount();
        String statementId = this.statement.getText().trim();
        if (statementId.length() == 0) {
            statementId = null;
        }
        if ((number = this.transactionNumber.getText().trim()).length() == 0) {
            number = null;
        }
        ArrayList<SubTransaction> subTransactions = new ArrayList<SubTransaction>();
        for (int i = 0; i < this.subtransactionsPanel.getSubtransactionsCount(); ++i) {
            subTransactions.add(this.subtransactionsPanel.getSubtransaction(i));
        }
        return new Transaction(this.date.getDate(), number, this.description.getText().trim(), this.comment.getText().trim(), amount, this.getAccount(), this.getCurrentMode(), (Category)this.categories.get(), this.defDate.getDate(), statementId, subTransactions);
    }

    @Override
    protected void buildStatementFields(JPanel centerPane, FocusListener focusListener, GridBagConstraints c) {
        centerPane.add((Component)new JLabel(LocalizationData.get("TransactionDialog.valueDate")), c);
        this.defDate = new DateWidget();
        this.defDate.setLocale(LocalizationData.getLocale());
        this.defDate.setToolTipText(LocalizationData.get("TransactionDialog.valueDate.tooltip"));
        this.defDate.getDateField().addFocusListener(focusListener);
        this.defDate.addPropertyChangeListener("date", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!TransactionDialog.this.ignoreEvents) {
                    TransactionDialog.this.autoFillStatement(2);
                    TransactionDialog.this.updateOkButtonEnabled();
                }
            }
        });
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 2;
        centerPane.add((Component)this.defDate, c);
        c.gridx = 2;
        c.fill = 0;
        c.weightx = 0.0;
        centerPane.add((Component)new JLabel(LocalizationData.get("TransactionDialog.statement")), c);
        this.statement = new JTextField(15);
        this.statement.setToolTipText(LocalizationData.get("TransactionDialog.statement.tooltip"));
        this.statement.addFocusListener(focusListener);
        c.gridx = 3;
        c.fill = 2;
        c.weightx = 1.0;
        centerPane.add((Component)this.statement, c);
    }

    @Override
    protected void buildNumberField(JPanel centerPane, FocusListener focusListener, GridBagConstraints c) {
        c.fill = 0;
        c.weightx = 0.0;
        centerPane.add((Component)new JLabel(LocalizationData.get("TransactionDialog.number")), c);
        JPanel alternateNumberFields = new JPanel(new CardLayout());
        this.transactionNumber = new JTextField(15);
        this.transactionNumber.setToolTipText(LocalizationData.get("TransactionDialog.number.tooltip"));
        this.transactionNumber.addFocusListener(focusListener);
        this.checkNumber = new CheckNumberWidget();
        this.checkNumber.addPropertyChangeListener("Number", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TransactionDialog.this.transactionNumber.setText(TransactionDialog.this.checkNumber.getNumber());
            }
        });
        alternateNumberFields.add((Component)this.checkNumber, this.checkNumber.getClass().getName());
        alternateNumberFields.add((Component)this.transactionNumber, this.transactionNumber.getClass().getName());
        CardLayout layout = (CardLayout)alternateNumberFields.getLayout();
        layout.last(alternateNumberFields);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        centerPane.add((Component)alternateNumberFields, c);
        ++c.gridx;
    }

    @Override
    protected void buildDateField(JPanel centerPane, FocusListener focusListener, GridBagConstraints c) {
        JLabel titleDate = new JLabel(LocalizationData.get("TransactionDialog.date"));
        centerPane.add((Component)titleDate, c);
        this.date = new DateWidget();
        this.date.setLocale(LocalizationData.getLocale());
        this.date.setToolTipText(LocalizationData.get("TransactionDialog.date.tooltip"));
        this.date.getDateField().addFocusListener(focusListener);
        this.date.addPropertyChangeListener("date", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!TransactionDialog.this.ignoreEvents) {
                    if (evt.getNewValue() != null) {
                        DateStepper vdc;
                        Mode m = TransactionDialog.this.getCurrentMode();
                        DateStepper dateStepper = vdc = TransactionDialog.this.isExpense() ? m.getExpenseVdc() : m.getReceiptVdc();
                        if (vdc == null) {
                            vdc = DateStepper.IMMEDIATE;
                        }
                        TransactionDialog.this.defDate.setDate(vdc.getNextStep(TransactionDialog.this.date.getDate()));
                    }
                    TransactionDialog.this.autoFillStatement(1);
                    TransactionDialog.this.updateOkButtonEnabled();
                }
            }
        });
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 2;
        centerPane.add((Component)this.date, c);
        ++c.gridx;
    }

    @Override
    public Transaction getTransaction() {
        return (Transaction)super.getResult();
    }

    @Override
    protected void optionnalUpdatesOnModeChange() {
        DateStepper vdc;
        this.setTransactionNumberWidget();
        Mode mode = this.getCurrentMode();
        DateStepper dateStepper = vdc = this.isExpense() ? mode.getExpenseVdc() : mode.getReceiptVdc();
        if (vdc != null && this.date.getDate() != null) {
            this.defDate.setDate(vdc.getNextStep(this.date.getDate()));
        }
    }

    @Override
    protected String getOkDisabledCause() {
        String disabledCause = super.getOkDisabledCause();
        if (disabledCause != null) {
            return disabledCause;
        }
        if (this.date.getDate() == null) {
            return LocalizationData.get("TransactionDialog.bad.date");
        }
        if (this.defDate.getDate() == null) {
            return LocalizationData.get("TransactionDialog.bad.valueDate");
        }
        return null;
    }

    @Override
    protected void predefinedDescriptionSelected(String description) {
        if (this.editionMode) {
            return;
        }
        EditionWizard<CategoryAndType> cWizard = new EditionWizard<CategoryAndType>((GlobalData)this.data, description){

            @Override
            protected CategoryAndType getValue(Transaction transaction) {
                return new CategoryAndType(transaction.getAmount() > 0.0, transaction.getCategory());
            }
        };
        boolean isReceipt = ((CategoryAndType)cWizard.get()).isReceipt();
        this.categories.set(((CategoryAndType)cWizard.get()).getCategory());
        this.receipt.setSelected(isReceipt);
        ModeWizard mWizard = new ModeWizard((GlobalData)this.data, description, this.getAccount(), isReceipt);
        Mode mode = (Mode)mWizard.get();
        if (mode != null) {
            this.setMode(mode);
        } else {
            boolean ok;
            boolean bl = ok = isReceipt ? this.getCurrentMode().isUsableForReceipt() : this.getCurrentMode().isUsableForExpense();
            if (!ok) {
                this.setMode(Mode.UNDEFINED);
            }
        }
        AmountWizard aWizard = new AmountWizard((GlobalData)this.data, description, this.getAmount(), isReceipt);
        Double autoAmount = aWizard.get();
        if (autoAmount != null) {
            this.amount.setValue(Math.abs(autoAmount));
        }
    }

    private void setTransactionNumberWidget() {
        boolean checkNumberRequired = this.useCheckbook();
        if (checkNumberRequired != this.checkNumberIsVisible) {
            if (!checkNumberRequired) {
                this.transactionNumber.setText("");
            } else {
                this.checkNumber.setAccount((GlobalData)this.data, this.getAccount());
            }
            Container parent = this.checkNumber.getParent();
            CardLayout layout = (CardLayout)parent.getLayout();
            if (checkNumberRequired) {
                layout.first(parent);
            } else {
                layout.last(parent);
            }
            this.checkNumberIsVisible = !this.checkNumberIsVisible;
        } else if (checkNumberRequired && !NullUtils.areEquals(this.checkNumber.getAccount(), this.getAccount())) {
            this.checkNumber.setAccount((GlobalData)this.data, this.getAccount());
        }
    }

    private boolean useCheckbook() {
        return this.isExpense() && this.getCurrentMode().isUseCheckBook();
    }

    private void autoFillStatement(int changed) {
        EditingSettings editOptions = Preferences.INSTANCE.getEditionSettings();
        if (editOptions.isAutoFillStatement()) {
            Date aDate = null;
            if ((changed & 1) != 0 && !editOptions.isDateBasedAutoStatement()) {
                aDate = this.date.getDate();
            } else if ((changed & 2) != 0 && editOptions.isDateBasedAutoStatement()) {
                aDate = this.defDate.getDate();
            }
            if (aDate != null) {
                this.statement.setText(editOptions.getStatementId(aDate));
            }
        }
    }

    public void autoFillStatement() {
        this.autoFillStatement(3);
    }

    @Override
    protected JPanel createButtonsPane() {
        super.createButtonsPane();
        JPanel result = new JPanel();
        super.createButtonsPane();
        result.add(this.getOkButton());
        this.nextButton = new JButton(LocalizationData.get("TransactionDialog.next"));
        this.nextButton.setToolTipText(LocalizationData.get("TransactionDialog.next.tooltip"));
        this.nextButton.setVisible(false);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GlobalData)TransactionDialog.this.data).add(TransactionDialog.this.buildResult());
                TransactionDialog.this.description.requestFocus();
                Date today = TransactionDialog.this.date.getDate();
                TransactionDialog.this.setContent(new Transaction(today, null, "", null, 0.0, TransactionDialog.this.getAccount(), Mode.UNDEFINED, Category.UNDEFINED, today, null, new ArrayList<SubTransaction>()));
                TransactionDialog.this.optionnalUpdatesOnModeChange();
                TransactionDialog.this.autoFillStatement();
            }
        });
        result.add(this.nextButton);
        result.add(this.getCancelButton());
        return result;
    }

    @Override
    public void updateOkButtonEnabled() {
        super.updateOkButtonEnabled();
        this.nextButton.setEnabled(this.getOkButton().isEnabled());
    }
}

