/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.export;

import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.ErrorManager;
import net.yapbam.gui.HelpManager;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.dialogs.export.EmptyImportFileException;
import net.yapbam.gui.dialogs.export.ImportPanel;
import net.yapbam.gui.dialogs.export.Importer;
import net.yapbam.gui.dialogs.export.ImporterParameters;
import net.yapbam.gui.util.AutoUpdateOkButtonPropertyListener;

public class ImportDialog
extends AbstractDialog<Container, Importer> {
    private ImportPanel importPanel;
    private static File lastFile;
    private transient IOException instantiateException;

    public ImportDialog(Window owner, GlobalData data, File file) throws IOException {
        super(owner, LocalizationData.get("ImportDialog.title"), new Container(file, data));
        if (this.instantiateException != null) {
            throw this.instantiateException;
        }
    }

    @Override
    protected Importer buildResult() {
        Importer importer = this.importPanel.getImporter();
        ImporterParameters parameters = importer.getParameters();
        YapbamState.INSTANCE.save(this.getStateKey(), parameters);
        lastFile = importer.getFile();
        return importer;
    }

    private String getOldStateKey(Class<?> saved) {
        return this.getClass().getCanonicalName() + "." + saved.getName();
    }

    private String getStateKey() {
        return this.getClass().getCanonicalName() + ".params";
    }

    @Override
    protected JPanel createCenterPane() {
        this.importPanel = new ImportPanel();
        this.importPanel.setData(((Container)this.data).data);
        try {
            this.importPanel.setFile(((Container)this.data).file);
            this.importPanel.setLine(0);
        }
        catch (IOException e) {
            this.instantiateException = e;
        }
        if (this.instantiateException == null) {
            this.importPanel.addPropertyChangeListener("invalidityCause", new AutoUpdateOkButtonPropertyListener(this));
            ImporterParameters parameters = (ImporterParameters)YapbamState.INSTANCE.restore(this.getStateKey());
            if (parameters == null && (parameters = (ImporterParameters)YapbamState.INSTANCE.restore(this.getOldStateKey(ImporterParameters.class))) != null) {
                YapbamState.INSTANCE.remove(this.getOldStateKey(ImporterParameters.class));
                YapbamState.INSTANCE.save(this.getStateKey(), parameters);
            }
            if (parameters != null) {
                this.importPanel.setParameters(parameters);
            }
        }
        return this.importPanel;
    }

    @Override
    protected String getOkDisabledCause() {
        return this.importPanel.getInvalidityCause();
    }

    @Override
    public void setVisible(boolean visible) {
        this.pack();
        super.setVisible(visible);
    }

    public boolean getAddToCurrentData() {
        return this.importPanel.getAddToCurrentData();
    }

    public static void doError(Component parent, IOException e) {
        String title = LocalizationData.get("ImportDialog.errorMessage.title");
        if (e instanceof EmptyImportFileException) {
            JOptionPane.showMessageDialog(parent, LocalizationData.get("ImportDialog.error.emptyFile"), title, 0);
        } else if (e instanceof FileNotFoundException) {
            JOptionPane.showMessageDialog(parent, LocalizationData.get("ImportDialog.error.unknownFile"), title, 0);
        } else {
            ErrorManager.INSTANCE.display(parent, e);
        }
    }

    @Override
    protected JComponent createExtraComponent() {
        JLabel jLabel = new JLabel();
        jLabel.setText(LocalizationData.get("ImportDialog.help"));
        jLabel.setIcon(IconManager.get(IconManager.Name.HELP));
        jLabel.setToolTipText(LocalizationData.get("ImportDialog.help.toolTip"));
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HelpManager.show((Component)ImportDialog.this.importPanel, HelpManager.IMPORT);
                super.mouseClicked(e);
            }
        });
        return jLabel;
    }

    public static File getLastFile() {
        return lastFile;
    }

    static final class Container {
        File file;
        GlobalData data;

        public Container(File file, GlobalData data) {
            this.file = file;
            this.data = data;
        }
    }
}

