/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.export;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.widget.CharWidget;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;

public class SeparatorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String SEPARATOR_PROPERTY = "separator";
    private JRadioButton defaultSeparatorButton;
    private JRadioButton customSeparatorButton;
    private CharWidget customSeparatorValue;
    private char defaultSeparator;
    private char separator;
    private JLabel errorLabel;

    public static SeparatorPanel createDecimalSeparatorPanel() {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        String defaultSeparatorWording = LocalizationData.get("ExportDialog.decimalSeparator.defaultSeparator");
        char decimalSeparator = format.getDecimalFormatSymbols().getDecimalSeparator();
        defaultSeparatorWording = Formatter.format(defaultSeparatorWording, Character.valueOf(decimalSeparator));
        return new SeparatorPanel(LocalizationData.get("ExportDialog.decimalSeparator"), defaultSeparatorWording, LocalizationData.get("ExportDialog.decimalSeparator.defaultSeparator.toolTip"), LocalizationData.get("ExportDialog.columnSeparator.customized"), LocalizationData.get("ExportDialog.decimalSeparator.customized.toolTip"), LocalizationData.get("ExportDialog.decimalSeparator.customizedChar.toolTip"), decimalSeparator);
    }

    public static SeparatorPanel createColumnSeparatorPanel() {
        return new SeparatorPanel(LocalizationData.get("ExportDialog.columnSeparator"), LocalizationData.get("ExportDialog.columnSeparator.defaultSeparator"), LocalizationData.get("ExportDialog.columnSeparator.defaultSeparator.toolTip"), LocalizationData.get("ExportDialog.columnSeparator.customized"), LocalizationData.get("ExportDialog.columnSeparator.customized.toolTip"), LocalizationData.get("ExportDialog.columnSeparator.customizedChar.toolTip"), '\t');
    }

    private SeparatorPanel(String title, String defaultSeparatorWording, String defaultSeparatorToolTip, String customizedSeparatorWording, String customizedSeparatorToolTip, String customizedCharToolTip, char defaultSeparator) {
        this.defaultSeparator = defaultSeparator;
        this.separator = defaultSeparator;
        this.initialize(title, defaultSeparatorWording, defaultSeparatorToolTip, customizedSeparatorWording, customizedSeparatorToolTip, customizedCharToolTip);
    }

    private void initialize(String title, String defaultSeparatorWording, String defaultSeparatorToolTip, String customizedSeparatorWording, String customizedSeparatorToolTip, String customizedCharToolTip) {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 3;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints2.gridx = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, title, 0, 0));
        JRadioButton btn = this.getDefaultSeparatorButton();
        btn.setText(defaultSeparatorWording);
        btn.setToolTipText(defaultSeparatorToolTip);
        this.add((Component)btn, gridBagConstraints);
        btn = this.getCustomSeparatorButton();
        btn.setText(customizedSeparatorWording);
        btn.setToolTipText(customizedSeparatorToolTip);
        this.add((Component)btn, gridBagConstraints1);
        this.getCustomSeparatorValue().setToolTipText(customizedCharToolTip);
        this.add((Component)this.getCustomSeparatorValue(), gridBagConstraints2);
        ButtonGroup group = new ButtonGroup();
        group.add(this.getDefaultSeparatorButton());
        group.add(this.getCustomSeparatorButton());
        GridBagConstraints gbcErrorLabel = new GridBagConstraints();
        gbcErrorLabel.weightx = 1.0;
        gbcErrorLabel.anchor = 17;
        gbcErrorLabel.gridx = 2;
        gbcErrorLabel.gridy = 1;
        this.add((Component)this.getErrorLabel(), gbcErrorLabel);
    }

    private JRadioButton getDefaultSeparatorButton() {
        if (this.defaultSeparatorButton == null) {
            this.defaultSeparatorButton = new JRadioButton();
            this.defaultSeparatorButton.setSelected(true);
        }
        return this.defaultSeparatorButton;
    }

    private JRadioButton getCustomSeparatorButton() {
        if (this.customSeparatorButton == null) {
            this.customSeparatorButton = new JRadioButton();
            this.customSeparatorButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (SeparatorPanel.this.customSeparatorButton.isSelected()) {
                        if (SeparatorPanel.this.customSeparatorValue.getText().length() == 0) {
                            SeparatorPanel.this.setSeparator(',');
                        } else {
                            SeparatorPanel.this.setSeparator(SeparatorPanel.this.customSeparatorValue.getText().charAt(0));
                        }
                    } else {
                        SeparatorPanel.this.setSeparator(SeparatorPanel.this.defaultSeparator);
                    }
                }
            });
        }
        return this.customSeparatorButton;
    }

    private CharWidget getCustomSeparatorValue() {
        if (this.customSeparatorValue == null) {
            this.customSeparatorValue = new CharWidget();
            this.customSeparatorValue.addPropertyChangeListener("char", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() == null) {
                        SeparatorPanel.this.defaultSeparatorButton.setSelected(true);
                    } else {
                        SeparatorPanel.this.setSeparator(SeparatorPanel.this.customSeparatorValue.getChar().charValue());
                    }
                }
            });
        }
        return this.customSeparatorValue;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        char old = this.separator;
        this.separator = separator;
        if (this.separator == this.defaultSeparator) {
            this.defaultSeparatorButton.setSelected(true);
        } else {
            this.customSeparatorValue.setText(new String(new char[]{separator}));
            this.customSeparatorButton.setSelected(true);
        }
        if (old != separator) {
            this.firePropertyChange(SEPARATOR_PROPERTY, old, separator);
        }
    }

    private JLabel getErrorLabel() {
        if (this.errorLabel == null) {
            this.errorLabel = new JLabel();
        }
        return this.errorLabel;
    }

    public void setError(String message) {
        if (message != null) {
            this.getErrorLabel().setText(message);
            this.getErrorLabel().setIcon(IconManager.get(IconManager.Name.ALERT));
        } else {
            this.getErrorLabel().setText("");
            this.getErrorLabel().setIcon(null);
        }
    }

    public String getError() {
        String result = this.getErrorLabel().getText();
        return result.isEmpty() ? null : result;
    }
}

