/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.filter;

import com.fathzer.jlocal.Formatter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.border.TitledBorder;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.filter.ConsistencyCheckedPanel;

public class NatureFilterPanel
extends ConsistencyCheckedPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox receipts;
    private JCheckBox expenses;
    private ItemListener CONSISTENCY_CHECKER_ITEM_LISTENER = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            NatureFilterPanel.this.checkConsistency();
        }
    };

    public NatureFilterPanel() {
        this.setBorder(new TitledBorder(null, LocalizationData.get("CustomFilterPanel.nature"), 4, 0, null, null));
        GridBagLayout gblReceiptsExpensesPanel = new GridBagLayout();
        this.setLayout(gblReceiptsExpensesPanel);
        GridBagConstraints gbcReceipts = new GridBagConstraints();
        gbcReceipts.anchor = 11;
        gbcReceipts.weighty = 1.0;
        gbcReceipts.insets = new Insets(0, 0, 0, 5);
        gbcReceipts.gridx = 0;
        gbcReceipts.gridy = 0;
        this.add((Component)this.getReceipts(), gbcReceipts);
        GridBagConstraints gbcExpenses = new GridBagConstraints();
        gbcExpenses.weighty = 1.0;
        gbcExpenses.anchor = 18;
        gbcExpenses.weightx = 1.0;
        gbcExpenses.gridx = 1;
        gbcExpenses.gridy = 0;
        this.add((Component)this.getExpenses(), gbcExpenses);
    }

    @Override
    protected String computeInconsistencyCause() {
        if (!this.getExpenses().isSelected() && !this.getReceipts().isSelected()) {
            return Formatter.format(LocalizationData.get("CustomFilterPanel.error.natureStatus"), LocalizationData.get("MainMenuBar.Expenses"), LocalizationData.get("MainMenuBar.Receipts"));
        }
        return null;
    }

    private JCheckBox getReceipts() {
        if (this.receipts == null) {
            this.receipts = new JCheckBox(LocalizationData.get("MainMenuBar.Receipts"));
            this.receipts.setToolTipText(LocalizationData.get("CustomFilterPanel.receipts.toolTip"));
            this.receipts.addItemListener(this.CONSISTENCY_CHECKER_ITEM_LISTENER);
        }
        return this.receipts;
    }

    private JCheckBox getExpenses() {
        if (this.expenses == null) {
            this.expenses = new JCheckBox(LocalizationData.get("MainMenuBar.Expenses"));
            this.expenses.setToolTipText(LocalizationData.get("CustomFilterPanel.expenses.toolTip"));
            this.expenses.addItemListener(this.CONSISTENCY_CHECKER_ITEM_LISTENER);
        }
        return this.expenses;
    }

    public boolean isReceiptsSelected() {
        return this.getReceipts().isSelected();
    }

    public boolean isExpensesSelected() {
        return this.getExpenses().isSelected();
    }

    public void setSelected(boolean receipts, boolean expenses) {
        this.getReceipts().setSelected(receipts);
        this.getExpenses().setSelected(expenses);
    }

    public void clear() {
        this.setSelected(true, true);
    }
}

