/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.graphics.balancehistory;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.graphics.balancehistory.Graduation;
import net.yapbam.gui.graphics.balancehistory.RuleBuilder;

class YAxis {
    public static final String SCALE_PROPERTY_NAME = "VERTICAL_SCALE";
    private Component owner;
    private double min;
    private double max;
    private int yOffset;
    private double yRatio;
    private List<Graduation> yGraduations;
    private int lastHeight;
    private int lastFontHeight;
    private double lastMin;
    private double lastMax;
    private PropertyChangeSupport pcSupport;
    private int scale;

    YAxis(Component owner) {
        this.owner = owner;
        this.scale = 1;
        this.setBounds(0.0, 0.0);
        this.pcSupport = new PropertyChangeSupport(this);
    }

    void setBounds(double min, double max) {
        if (GlobalData.AMOUNT_COMPARATOR.compare(min, max) == 0) {
            min -= 1.0;
            max += 1.0;
        }
        if (GlobalData.AMOUNT_COMPARATOR.compare(min, this.lastMin) != 0 || GlobalData.AMOUNT_COMPARATOR.compare(max, this.lastMax) != 0) {
            this.min = min;
            this.max = max;
            this.lastHeight = -1;
        }
    }

    public void setVerticalScale(int scale) {
        if (scale != this.scale) {
            double old = this.scale;
            this.scale = scale;
            this.lastHeight = -1;
            this.pcSupport.firePropertyChange(SCALE_PROPERTY_NAME, old, (Object)this.scale);
        }
    }

    public int getVerticalScale() {
        return this.scale;
    }

    private void update() {
        int parentHeight = this.owner.getSize().height;
        int fontHeight = this.owner.getFontMetrics(this.owner.getFont()).getHeight();
        if (parentHeight != this.lastHeight || fontHeight != this.lastFontHeight || GlobalData.AMOUNT_COMPARATOR.compare(this.min, this.lastMin) != 0 || GlobalData.AMOUNT_COMPARATOR.compare(this.max, this.lastMax) != 0) {
            this.lastMin = this.min;
            this.lastMax = this.max;
            this.lastFontHeight = fontHeight;
            this.lastHeight = parentHeight;
            this.yOffset = fontHeight + 2;
            double yVariation = this.max - this.min;
            if (yVariation == 0.0) {
                yVariation = 1.0;
            }
            this.yRatio = (double)(parentHeight - 2 * this.yOffset) / yVariation;
            this.computeYGraduations();
        }
    }

    private void computeYGraduations() {
        int y;
        FontMetrics fontMetrics = this.owner.getFontMetrics(this.owner.getFont());
        Dimension size = this.owner.getSize();
        int lineHeight = fontMetrics.getHeight();
        int h = lineHeight * 2;
        double step = RuleBuilder.getNormalizedStep((double)h / this.yRatio);
        this.yGraduations = new ArrayList<Graduation>();
        double current = 0.0;
        while ((y = this.getY(current += step)) > fontMetrics.getAscent() / 2 + 5) {
            this.yGraduations.add(new Graduation(y, current));
        }
        current = 0.0;
        while ((y = this.getY(current -= step)) < size.height - lineHeight) {
            this.yGraduations.add(new Graduation(y, current));
        }
    }

    int getY(double value) {
        this.update();
        return this.yOffset + (int)((this.lastMax - value) * this.yRatio);
    }

    public Iterator<Graduation> getYGraduations() {
        this.update();
        return this.yGraduations.iterator();
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcSupport.removePropertyChangeListener(listener);
    }
}

