/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.statementview;

import com.fathzer.soft.ajlib.swing.table.JTableSelector;
import com.fathzer.soft.ajlib.swing.table.RowSorter;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.yapbam.data.FilteredData;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;
import net.yapbam.gui.TransactionSelector;
import net.yapbam.gui.statementview.StatementCellRenderer;
import net.yapbam.gui.statementview.StatementTableModel;
import net.yapbam.gui.util.FriendlyTable;
import net.yapbam.gui.util.LinkEnabler;
import net.yapbam.gui.util.PaintedTable;
import net.yapbam.gui.util.TablePainter;

public class StatementTable
extends FriendlyTable
implements TransactionSelector,
PaintedTable {
    private static final long serialVersionUID = 1L;
    private Transaction[] lastSelected;
    private FilteredData data;
    private TablePainter painter;

    public StatementTable(FilteredData data) {
        this.data = data;
        StatementTableModel model = new StatementTableModel(this, new Transaction[0]);
        this.setModel(model);
        this.setAutoCreateRowSorter(true);
        StatementCellRenderer renderer = new StatementCellRenderer();
        this.setDefaultRenderer(Object.class, renderer);
        this.setDefaultRenderer(Double.class, renderer);
        this.setDefaultRenderer(Date.class, renderer);
        this.painter = new TablePainter(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getAlignment(int column) {
                return 2;
            }
        };
        LinkEnabler.enable(this, 1);
        this.getSelectionModel().setSelectionMode(2);
        this.setRowSorter(new RowSorter<StatementTableModel>(model));
        this.lastSelected = null;
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Transaction[] selectedTransactions;
                if (!e.getValueIsAdjusting() && !NullUtils.areEquals(selectedTransactions = StatementTable.this.getSelectedTransactions(), StatementTable.this.lastSelected)) {
                    StatementTable.this.firePropertyChange("selectedTransaction", StatementTable.this.lastSelected, selectedTransactions);
                    StatementTable.access$002(StatementTable.this, selectedTransactions);
                }
            }
        });
    }

    @Override
    public Transaction[] getSelectedTransactions() {
        int[] indexes = this.getSelectedRows();
        Transaction[] result = new Transaction[indexes.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((StatementTableModel)this.getModel()).getTransactions()[this.convertRowIndexToModel(indexes[i])];
        }
        return result;
    }

    @Override
    public void setSelectedTransactions(Transaction[] transactions) {
        JTableSelector<Transaction> selector = new JTableSelector<Transaction>((JTable)this){

            @Override
            public int getModelIndex(Transaction transaction) {
                return ((StatementTableModel)StatementTable.this.getModel()).find(transaction);
            }
        };
        selector.setSelected(transactions);
    }

    public GlobalData getGlobalData() {
        return this.data.getGlobalData();
    }

    @Override
    public FilteredData getFilteredData() {
        return this.data;
    }

    public void scrollToLastLine() {
        this.scrollRectToVisible(this.getCellRect(this.getRowCount() - 1, 0, true));
    }

    public void setTransactions(Transaction[] transactions) {
        ((StatementTableModel)this.getModel()).setTransactions(transactions);
    }

    @Override
    public TablePainter getPainter() {
        return this.painter;
    }

    static /* synthetic */ Transaction[] access$002(StatementTable x0, Transaction[] x1) {
        x0.lastSelected = x1;
        return x1;
    }
}

