/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.transfer;

import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import com.fathzer.soft.ajlib.swing.widget.date.DateWidget;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.date.helpers.DateStepper;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.AccountWidget;
import net.yapbam.gui.dialogs.ModeWidget;
import net.yapbam.gui.dialogs.ModeWidgetParams;
import net.yapbam.gui.dialogs.TransactionNumberWidget;
import net.yapbam.gui.widget.AutoSelectFocusListener;

public class FromOrToPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String ACCOUNT_PROPERTY = "account";
    public static final String VALUE_DATE_PROPERTY = "ValueDate";
    private AccountWidget accountWidget;
    private GlobalData data;
    private ModeWidget modeWidget;
    private JLabel lblAccount;
    private JLabel lblMode;
    private JLabel lblNumber;
    private TransactionNumberWidget numberField;
    private JLabel lblDateVal;
    private DateWidget valueDateField;
    private JLabel lblStatement;
    private TextWidget statementField;
    private boolean from;
    private Date date;
    private JLabel lblDescription;
    private JLabel lblComment;
    private TextWidget descriptionField;
    private JTextField commentField;

    public FromOrToPane(GlobalData data, boolean from) {
        this.from = from;
        this.data = data;
        this.initialize();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWeights = new double[]{0.0, 1.0};
        this.setLayout(gridBagLayout);
        GridBagConstraints gbcLblAccount = new GridBagConstraints();
        gbcLblAccount.anchor = 17;
        gbcLblAccount.insets = new Insets(0, 0, 5, 5);
        gbcLblAccount.gridx = 0;
        gbcLblAccount.gridy = 0;
        this.add((Component)this.getLblAccount(), gbcLblAccount);
        GridBagConstraints gbcAccountWidget = new GridBagConstraints();
        gbcAccountWidget.weightx = 1.0;
        gbcAccountWidget.fill = 2;
        gbcAccountWidget.insets = new Insets(0, 0, 5, 0);
        gbcAccountWidget.gridx = 1;
        gbcAccountWidget.gridy = 0;
        this.add((Component)this.getAccountWidget(), gbcAccountWidget);
        GridBagConstraints gbcDescriptionField = new GridBagConstraints();
        gbcDescriptionField.insets = new Insets(0, 0, 5, 0);
        gbcDescriptionField.fill = 2;
        gbcDescriptionField.gridx = 1;
        gbcDescriptionField.gridy = 1;
        this.add((Component)this.getDescriptionField(), gbcDescriptionField);
        GridBagConstraints gbcLblDescription = new GridBagConstraints();
        gbcLblDescription.anchor = 17;
        gbcLblDescription.insets = new Insets(0, 0, 5, 5);
        gbcLblDescription.gridx = 0;
        gbcLblDescription.gridy = 1;
        this.add((Component)this.getLblDescription(), gbcLblDescription);
        GridBagConstraints gbcLblComment = new GridBagConstraints();
        gbcLblComment.anchor = 17;
        gbcLblComment.insets = new Insets(0, 0, 5, 5);
        gbcLblComment.gridx = 0;
        gbcLblComment.gridy = 2;
        this.add((Component)this.getLblComment(), gbcLblComment);
        GridBagConstraints gbcCommentField = new GridBagConstraints();
        gbcCommentField.insets = new Insets(0, 0, 5, 0);
        gbcCommentField.fill = 2;
        gbcCommentField.gridx = 1;
        gbcCommentField.gridy = 2;
        this.add((Component)this.getCommentField(), gbcCommentField);
        GridBagConstraints gbcLblMode = new GridBagConstraints();
        gbcLblMode.anchor = 17;
        gbcLblMode.insets = new Insets(0, 0, 5, 5);
        gbcLblMode.gridx = 0;
        gbcLblMode.gridy = 3;
        this.add((Component)this.getLblMode(), gbcLblMode);
        GridBagConstraints gbcModeWidget = new GridBagConstraints();
        gbcModeWidget.insets = new Insets(0, 0, 5, 0);
        gbcModeWidget.fill = 2;
        gbcModeWidget.gridx = 1;
        gbcModeWidget.gridy = 3;
        this.add((Component)this.getModeWidget(), gbcModeWidget);
        GridBagConstraints gbcLblNumber = new GridBagConstraints();
        gbcLblNumber.anchor = 17;
        gbcLblNumber.insets = new Insets(0, 0, 5, 5);
        gbcLblNumber.gridx = 0;
        gbcLblNumber.gridy = 4;
        this.add((Component)this.getLblNumber(), gbcLblNumber);
        GridBagConstraints gbcNumberField = new GridBagConstraints();
        gbcNumberField.insets = new Insets(0, 0, 5, 0);
        gbcNumberField.fill = 2;
        gbcNumberField.gridx = 1;
        gbcNumberField.gridy = 4;
        this.add((Component)this.getNumberField(), gbcNumberField);
        GridBagConstraints gbcLblDateVal = new GridBagConstraints();
        gbcLblDateVal.anchor = 17;
        gbcLblDateVal.insets = new Insets(0, 0, 5, 5);
        gbcLblDateVal.gridx = 0;
        gbcLblDateVal.gridy = 5;
        this.add((Component)this.getLblDateVal(), gbcLblDateVal);
        GridBagConstraints gbcValueDateField = new GridBagConstraints();
        gbcValueDateField.insets = new Insets(0, 0, 5, 0);
        gbcValueDateField.anchor = 17;
        gbcValueDateField.gridx = 1;
        gbcValueDateField.gridy = 5;
        this.add((Component)this.getValueDateField(), gbcValueDateField);
        GridBagConstraints gbcLblStatement = new GridBagConstraints();
        gbcLblStatement.anchor = 17;
        gbcLblStatement.insets = new Insets(0, 0, 0, 5);
        gbcLblStatement.gridx = 0;
        gbcLblStatement.gridy = 6;
        this.add((Component)this.getLblStatement(), gbcLblStatement);
        GridBagConstraints gbcStatementField = new GridBagConstraints();
        gbcStatementField.anchor = 17;
        gbcStatementField.gridx = 1;
        gbcStatementField.gridy = 6;
        this.add((Component)this.getStatementField(), gbcStatementField);
    }

    private JLabel getLblAccount() {
        if (this.lblAccount == null) {
            this.lblAccount = new JLabel(LocalizationData.get("AccountDialog.account"));
        }
        return this.lblAccount;
    }

    public AccountWidget getAccountWidget() {
        if (this.accountWidget == null) {
            this.accountWidget = new AccountWidget(this.data);
            this.accountWidget.getJLabel().setVisible(false);
            this.accountWidget.addPropertyChangeListener(ACCOUNT_PROPERTY, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    FromOrToPane.this.firePropertyChange(FromOrToPane.ACCOUNT_PROPERTY, evt.getOldValue(), evt.getNewValue());
                    ((ModeWidgetParams)FromOrToPane.this.getModeWidget().getParameters()).setAccount((Account)FromOrToPane.this.accountWidget.get());
                    FromOrToPane.this.getModeWidget().refresh();
                    FromOrToPane.this.doModeChanges();
                }
            });
        }
        return this.accountWidget;
    }

    private JLabel getLblMode() {
        if (this.lblMode == null) {
            this.lblMode = new JLabel(LocalizationData.get("TransactionDialog.mode"));
        }
        return this.lblMode;
    }

    public ModeWidget getModeWidget() {
        if (this.modeWidget == null) {
            this.modeWidget = new ModeWidget(new ModeWidgetParams(this.data, (Account)this.getAccountWidget().get(), this.from));
            this.modeWidget.getJLabel().setVisible(false);
            this.modeWidget.addPropertyChangeListener("mode", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    FromOrToPane.this.doModeChanges();
                }
            });
        }
        return this.modeWidget;
    }

    private JLabel getLblNumber() {
        if (this.lblNumber == null) {
            this.lblNumber = new JLabel(LocalizationData.get("TransactionDialog.number"));
        }
        return this.lblNumber;
    }

    public TransactionNumberWidget getNumberField() {
        if (this.numberField == null) {
            this.numberField = new TransactionNumberWidget();
        }
        return this.numberField;
    }

    private JLabel getLblDateVal() {
        if (this.lblDateVal == null) {
            this.lblDateVal = new JLabel(LocalizationData.get("TransactionDialog.valueDate"));
        }
        return this.lblDateVal;
    }

    public DateWidget getValueDateField() {
        if (this.valueDateField == null) {
            this.valueDateField = new DateWidget();
            this.valueDateField.getDateField().addFocusListener(AutoSelectFocusListener.INSTANCE);
            this.valueDateField.addPropertyChangeListener("date", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    FromOrToPane.this.firePropertyChange(FromOrToPane.VALUE_DATE_PROPERTY, evt.getOldValue(), evt.getNewValue());
                }
            });
        }
        return this.valueDateField;
    }

    private JLabel getLblStatement() {
        if (this.lblStatement == null) {
            this.lblStatement = new JLabel(LocalizationData.get("TransactionDialog.statement"));
        }
        return this.lblStatement;
    }

    public TextWidget getStatementField() {
        if (this.statementField == null) {
            this.statementField = new TextWidget();
            this.statementField.setColumns(10);
            this.statementField.setToolTipText(LocalizationData.get("TransactionDialog.statement.tooltip"));
            this.statementField.addFocusListener(AutoSelectFocusListener.INSTANCE);
        }
        return this.statementField;
    }

    private void doModeChanges() {
        this.getNumberField().set(this.data, (Account)this.getAccountWidget().get(), (Mode)this.getModeWidget().get(), this.from);
        this.setValueDate();
    }

    public void setDate(Date date) {
        this.date = date;
        this.setValueDate();
    }

    private void setValueDate() {
        DateStepper vdc;
        Mode mode = (Mode)this.getModeWidget().get();
        DateStepper dateStepper = vdc = this.from ? mode.getExpenseVdc() : mode.getReceiptVdc();
        if (vdc != null && this.date != null) {
            this.getValueDateField().setDate(vdc.getNextStep(this.date));
        }
    }

    public void setAccount(Account account) {
        this.getAccountWidget().set(account);
    }

    private JLabel getLblDescription() {
        if (this.lblDescription == null) {
            this.lblDescription = new JLabel(LocalizationData.get("TransactionDialog.description"));
        }
        return this.lblDescription;
    }

    private JLabel getLblComment() {
        if (this.lblComment == null) {
            this.lblComment = new JLabel(LocalizationData.get("TransactionDialog.comment"));
        }
        return this.lblComment;
    }

    public TextWidget getDescriptionField() {
        if (this.descriptionField == null) {
            this.descriptionField = new TextWidget();
            this.descriptionField.setColumns(10);
        }
        return this.descriptionField;
    }

    public JTextField getCommentField() {
        if (this.commentField == null) {
            this.commentField = new JTextField();
            this.commentField.setColumns(10);
        }
        return this.commentField;
    }
}

