/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.remote;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Observable;
import java.util.TimeZone;
import net.yapbam.remote.Cache;
import net.yapbam.remote.MemoryCache;
import net.yapbam.remote.RemoteData;
import net.yapbam.util.CoolHttpConnection;
import net.yapbam.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteResource<T extends RemoteData>
extends Observable {
    private Logger logger;
    private Proxy proxy;
    private Cache cache;
    private T data;
    private long lastTryCacheRefresh;
    private boolean isSynchronized;

    protected AbstractRemoteResource(Proxy proxy, Cache cache) {
        this.proxy = proxy;
        this.data = null;
        this.cache = cache == null ? new MemoryCache() : cache;
        try {
            this.data = this.parse(this.cache, false);
            this.isSynchronized = !this.isDataExpired();
        }
        catch (Exception e) {
            this.getLogger().warn("Parse failed", e);
        }
        this.lastTryCacheRefresh = this.cache.getTimeStamp();
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
        return this.logger;
    }

    public long getTimeStamp() {
        return this.data == null ? -1L : this.data.getTimeStamp();
    }

    public long getRefreshTimeStamp() {
        return this.cache.getTimeStamp();
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public boolean update() throws IOException, ParseException {
        boolean connect = this.isDataExpired();
        if (connect) {
            this.forcedUpdate();
        }
        this.isSynchronized = true;
        return connect;
    }

    public void forcedUpdate() throws IOException, ParseException {
        long start = System.currentTimeMillis();
        this.refreshCacheFile();
        this.getLogger().debug("refresh cache: {}ms", (Object)Long.toString(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        T parsedData = this.parse(this.cache, true);
        this.getLogger().debug("parse: {}ms", (Object)Long.toString(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.cache.commit();
        this.getLogger().debug("commit: {}ms", (Object)Long.toString(System.currentTimeMillis() - start));
        this.data = parsedData;
        this.setChanged();
        this.notifyObservers();
    }

    protected boolean isDataExpired() {
        if (this.getTimeStamp() < 0L) {
            return true;
        }
        if (System.currentTimeMillis() - this.lastTryCacheRefresh < 60000L) {
            return false;
        }
        int tolerance = 12;
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        long hoursOld = (cal.getTimeInMillis() - this.getTimeStamp()) / 3600000L;
        cal.setTimeInMillis(this.getTimeStamp());
        int hoursValid = 36;
        if (cal.get(7) == 6) {
            hoursValid = 72;
        } else if (cal.get(7) == 7) {
            hoursValid = 48;
        }
        return hoursOld > (long)hoursValid;
    }

    protected final long getLastRefreshTimeStamp() {
        return this.lastTryCacheRefresh;
    }

    protected abstract URL getSourceURL();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCacheFile() throws IOException {
        this.lastTryCacheRefresh = System.currentTimeMillis();
        this.getLogger().trace("Connecting to {}", (Object)this.getSourceURL());
        InputStream in = this.getSourceStream();
        try {
            Cache cache = this.cache;
            synchronized (cache) {
                OutputStream out = this.cache.getOutputStream();
                try {
                    StreamUtils.copy(in, out, new byte[10240]);
                }
                finally {
                    out.flush();
                    out.close();
                }
            }
        }
        finally {
            in.close();
        }
    }

    private InputStream getSourceStream() throws IOException {
        URL url = this.getSourceURL();
        if (url == null) {
            throw new FileNotFoundException();
        }
        if (url.getProtocol().equalsIgnoreCase("https") || url.getProtocol().equalsIgnoreCase("http")) {
            CoolHttpConnection connection = new CoolHttpConnection(url, this.proxy, new URL[0]);
            int errorCode = connection.getResponseCode();
            if (errorCode != 200) {
                throw new IOException(MessageFormat.format("Http Error {1} when opening {0}", url, errorCode));
            }
            return connection.getInputStream();
        }
        return url.openStream();
    }

    protected abstract T parse(Cache var1, boolean var2) throws ParseException, IOException;

    protected T getData() {
        return this.data;
    }
}

