/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.server.exchange;

import java.io.IOException;
import java.io.Serializable;
import java.net.Proxy;
import net.yapbam.server.exchange.AbstractServerView;
import net.yapbam.server.exchange.ExpiredAccountException;
import net.yapbam.server.exchange.InvalidPasswordException;
import net.yapbam.server.exchange.UnknownAccountException;
import net.yapbam.server.exchange.UnknownUserException;

public class UserServerView
extends AbstractServerView {
    private static final String POST_DATA_COMMAND = "POST_DATA";
    private static final String GET_DATA_COMMAND = "GET_DATA";
    private static final int UNEXPEXTED_ERROR = -1;
    private static final int UNKNOWN_COMMAND = 1;
    private static final int UNKNOWN_USER = 3;
    private static final int INVALID_PASSWORD = 4;
    private static final int UNKNOWN_ACCOUNT = 6;
    private static final int ACCOUNT_EXPIRED = 7;

    public UserServerView(Proxy proxy, String eMail, String password) {
        super(proxy, eMail, password);
    }

    @Override
    protected void codeToException(int errCode) {
        if (errCode == -1 || errCode == 1) {
            throw new RuntimeException("server error " + errCode);
        }
        if (errCode == 3) {
            throw new UnknownUserException();
        }
        if (errCode == 4) {
            throw new InvalidPasswordException();
        }
        if (errCode == 6) {
            throw new UnknownAccountException();
        }
        if (errCode == 7) {
            throw new ExpiredAccountException();
        }
    }

    public void postData(String account, String data) throws IOException, UnknownUserException, InvalidPasswordException, UnknownAccountException, ExpiredAccountException {
        this.toServer(POST_DATA_COMMAND, new Serializable[]{account, data});
    }

    public String getData(String account) throws IOException, UnknownUserException, InvalidPasswordException, UnknownAccountException, ExpiredAccountException {
        return (String)((Object)this.toServer(GET_DATA_COMMAND, new Serializable[]{account}));
    }
}

