/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.yapbam.util.Base64Encoder;
import net.yapbam.util.BinaryPBEKey;
import net.yapbam.util.CheckSum;
import net.yapbam.util.CipherOutputStream;

public final class Crypto {
    public static final String UTF8 = "UTF-8";
    static final String ALGORITHM = "PBEWITHMD5ANDDES";
    private static final byte[] SALT = new byte[]{-57, 35, -91, -4, 126, 56, -18, 9};
    private static final PBEParameterSpec PBE_PARAM_SPEC = new PBEParameterSpec(SALT, 16);

    private Crypto() {
    }

    public static String decrypt(String key, String message) {
        SecretKeySpec skeySpec = new SecretKeySpec(CheckSum.toBytes(key), "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, skeySpec);
            return new String(cipher.doFinal(CheckSum.toBytes(message)));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encrypt(String key, String message) {
        SecretKeySpec skeySpec = new SecretKeySpec(CheckSum.toBytes(key), "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, skeySpec);
            return CheckSum.toString(cipher.doFinal(message.getBytes()));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static OutputStream getPasswordProtectedOutputStream(String password, OutputStream stream) throws IOException {
        stream.write(Crypto.getDigest(password));
        try {
            SecretKey pbeKey = Crypto.getSecretKey(password);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, (Key)pbeKey, PBE_PARAM_SPEC);
            CipherOutputStream cstream = new CipherOutputStream(stream, cipher);
            stream = new DeflaterOutputStream(cstream){

                @Override
                public void finish() throws IOException {
                    super.finish();
                    ((CipherOutputStream)this.out).finish();
                }
            };
            return stream;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static InputStream getOldPasswordProtectedInputStream(String password, InputStream stream) throws IOException, AccessControlException, GeneralSecurityException {
        BinaryPBEKey pbeKey = new BinaryPBEKey(password.getBytes(UTF8));
        return Crypto.getPasswordProtectedInputStream(password, stream, pbeKey);
    }

    public static InputStream getPasswordProtectedInputStream(String password, InputStream stream) throws IOException, AccessControlException, GeneralSecurityException {
        return Crypto.getPasswordProtectedInputStream(password, stream, Crypto.getSecretKey(password));
    }

    private static SecretKey getSecretKey(String password) throws InvalidKeySpecException, NoSuchAlgorithmException {
        try {
            password = Base64Encoder.encode(password.getBytes(UTF8));
            return SecretKeyFactory.getInstance(ALGORITHM).generateSecret(new PBEKeySpec(password.toCharArray()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static InputStream getPasswordProtectedInputStream(String password, InputStream stream, SecretKey key) throws IOException, AccessControlException, GeneralSecurityException {
        Crypto.verifyPassword(stream, password);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, (Key)key, PBE_PARAM_SPEC);
        stream = new CipherInputStream(stream, cipher);
        stream = new InflaterInputStream(stream);
        return stream;
    }

    public static void verifyPassword(InputStream stream, String password) throws IOException, AccessControlException {
        byte[] digest = Crypto.getDigest(password);
        byte[] fileDigest = new byte[digest.length];
        for (int missing = fileDigest.length; missing > 0; missing -= stream.read(fileDigest, fileDigest.length - missing, missing)) {
        }
        if (!MessageDigest.isEqual(digest, fileDigest)) {
            throw new AccessControlException("invalid password");
        }
    }

    public static byte[] getDigest(String password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA");
            digest.update(SALT);
            return digest.digest(password.getBytes(UTF8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

