/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.util;

public class Mangler {
    private char[] escapeChars;
    private static final int BASE_CODE = 48;

    public Mangler(String reservedChars, char mangleChar) {
        int i;
        if (reservedChars.indexOf(mangleChar) >= 0) {
            throw new IllegalArgumentException();
        }
        int nb = reservedChars.length();
        int code = 48;
        for (i = 0; i <= nb; ++i) {
            if (reservedChars.indexOf(code) >= 0) {
                throw new IllegalArgumentException();
            }
            code = (char)(code + 1);
        }
        this.escapeChars = new char[nb + 1];
        this.escapeChars[0] = mangleChar;
        for (i = 0; i < nb; ++i) {
            this.escapeChars[i + 1] = reservedChars.charAt(i);
        }
    }

    public String mangle(String s) {
        StringBuilder buf = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int found = -1;
            char car = s.charAt(i);
            for (int j = 0; j < this.escapeChars.length; ++j) {
                if (this.escapeChars[j] != car) continue;
                found = j;
            }
            if (found < 0) {
                if (buf == null) continue;
                buf.append(car);
                continue;
            }
            if (buf == null) {
                buf = new StringBuilder(s.substring(0, i));
            }
            buf.append(this.escapeChars[0]);
            buf.append((char)(48 + found));
        }
        if (buf != null) {
            buf.append(this.escapeChars[0]);
            return buf.toString();
        }
        return s;
    }

    public String unmangle(String s) {
        int len = s.length();
        if (len == 0 || s.charAt(len - 1) != this.escapeChars[0]) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        boolean mangleMode = false;
        for (int i = 0; i < len; ++i) {
            char car = s.charAt(i);
            if (mangleMode) {
                mangleMode = false;
                buf.append(this.escapeChars[car - 48]);
                continue;
            }
            if (car == this.escapeChars[0]) {
                mangleMode = true;
                continue;
            }
            buf.append(car);
        }
        return buf.toString();
    }
}

