/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.CorruptionException;
import com.db4o.foundation.Coercion4;
import com.db4o.internal.Buffer;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteContext;
import com.db4o.reflect.ReflectClass;

public class ShortHandler
extends PrimitiveHandler {
    static final int LENGTH = 2;
    private static final Short i_primitive = new Short(0);
    private short i_compareTo;

    public ShortHandler(InternalObjectContainer internalObjectContainer) {
        super(internalObjectContainer);
    }

    public Object coerce(ReflectClass reflectClass, Object object) {
        return Coercion4.toShort(object);
    }

    public Object defaultValue() {
        return i_primitive;
    }

    public int linkLength() {
        return 2;
    }

    protected Class primitiveJavaClass() {
        return Short.TYPE;
    }

    public Object primitiveNull() {
        return i_primitive;
    }

    public Object read(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer, boolean bl) throws CorruptionException {
        return marshallerFamily._primitive.readShort(statefulBuffer);
    }

    Object read1(Buffer buffer) {
        return this.primitiveMarshaller().readShort(buffer);
    }

    public void write(Object object, Buffer buffer) {
        ShortHandler.writeShort(((Short)object).shortValue(), buffer);
    }

    static final void writeShort(int n, Buffer buffer) {
        for (int i = 0; i < 2; ++i) {
            buffer._buffer[buffer._offset++] = (byte)(n >> (1 - i) * 8);
        }
    }

    private short val(Object object) {
        return (Short)object;
    }

    void prepareComparison1(Object object) {
        this.i_compareTo = this.val(object);
    }

    boolean isEqual1(Object object) {
        return object instanceof Short && this.val(object) == this.i_compareTo;
    }

    boolean isGreater1(Object object) {
        return object instanceof Short && this.val(object) > this.i_compareTo;
    }

    boolean isSmaller1(Object object) {
        return object instanceof Short && this.val(object) < this.i_compareTo;
    }

    public Object read(ReadContext readContext) {
        int n = ((readContext.readByte() & 0xFF) << 8) + (readContext.readByte() & 0xFF);
        return new Short((short)n);
    }

    public void write(WriteContext writeContext, Object object) {
        short s = (Short)object;
        writeContext.writeBytes(new byte[]{(byte)(s >> 8), (byte)s});
    }
}

