/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.budget;

import java.math.BigDecimal;
import java.util.Arrays;
import jgnash.engine.MathConstants;
import jgnash.engine.budget.BudgetPeriod;

public class BudgetGoal
implements Cloneable {
    public static final transient int PERIODS = 366;
    private transient int hash;
    private BigDecimal[] goals;
    private BudgetPeriod budgetPeriod = BudgetPeriod.MONTHLY;

    public BudgetGoal() {
        this.goals = new BigDecimal[366];
        Arrays.fill(this.goals, BigDecimal.ZERO);
    }

    public final BigDecimal[] getGoals() {
        return this.goals;
    }

    public final void setGoals(BigDecimal[] goals) {
        if (goals == null) {
            throw new IllegalArgumentException("goals may not be null");
        }
        if (goals.length != 366) {
            throw new IllegalArgumentException("goals must be 366 in length");
        }
        for (int i = 0; i < goals.length; ++i) {
            if (goals[i] != null) continue;
            throw new IllegalArgumentException("goals [" + i + "] may not be null");
        }
        this.goals = goals;
    }

    public BudgetPeriod getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public void setBudgetPeriod(BudgetPeriod budgetPeriod) {
        if (budgetPeriod == null) {
            throw new IllegalArgumentException("BudgetPeriod may not be null");
        }
        this.budgetPeriod = budgetPeriod;
    }

    public void setGoal(int startPeriod, int endPeriod, BigDecimal amount) {
        BigDecimal divisor = new BigDecimal(endPeriod - startPeriod + 1);
        BigDecimal portion = amount.divide(divisor, MathConstants.mathContext);
        for (int i = startPeriod; i <= endPeriod; ++i) {
            this.goals[i] = portion;
        }
    }

    public BigDecimal getGoal(int startPeriod, int endPeriod) {
        BigDecimal amount = BigDecimal.ZERO;
        for (int i = startPeriod; i <= endPeriod && i <= 365; ++i) {
            amount = amount.add(this.goals[i]);
        }
        return amount;
    }

    public Object clone() throws CloneNotSupportedException {
        BudgetGoal goal = (BudgetGoal)super.clone();
        goal.goals = new BigDecimal[366];
        System.arraycopy(this.goals, 0, goal.goals, 0, this.goals.length);
        return goal;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int prime = 31;
            h = 1;
            h = 31 * h + this.budgetPeriod.hashCode();
            this.hash = h = 31 * h + Arrays.hashCode(this.goals);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BudgetGoal other = (BudgetGoal)obj;
        if (this.budgetPeriod != other.budgetPeriod) {
            return false;
        }
        return Arrays.equals(this.goals, other.goals);
    }
}

