/*
 * Decompiled with CFR 0.152.
 */
package jgnash.imports;

import java.util.List;
import jgnash.engine.Account;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionFactory;
import jgnash.imports.ImportTransaction;
import jgnash.imports.ofx.OfxTransaction;

public class GenericImport {
    public static void importTransactions(List<? extends ImportTransaction> transactions, Account baseAccount) {
        assert (transactions != null && baseAccount != null);
        Engine engine = EngineFactory.getEngine("default");
        for (ImportTransaction importTransaction : transactions) {
            Transaction t;
            assert (importTransaction.account != null);
            if (importTransaction.getState() != ImportTransaction.ImportState.NEW && importTransaction.getState() != ImportTransaction.ImportState.NOTEQUAL || (t = baseAccount.equals(importTransaction.account) ? TransactionFactory.generateSingleEntryTransaction(baseAccount, importTransaction.amount, importTransaction.datePosted, false, importTransaction.memo, importTransaction.payee, importTransaction.checkNumber) : (importTransaction.amount.signum() >= 0 ? TransactionFactory.generateDoubleEntryTransaction(baseAccount, importTransaction.account, importTransaction.amount.abs(), importTransaction.datePosted, importTransaction.memo, importTransaction.payee, importTransaction.checkNumber) : TransactionFactory.generateDoubleEntryTransaction(importTransaction.account, baseAccount, importTransaction.amount.abs(), importTransaction.datePosted, importTransaction.memo, importTransaction.payee, importTransaction.checkNumber))) == null) continue;
            engine.addTransaction(t);
        }
    }

    public static void matchTransactions(List<? extends ImportTransaction> list, Account baseAccount) {
        block0: for (ImportTransaction importTransaction : list) {
            String checkNumber;
            String fitid;
            if (importTransaction instanceof OfxTransaction && (fitid = ((OfxTransaction)importTransaction).transactionID) != null && fitid.length() > 0) {
                for (Transaction tran : baseAccount.getReadonlyTransactionList()) {
                    if (tran.getFitid() == null || !tran.getFitid().equals(fitid)) continue;
                    importTransaction.setState(ImportTransaction.ImportState.EQUAL);
                    break;
                }
            }
            if ((checkNumber = importTransaction.checkNumber) == null || checkNumber.length() <= 0) continue;
            for (Transaction tran : baseAccount.getReadonlyTransactionList()) {
                if (tran.getNumber() == null || !tran.getNumber().equals(checkNumber)) continue;
                importTransaction.setState(ImportTransaction.ImportState.EQUAL);
                continue block0;
            }
        }
    }

    private GenericImport() {
    }
}

