/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.actions;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.ui.StaticUIMethods;
import jgnash.ui.UIApplication;
import jgnash.ui.actions.OpenAction;
import jgnash.ui.components.OpenDatabaseDialog;
import jgnash.ui.util.SimpleSwingWorker;
import jgnash.util.FileUtils;
import jgnash.util.Resource;

public class OpenAction {
    static final String MESSAGE_PLEASE_WAIT = "Message.PleaseWait";

    public static void openAction() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                OpenDatabaseDialog d = new OpenDatabaseDialog(UIApplication.getFrame());
                d.setDatabasePath(EngineFactory.getLastDatabase());
                d.setUserName(EngineFactory.getLastUser());
                d.setPort(EngineFactory.getLastPort());
                d.setHost(EngineFactory.getLastHost());
                d.setPassword(EngineFactory.getLastPassword());
                d.setRemote(EngineFactory.getLastRemote());
                d.setVisible(true);
                boolean result = d.getResult();
                if (result) {
                    final class BootEngine
                    extends SimpleSwingWorker {
                        private OpenDatabaseDialog dialog;

                        protected BootEngine(OpenDatabaseDialog dialog) {
                            this.dialog = dialog;
                        }

                        protected Void doInBackground() throws Exception {
                            Resource rb = Resource.get();
                            UIApplication.getFrame().displayWaitMessage(rb.getString("Message.PleaseWait"));
                            EngineFactory.closeEngine("default");
                            if (this.dialog.isRemote()) {
                                String user = this.dialog.getUserName();
                                String password = new String(this.dialog.getPassword());
                                String host = this.dialog.getHost();
                                int port = this.dialog.getPort();
                                boolean save = this.dialog.savePassword();
                                EngineFactory.bootClientEngine(host, port, user, password, "default", save);
                            } else if (FileUtils.isFileLocked(this.dialog.getDatabasePath())) {
                                StaticUIMethods.displayError(Resource.get().getString("Message.FileIsLocked"));
                            } else {
                                EngineFactory.bootLocalEngine(this.dialog.getDatabasePath(), "default");
                            }
                            Engine e = EngineFactory.getEngine("default");
                            if (e != null) {
                                e.getRootAccount();
                            }
                            return null;
                        }

                        protected void done() {
                            UIApplication.getFrame().stopWaitMessage();
                        }
                    }
                    new BootEngine(d).execute();
                }
            }
        });
    }

    public static void openAction(final File file) {
        final Logger logger = Logger.getLogger(OpenAction.class.getName());
        String database = file.getAbsolutePath();
        if (EngineFactory.doesDatabaseExist(database)) {
            try {
                if (!FileUtils.isFileLocked(database)) {
                    final class BootEngine
                    extends SimpleSwingWorker {
                        BootEngine() {
                        }

                        @Override
                        protected Void doInBackground() throws Exception {
                            Resource rb = Resource.get();
                            UIApplication.getFrame().displayWaitMessage(rb.getString(OpenAction.MESSAGE_PLEASE_WAIT));
                            logger.fine("Booting the engine");
                            Thread.sleep(750L);
                            EngineFactory.bootLocalEngine(file.getAbsolutePath(), "default");
                            EngineFactory.getEngine("default").getRootAccount();
                            logger.fine("Engine boot complete");
                            return null;
                        }

                        @Override
                        protected void done() {
                            UIApplication.getFrame().stopWaitMessage();
                        }
                    }
                    new BootEngine().execute();
                } else {
                    StaticUIMethods.displayError(Resource.get().getString("Message.FileIsLocked"));
                }
            }
            catch (FileNotFoundException e) {
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public static void openLastAction() {
        String database;
        Logger logger = UIApplication.getLogger();
        if (!EngineFactory.getLastRemote() && EngineFactory.doesDatabaseExist(database = EngineFactory.getLastDatabase())) {
            try {
                if (!FileUtils.isFileLocked(database)) {
                    final class BootEngine
                    extends SimpleSwingWorker {
                        final /* synthetic */ Logger val$logger;

                        BootEngine(Logger logger) {
                            this.val$logger = logger;
                        }

                        @Override
                        protected Void doInBackground() throws Exception {
                            Engine engine;
                            Resource rb = Resource.get();
                            UIApplication.getFrame().displayWaitMessage(rb.getString(OpenAction.MESSAGE_PLEASE_WAIT));
                            this.val$logger.fine("Booting the engine");
                            Thread.sleep(750L);
                            if (EngineFactory.getLastRemote() && EngineFactory.getLastPassword().length() > 0) {
                                int port;
                                String user = EngineFactory.getLastUser();
                                String password = EngineFactory.getLastPassword();
                                String host = EngineFactory.getLastHost();
                                engine = EngineFactory.bootClientEngine(host, port = EngineFactory.getLastPort(), user, password, "default", true);
                                if (engine == null) {
                                    this.val$logger.warning(rb.getString("Message.ErrorServerConnection"));
                                }
                            } else {
                                engine = EngineFactory.bootLocalEngine(EngineFactory.getLastDatabase(), "default");
                                if (engine == null) {
                                    this.val$logger.warning(rb.getString("Message.ErrorLoadingFile"));
                                }
                            }
                            if (engine != null) {
                                EngineFactory.getEngine("default").getRootAccount();
                                this.val$logger.fine("Engine boot complete");
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            UIApplication.getFrame().stopWaitMessage();
                        }
                    }
                    new BootEngine(logger).execute();
                } else {
                    StaticUIMethods.displayError(Resource.get().getString("Message.FileIsLocked"));
                }
            }
            catch (FileNotFoundException e) {
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public static void openRemote(final String host, final int port, final String user, final String password) {
        final Logger logger = Logger.getLogger(OpenAction.class.getName());
        final class BootEngine
        extends SimpleSwingWorker {
            BootEngine() {
            }

            @Override
            protected Void doInBackground() throws Exception {
                Resource rb = Resource.get();
                UIApplication.getFrame().displayWaitMessage(rb.getString(OpenAction.MESSAGE_PLEASE_WAIT));
                logger.fine("Booting the engine");
                Thread.sleep(750L);
                EngineFactory.bootClientEngine(host, port, user, password, "default", false);
                EngineFactory.getEngine("default").getRootAccount();
                logger.fine("Engine boot complete");
                return null;
            }

            @Override
            protected void done() {
                UIApplication.getFrame().stopWaitMessage();
            }
        }
        new BootEngine().execute();
    }

    private OpenAction() {
    }
}

