/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.budget.Budget;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.ui.components.SortedComboBoxModel;
import jgnash.util.Resource;

public final class BudgetComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;

    public BudgetComboBox() {
        this.setModel(new BudgetModel());
        this.setRenderer(new Renderer(this.getRenderer()));
        Thread thread = new Thread(){

            @Override
            public void run() {
                Resource rb = Resource.get();
                Budget prototype = new Budget();
                prototype.setName(rb.getString("Word.NewBudget") + " " + 1);
                BudgetComboBox.this.setPrototypeDisplayValue(prototype);
            }
        };
        thread.start();
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public Budget getSelectedBudget() {
        return (Budget)this.getSelectedItem();
    }

    public void setSelectedBudget(Budget budget) {
        super.setSelectedItem(budget);
    }

    private class Renderer
    implements ListCellRenderer {
        private ListCellRenderer delegate;

        public Renderer(ListCellRenderer delegate) {
            this.delegate = delegate;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                BudgetComboBox.this.setToolTipText(((Budget)value).getDescription());
                return this.delegate.getListCellRendererComponent(list, ((Budget)value).getName(), index, isSelected, cellHasFocus);
            }
            return this.delegate.getListCellRendererComponent(list, null, index, isSelected, cellHasFocus);
        }
    }

    protected static final class BudgetModel
    extends SortedComboBoxModel<Budget>
    implements ComboBoxModel,
    MessageListener {
        private static final long serialVersionUID = 1L;

        public BudgetModel() {
            Engine e = EngineFactory.getEngine("default");
            this.addAll(e.getBudgetList());
            MessageBus.getInstance().registerListener(this, MessageChannel.BUDGET, MessageChannel.SYSTEM);
        }

        @Override
        public void messagePosted(final Message event) {
            switch (event.getEvent()) {
                case FILE_CLOSING: {
                    MessageBus.getInstance().unregisterListener(this, MessageChannel.BUDGET, MessageChannel.SYSTEM);
                    break;
                }
                case BUDGET_REMOVE: {
                    if (event.getObject(MessageProperty.BUDGET) == null) break;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Object selected = BudgetModel.this.getSelectedItem();
                            BudgetModel.this.removeElement(event.getObject(MessageProperty.BUDGET));
                            if (selected == event.getObject(MessageProperty.BUDGET) && BudgetModel.this.getSize() > 0) {
                                BudgetModel.this.setSelectedItem(BudgetModel.this.getElementAt(0));
                            }
                        }
                    });
                    break;
                }
                case BUDGET_ADD: {
                    if (event.getObject(MessageProperty.BUDGET) == null) break;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BudgetModel.this.addElement(event.getObject(MessageProperty.BUDGET));
                            if (BudgetModel.this.getSize() == 1) {
                                BudgetModel.this.setSelectedItem(event.getObject(MessageProperty.BUDGET));
                            }
                        }
                    });
                    break;
                }
                case BUDGET_UPDATE: {
                    final Object selected = this.getSelectedItem();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BudgetModel.this.fireContentsChanged(this, 0, BudgetModel.this.getSize());
                            if (selected != null) {
                                BudgetModel.this.setSelectedItem(selected);
                            }
                        }
                    });
                    break;
                }
            }
        }
    }
}

