/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import jgnash.engine.Account;
import jgnash.engine.MathConstants;
import jgnash.engine.budget.BudgetGoal;
import jgnash.engine.budget.BudgetPeriod;
import jgnash.engine.budget.BudgetPeriodDescriptor;
import jgnash.engine.budget.BudgetPeriodDescriptorFactory;
import jgnash.text.CommodityFormat;
import jgnash.ui.UIApplication;
import jgnash.ui.components.FormattedJTable;
import jgnash.ui.util.DialogUtils;
import jgnash.ui.util.JTableUtils;
import jgnash.util.Resource;
import org.jdesktop.swingx.combobox.EnumComboBoxModel;

public final class BudgetGoalDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BudgetGoalDialog.class.getName());
    private static final int SCROLLPANE_WIDTH = 120;
    private static final int SCROLLPANE_HEIGHT = 200;
    private final Resource rb = Resource.get();
    private JComboBox budgetPeriodCombo;
    private BudgetGoal budgetGoal;
    private JButton cancelButton;
    private JButton okButton;
    private boolean result = false;
    private PeriodTableModel model;
    private Account account;
    private int workingYear;

    public BudgetGoalDialog(Account account, BudgetGoal budgetGoal, int workingYear) {
        super((Frame)UIApplication.getFrame(), true);
        this.setTitle(this.rb.getString("Title.BudgetGoal") + " - " + account.getName());
        this.setIconImage(Resource.getImage("/jgnash/resource/gnome-money.png"));
        this.setDefaultCloseOperation(2);
        this.workingYear = workingYear;
        this.account = account;
        if (budgetGoal == null) {
            throw new IllegalArgumentException("BudgetGoal may not be null");
        }
        try {
            this.budgetGoal = (BudgetGoal)budgetGoal.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
        this.model = new PeriodTableModel(BudgetPeriodDescriptorFactory.getDescriptors(workingYear, budgetGoal.getBudgetPeriod()));
        this.layoutMainPanel();
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("right:d, $lcgap, fill:p:g", "f:p, $rgap, d, $ugap, f:p:g, $ugap, f:p");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.budgetPeriodCombo = new JComboBox();
        this.budgetPeriodCombo.setModel(new EnumComboBoxModel(BudgetPeriod.class));
        this.budgetPeriodCombo.setSelectedItem((Object)this.getBudgetGoal().getBudgetPeriod());
        builder.append((Component)new JLabel(this.rb.getString("Label.Period")), (Component)this.budgetPeriodCombo);
        builder.nextLine();
        builder.nextLine();
        builder.append((Component)new JLabel(this.rb.getString("Label.Currency")), (Component)new JLabel(this.account.getCurrencyNode().getSymbol()));
        builder.nextLine();
        builder.nextLine();
        GoalTable table = new GoalTable(this.model);
        table.getSelectionModel().setSelectionMode(0);
        table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ToolTipManager.sharedInstance().unregisterComponent(table);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setPreferredSize(new Dimension(120, 200));
        builder.append((Component)scrollPane, 3);
        builder.nextLine();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton), 3);
        this.budgetPeriodCombo.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.getContentPane().add(builder.getPanel());
        this.pack();
        this.setMinimumSize(this.getSize());
        DialogUtils.addBoundsListener(this);
        JTableUtils.packGenericTable(table);
    }

    public BudgetGoal getBudgetGoal() {
        return this.budgetGoal;
    }

    public boolean getResult() {
        return this.result;
    }

    private void updatePeriod() {
        BudgetPeriod period = (BudgetPeriod)((Object)this.budgetPeriodCombo.getSelectedItem());
        this.getBudgetGoal().setBudgetPeriod(period);
        this.model.updateDescriptors(BudgetPeriodDescriptorFactory.getDescriptors(this.workingYear, this.budgetGoal.getBudgetPeriod()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.result = false;
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (e.getSource() == this.okButton) {
            this.result = true;
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (e.getSource() == this.budgetPeriodCombo) {
            this.updatePeriod();
        }
    }

    private class GoalTable
    extends FormattedJTable {
        private NumberFormat commodityFormatter;

        public GoalTable(TableModel model) {
            super(model);
            this.commodityFormatter = CommodityFormat.getShortNumberFormat(BudgetGoalDialog.this.account.getCurrencyNode());
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            if (column == 1) {
                ((JLabel)c).setText(this.commodityFormatter.format(this.getModel().getValueAt(row, column)));
            }
            ((JLabel)c).setText(this.getModel().getValueAt(row, column).toString());
            return c;
        }
    }

    class PeriodTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private List<BudgetPeriodDescriptor> periodDescriptors;
        private String[] columnNames;

        public PeriodTableModel(List<BudgetPeriodDescriptor> descriptors) {
            this.columnNames = new String[]{BudgetGoalDialog.this.rb.getString("Column.Period"), BudgetGoalDialog.this.rb.getString("Column.Amount")};
            this.periodDescriptors = descriptors;
        }

        void updateDescriptors(List<BudgetPeriodDescriptor> descriptors) {
            this.periodDescriptors = descriptors;
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.periodDescriptors.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            BudgetPeriodDescriptor descriptor = this.periodDescriptors.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return descriptor.getPeriodDescription();
                }
                case 1: {
                    BigDecimal goal = BudgetGoalDialog.this.budgetGoal.getGoal(descriptor.getStartPeriod(), descriptor.getEndPeriod());
                    return goal.setScale((int)BudgetGoalDialog.this.account.getCurrencyNode().getScale(), MathConstants.roundingMode);
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return BigDecimal.class;
                }
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            try {
                BigDecimal amount = new BigDecimal(value.toString());
                BudgetPeriodDescriptor descriptor = this.periodDescriptors.get(rowIndex);
                BudgetGoalDialog.this.budgetGoal.setGoal(descriptor.getStartPeriod(), descriptor.getEndPeriod(), amount);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }
}

