/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import java.awt.EventQueue;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Transaction;
import jgnash.engine.budget.Budget;
import jgnash.engine.budget.BudgetPeriodDescriptor;
import jgnash.engine.budget.BudgetPeriodResults;
import jgnash.engine.budget.BudgetResultsModel;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.message.MessageProxy;
import jgnash.ui.budget.ExpandingBudgetTableModel;
import jgnash.util.Resource;

public final class BudgetPeriodModel
implements TableModel,
MessageListener {
    private final transient Budget budget;
    private final transient BudgetPeriodDescriptor descriptor;
    private transient ExpandingBudgetTableModel expandingBudgetTableModel;
    private transient BudgetResultsModel resultsModel;
    private transient TableModelListener expandingBudgetTableModelListener;
    private MessageProxy proxy = new MessageProxy();
    protected EventListenerList listenerList = new EventListenerList();
    private static final Logger logger = Logger.getLogger(BudgetPeriodModel.class.getName());
    private final String[] columnNames = new String[]{Resource.get().getString("Column.Budgeted"), Resource.get().getString("Column.Change"), Resource.get().getString("Column.Remaining")};

    public BudgetPeriodModel(BudgetPeriodDescriptor descriptor, ExpandingBudgetTableModel budgetTableModel) {
        if (descriptor == null || budgetTableModel == null) {
            throw new IllegalArgumentException();
        }
        this.expandingBudgetTableModel = budgetTableModel;
        this.budget = this.expandingBudgetTableModel.getBudget();
        this.descriptor = descriptor;
        this.resultsModel = this.expandingBudgetTableModel.getResultsModel();
        this.registerListeners();
    }

    private void registerListeners() {
        this.expandingBudgetTableModel.addMessageListener(this);
        this.expandingBudgetTableModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                BudgetPeriodModel.this.fireTableChanged(e);
            }
        };
        this.expandingBudgetTableModel.addTableModelListener(this.expandingBudgetTableModelListener);
    }

    private void unregisterListeners() {
        this.expandingBudgetTableModel.removeMessageListener(this);
        this.expandingBudgetTableModel.removeTableModelListener(this.expandingBudgetTableModelListener);
    }

    @Override
    public int getRowCount() {
        return this.expandingBudgetTableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return BigDecimal.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        BudgetPeriodResults results = this.getResults((Account)this.expandingBudgetTableModel.get(rowIndex));
        switch (columnIndex) {
            case 0: {
                return results.getBudgeted();
            }
            case 1: {
                return results.getChange();
            }
            case 2: {
                return results.getRemaining();
            }
        }
        return BigDecimal.ZERO;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        this.listenerList.add(TableModelListener.class, listener);
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this.listenerList.remove(TableModelListener.class, listener);
    }

    public synchronized void addMessageListener(MessageListener messageListener) {
        this.proxy.addMessageListener(messageListener);
    }

    public synchronized void removeMessageListener(MessageListener messageListener) {
        this.proxy.removeMessageListener(messageListener);
        this.unregisterListeners();
    }

    public ExpandingBudgetTableModel getExpandingBudgetTableModel() {
        return this.expandingBudgetTableModel;
    }

    public BudgetPeriodResults getResults(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account may not be null");
        }
        return this.resultsModel.getResults(this.descriptor, account);
    }

    public CurrencyNode getCurrency() {
        return this.resultsModel.getBaseCurrency();
    }

    private void fireUpdate(Collection<Account> accounts) {
        for (Account account : accounts) {
            int index = this.expandingBudgetTableModel.indexOf(account);
            if (index < 0) continue;
            this.fireTableRowsUpdated(index, index);
        }
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    private void processTransactionEvent(Message message) {
        Transaction transaction = (Transaction)message.getObject(MessageProperty.TRANSACTION);
        if (this.isBetween(transaction.getDate())) {
            HashSet<Account> accounts = new HashSet<Account>();
            for (Account account : transaction.getAccounts()) {
                accounts.addAll(account.getAncestors());
            }
            this.fireUpdate(accounts);
        }
    }

    private void updateBudget(Message message) {
        Budget updatedBudget = (Budget)message.getObject(MessageProperty.BUDGET);
        if (updatedBudget.equals(this.budget)) {
            this.fireUpdate(this.getExpandingBudgetTableModel().getObjects());
        }
    }

    private void updateBudgetPeriod(Message message) {
        Budget updatedBudget = (Budget)message.getObject(MessageProperty.BUDGET);
        if (updatedBudget.equals(this.budget)) {
            Account account = (Account)message.getObject(MessageProperty.ACCOUNT);
            this.fireUpdate(account.getAncestors());
        }
    }

    public BigDecimal getRemainingTotal(AccountGroup group) {
        return this.resultsModel.getResults(this.descriptor, group).getRemaining();
    }

    public BigDecimal getChangeTotal(AccountGroup group) {
        return this.resultsModel.getResults(this.descriptor, group).getChange();
    }

    public BigDecimal getBudgetedTotal(AccountGroup group) {
        return this.resultsModel.getResults(this.descriptor, group).getBudgeted();
    }

    public String getPeriodDescription() {
        return this.descriptor.getPeriodDescription();
    }

    public boolean isBetween(Date date) {
        return this.descriptor.isBetween(date);
    }

    @Override
    public void messagePosted(final Message message) {
        if (message.getEvent() == ChannelEvent.FILE_CLOSING) {
            this.unregisterListeners();
            this.proxy.forwardMessage(message);
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (message.getEvent()) {
                    case ACCOUNT_ADD: 
                    case ACCOUNT_REMOVE: 
                    case ACCOUNT_MODIFY: {
                        BudgetPeriodModel.this.fireUpdate(BudgetPeriodModel.this.expandingBudgetTableModel.getObjects());
                        break;
                    }
                    case BUDGET_UPDATE: {
                        BudgetPeriodModel.this.updateBudget(message);
                        break;
                    }
                    case BUDGET_GOAL_UPDATE: {
                        BudgetPeriodModel.this.updateBudgetPeriod(message);
                        break;
                    }
                    case BUDGET_REMOVE: {
                        if (!message.getObject(MessageProperty.BUDGET).equals(BudgetPeriodModel.this.budget)) break;
                        BudgetPeriodModel.this.unregisterListeners();
                        break;
                    }
                    case TRANSACTION_ADD: 
                    case TRANSACTION_REMOVE: {
                        BudgetPeriodModel.this.processTransactionEvent(message);
                        break;
                    }
                }
                BudgetPeriodModel.this.proxy.forwardMessage(message);
            }
        });
    }

    static {
        logger.setLevel(Level.ALL);
    }
}

