/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.util.DefaultUnitConverter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.StyledEditorKit;
import jgnash.engine.EngineFactory;
import jgnash.engine.budget.Budget;
import jgnash.engine.budget.BudgetFactory;
import jgnash.engine.budget.BudgetPeriod;
import jgnash.ui.UIApplication;
import jgnash.ui.util.DialogUtils;
import jgnash.ui.util.TextResource;
import jgnash.ui.util.ValidationFactory;
import jgnash.util.Resource;
import org.jdesktop.swingx.combobox.EnumComboBoxModel;

final class BudgetWizardDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final int DLU_X = 150;
    private static final int DLU_Y = 60;
    private final Resource rb = Resource.get();
    private JButton okButton;
    private JButton cancelButton;
    private JTextField budgetNameField;
    private JComboBox budgetPeriodCombo;
    private JEditorPane helpPane;
    private JCheckBox roundButton;

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BudgetWizardDialog d = new BudgetWizardDialog();
                DialogUtils.addBoundsListener(d);
                d.setLocationRelativeTo(UIApplication.getFrame());
                d.setVisible(true);
            }
        });
    }

    private BudgetWizardDialog() {
        super((Frame)UIApplication.getFrame(), true);
        this.setTitle(this.rb.getString("Title.NewBudget"));
        this.setDefaultCloseOperation(2);
        this.layoutMainPanel();
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p, $lcgap, f:p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendRow(RowSpec.decode((String)"f:p:g"));
        builder.append((Component)this.helpPane, 3);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)new JLabel(this.rb.getString("Label.Name")), (Component)ValidationFactory.wrap(this.budgetNameField));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append(this.rb.getString("Label.Period"), (Component)this.budgetPeriodCombo);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)this.roundButton, 3);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton), 3);
        this.getContentPane().add(builder.getPanel());
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    private void initComponents() {
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.budgetPeriodCombo = new JComboBox();
        this.budgetPeriodCombo.setModel(new EnumComboBoxModel(BudgetPeriod.class));
        this.budgetPeriodCombo.setSelectedItem((Object)BudgetPeriod.MONTHLY);
        this.budgetNameField = new JTextField();
        DefaultUnitConverter unitConverter = DefaultUnitConverter.getInstance();
        this.helpPane = new JEditorPane();
        this.helpPane.setEditable(false);
        this.helpPane.setEditorKit(new StyledEditorKit());
        this.helpPane.setBackground(this.getBackground());
        this.helpPane.setText(TextResource.getString("NewBudgetOne.txt"));
        this.helpPane.setPreferredSize(new Dimension(unitConverter.dialogUnitXAsPixel(150, (Component)this.helpPane), unitConverter.dialogUnitYAsPixel(60, (Component)this.helpPane)));
        this.roundButton = new JCheckBox(this.rb.getString("Button.RoundToWhole"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (e.getSource() == this.okButton) {
            if (this.budgetNameField.getText().length() > 0) {
                BudgetPeriod period = (BudgetPeriod)((Object)this.budgetPeriodCombo.getSelectedItem());
                Budget budget = BudgetFactory.buildBuildBudget(period, this.budgetNameField.getText(), this.roundButton.isSelected());
                EngineFactory.getEngine("default").addBudget(budget);
                this.dispatchEvent(new WindowEvent(this, 201));
            } else {
                ValidationFactory.showValidationError(this.rb.getString("Message.Error.Empty"), this.budgetNameField);
            }
        }
    }
}

