/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.UIManager;
import jgnash.util.Resource;

public class YesNoDialog
extends JDialog
implements ActionListener {
    private final Resource rb = Resource.get();
    private JButton noButton;
    private JButton yesButton;
    private final JComponent component;
    private boolean result;
    private static final int ERROR_MESSAGE = 0;
    private static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    private static final int QUESTION_MESSAGE = 3;

    public static boolean showYesNoDialog(Frame parent, JComponent component, String title) {
        return YesNoDialog.showYesNoDialog(parent, component, title, 3);
    }

    public static boolean showYesNoDialog(Frame parent, JComponent component, String title, int messageType) {
        YesNoDialog d = new YesNoDialog(parent, component, title, messageType);
        d.setVisible(true);
        return d.result;
    }

    private YesNoDialog(Frame parent, JComponent component, String title, int messageType) {
        super(parent, true);
        this.setTitle(title);
        this.component = component;
        this.layoutMainPanel(messageType);
        this.noButton.addActionListener(this);
        this.yesButton.addActionListener(this);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(parent);
    }

    private void layoutMainPanel(int messageType) {
        FormLayout layout = new FormLayout("p, $lcgap, fill:p:g", "f:p:g, $ugap, f:p");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        this.noButton = new JButton(this.rb.getString("Button.No"));
        this.yesButton = new JButton(this.rb.getString("Button.Yes"));
        builder.append((Component)new JLabel(YesNoDialog.getIconForType(messageType)), (Component)this.component);
        builder.nextLine();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.yesButton, (JButton)this.noButton), 3);
        this.getContentPane().add(builder.getPanel());
        this.pack();
    }

    static Icon getIconForType(int messageType) {
        if (messageType < 0 || messageType > 3) {
            return null;
        }
        switch (messageType) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.noButton) {
            this.result = false;
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (e.getSource() == this.yesButton) {
            this.result = true;
            this.dispatchEvent(new WindowEvent(this, 201));
        }
    }
}

