/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components.autocomplete;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jgnash.ui.components.autocomplete.AutoCompleteModel;

public class DefaultAutoCompleteModel
implements AutoCompleteModel {
    private final List<String> list = new LinkedList<String>();
    private boolean ignoreCase;
    private boolean enabled = true;

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String doLookAhead(String content) {
        if (this.enabled) {
            return this.doLookAhead(content, this.ignoreCase);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doLookAhead(String content, boolean ignoreCase) {
        if (content.length() > 0) {
            List<String> list = this.list;
            synchronized (list) {
                for (String s : this.list) {
                    if (!ignoreCase ? s.equals(content) : s.equalsIgnoreCase(content)) break;
                    if (!DefaultAutoCompleteModel.startsWith(s, content, ignoreCase)) continue;
                    return s;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addString(String content) {
        if (content != null && !content.isEmpty()) {
            List<String> list = this.list;
            synchronized (list) {
                int index = Collections.binarySearch(this.list, content);
                if (index < 0) {
                    this.list.add(-index - 1, content);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        List<String> list = this.list;
        synchronized (list) {
            this.list.clear();
        }
    }

    @Override
    public Object getExtraInfo(String key) {
        return null;
    }

    private static boolean startsWith(String source, String prefix, boolean ignoreCase) {
        return prefix.length() <= source.length() && source.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }
}

