/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components.expandingtable;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import jgnash.ui.components.expandingtable.ExpandingTableNode;

public abstract class AbstractExpandingTableModel<E extends Comparable<? super E>>
extends AbstractTableModel {
    private final Map<E, ExpandingTableNode<E>> objects = new HashMap<E, ExpandingTableNode<E>>();
    private transient List<ExpandingTableNode<E>> visibleObjects = new ArrayList<ExpandingTableNode<E>>();
    private transient Set<E> keys = new HashSet();
    protected ReentrantReadWriteLock rwl = new ReentrantReadWriteLock(false);
    private static final String EXPANSION_STATE = "ExpansionState";
    private Preferences preferences = Preferences.userNodeForPackage(this.getClass());
    private SwingWorker initWorker;

    public AbstractExpandingTableModel() {
        this.initializeModel();
    }

    protected final void initializeModel() {
        this.initWorker = new InitializeModelWorker();
        this.initWorker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<E> getObjects() {
        ReentrantReadWriteLock.ReadLock readLock = this.rwl.readLock();
        readLock.lock();
        try {
            HashSet<E> hashSet = new HashSet<E>(this.keys);
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExpansionState() {
        ReentrantReadWriteLock.ReadLock readLock = this.rwl.readLock();
        readLock.lock();
        try {
            StringBuilder builder = new StringBuilder();
            ArrayList<ExpandingTableNode<E>> values = new ArrayList<ExpandingTableNode<E>>(this.objects.values());
            Collections.sort(values);
            for (ExpandingTableNode<E> node : values) {
                builder.append(node.isExpanded() ? (char)'1' : '0');
            }
            String string = builder.toString();
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreExpansionState(String state) {
        ReentrantReadWriteLock.WriteLock writeLock = this.rwl.writeLock();
        writeLock.lock();
        try {
            if (state != null && state.length() == this.objects.size()) {
                ArrayList<ExpandingTableNode<E>> values = new ArrayList<ExpandingTableNode<E>>(this.objects.values());
                Collections.sort(values);
                for (int i = 0; i < state.length(); ++i) {
                    values.get(i).setExpanded(state.charAt(i) == '1');
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleExpansion(E object) {
        ReentrantReadWriteLock.WriteLock writeLock = this.rwl.writeLock();
        writeLock.lock();
        try {
            if (this.isParent(object)) {
                ExpandingTableNode<E> node;
                node.setExpanded(!(node = this.getNode(object)).isExpanded());
                this.preferences.put(EXPANSION_STATE, this.getExpansionState());
                this.fireNodeChanged();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpandingTableNode<E> getNode(E object) {
        ReentrantReadWriteLock.ReadLock readLock = this.rwl.readLock();
        readLock.lock();
        try {
            ExpandingTableNode<E> expandingTableNode = this.objects.get(object);
            return expandingTableNode;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ReentrantReadWriteLock.WriteLock writeLock = this.rwl.writeLock();
        writeLock.lock();
        try {
            this.visibleObjects.clear();
            this.objects.clear();
            this.keys.clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(E object) {
        ReentrantReadWriteLock.ReadLock readLock = this.rwl.readLock();
        readLock.lock();
        try {
            int index = -1;
            for (ExpandingTableNode<E> n : this.visibleObjects) {
                if (!n.getObject().equals(object)) continue;
                index = this.visibleObjects.indexOf(n);
                break;
            }
            int n = index;
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    public boolean isExpanded(E object) {
        return this.getNode(object).isExpanded();
    }

    @Override
    public int getRowCount() {
        return this.size();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(E object) {
        ReentrantReadWriteLock.WriteLock writeLock = this.rwl.writeLock();
        writeLock.lock();
        try {
            this.objects.put(object, new ExpandingTableNode<E>(object));
            this.keys.add(object);
            this.buildVisibleModel();
            this.fireTableDataChanged();
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void fireTableDataChanged() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractExpandingTableModel.super.fireTableDataChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fireNodeChanged() {
        ReentrantReadWriteLock.WriteLock writeLock = this.rwl.writeLock();
        writeLock.lock();
        try {
            this.buildVisibleModel();
            this.fireTableDataChanged();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(E object) {
        ReentrantReadWriteLock.WriteLock writeLock = this.rwl.writeLock();
        writeLock.lock();
        try {
            ExpandingTableNode<E> node = this.getNode(object);
            if (node != null) {
                this.objects.remove(object);
                this.visibleObjects.remove(node);
                this.keys.remove(object);
                this.fireTableDataChanged();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(int rowIndex) {
        ReentrantReadWriteLock.ReadLock readLock = this.rwl.readLock();
        readLock.lock();
        try {
            E e = this.getExpandingTableNodeAt(rowIndex).getObject();
            return e;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ReentrantReadWriteLock.ReadLock readLock = this.rwl.readLock();
        readLock.lock();
        try {
            int n = this.visibleObjects.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpandingTableNode<E> getExpandingTableNodeAt(int rowIndex) {
        ReentrantReadWriteLock.ReadLock readLock = this.rwl.readLock();
        readLock.lock();
        try {
            if (this.initWorker != null) {
                try {
                    this.initWorker.get();
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(AbstractExpandingTableModel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(AbstractExpandingTableModel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            ExpandingTableNode<E> expandingTableNode = this.visibleObjects.get(rowIndex);
            return expandingTableNode;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadModel() {
        ReentrantReadWriteLock.WriteLock writeLock = this.rwl.writeLock();
        writeLock.lock();
        try {
            this.keys.clear();
            this.objects.clear();
            this.visibleObjects.clear();
            for (Comparable object : this.getModelObjects()) {
                this.objects.put(object, new ExpandingTableNode<Comparable>(object));
                this.keys.add(object);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadVisibleModel(E object, List<ExpandingTableNode<E>> model) {
        ReentrantReadWriteLock.WriteLock writeLock = this.rwl.writeLock();
        writeLock.lock();
        try {
            if (this.isVisible(object)) {
                ExpandingTableNode<E> node = this.getNode(object);
                if (node != null) {
                    model.add(node);
                }
                if (this.isParent(object)) {
                    for (Comparable child : this.getChildren(object)) {
                        this.loadVisibleModel(child, model);
                    }
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void buildVisibleModel(E root) {
        ReentrantReadWriteLock.WriteLock writeLock = this.rwl.writeLock();
        writeLock.lock();
        try {
            ArrayList<ExpandingTableNode<E>> model = new ArrayList<ExpandingTableNode<E>>();
            for (Comparable child : this.getChildren(root)) {
                this.loadVisibleModel(child, model);
            }
            this.visibleObjects = model;
        }
        finally {
            writeLock.unlock();
        }
    }

    protected void buildVisibleModel() {
        this.buildVisibleModel(this.getRootObject());
    }

    public abstract int getVisibleDepth(E var1);

    public abstract boolean isParent(E var1);

    public abstract Collection<E> getChildren(E var1);

    public abstract E getParent(E var1);

    public boolean isVisible(E object) {
        E parent = this.getParent(object);
        if (parent != null && this.getNode(parent) != null) {
            return this.getNode(parent).isExpanded();
        }
        return true;
    }

    protected abstract Collection<E> getModelObjects();

    public abstract String getSearchString(E var1);

    protected abstract E getRootObject();

    private final class InitializeModelWorker
    extends SwingWorker<Void, Void> {
        private InitializeModelWorker() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            AbstractExpandingTableModel.this.loadModel();
            AbstractExpandingTableModel.this.buildVisibleModel();
            AbstractExpandingTableModel.this.restoreExpansionState(AbstractExpandingTableModel.this.preferences.get(AbstractExpandingTableModel.EXPANSION_STATE, null));
            return null;
        }

        @Override
        protected void done() {
            AbstractExpandingTableModel.this.fireNodeChanged();
            AbstractExpandingTableModel.this.initWorker = null;
        }
    }
}

