/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.debug;

import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public final class EDTCheckingRepaintManager
extends RepaintManager {
    @Override
    public synchronized void addInvalidComponent(JComponent c) {
        EDTCheckingRepaintManager.checkThread();
        super.addInvalidComponent(c);
    }

    @Override
    public synchronized void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
        EDTCheckingRepaintManager.checkThread();
        super.addDirtyRegion(c, x, y, w, h);
    }

    private static void checkThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Exception exception = new Exception();
            boolean repaint = false;
            boolean fromSwing = false;
            for (StackTraceElement st : exception.getStackTrace()) {
                if (st.getClassName().startsWith("com.sun.java.help")) {
                    return;
                }
                if (st.getClassName().startsWith("javax.print")) {
                    return;
                }
                if (st.getClassName().contains("HTMLEditorKit")) {
                    return;
                }
                if (st.getClassName().contains("text.html.ImageView")) {
                    return;
                }
                if (st.getClassName().contains("SubstanceListUI")) {
                    return;
                }
                if (repaint && st.getClassName().startsWith("javax.swing.")) {
                    fromSwing = true;
                }
                if (!"repaint".equals(st.getMethodName())) continue;
                repaint = true;
            }
            if (repaint && !fromSwing) {
                return;
            }
            exception.printStackTrace();
        }
    }
}

