/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.recurring;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.recurring.PendingReminder;
import jgnash.engine.recurring.Reminder;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.ui.UIApplication;
import jgnash.ui.components.FormattedJTable;
import jgnash.ui.components.GenericCloseDialog;
import jgnash.ui.components.RollOverButton;
import jgnash.ui.components.YesNoDialog;
import jgnash.ui.recurring.NotificationDialog;
import jgnash.ui.recurring.RecurringEntryDialog;
import jgnash.ui.recurring.RecurringTableModel;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class RecurringPanel
extends JPanel
implements ActionListener,
MessageListener {
    private static final int DEFAULT_SNOOZE = 900000;
    private static final int START_UP_DELAY = 30000;
    private final Resource rb = Resource.get();
    private JButton deleteButton;
    private JButton modifyButton;
    private JButton newButton;
    private JButton remindersButton;
    private JTable reminderTable;
    private Timer timer;
    private static boolean confirmReminderDelete = false;
    private static final String CONFIRMDELETE = "confirmdelete";
    private static final String SNOOZE = "snooze";
    private static volatile boolean showingDialog;

    public RecurringPanel() {
        this.initComponents();
        this.registerListeners();
        SwingWorker<RecurringTableModel, Void> worker = new SwingWorker<RecurringTableModel, Void>(){

            @Override
            public RecurringTableModel doInBackground() {
                return new RecurringTableModel();
            }

            @Override
            public void done() {
                try {
                    RecurringTableModel model = (RecurringTableModel)this.get();
                    RecurringPanel.this.reminderTable.setModel(model);
                    if (!new JLabel().getFont().canDisplay(model.getEnabledSymbol())) {
                        model.setEnabledSymbol('X');
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(RecurringPanel.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        };
        worker.execute();
        this.timer = null;
        this.startTimer();
    }

    private void registerListeners() {
        MessageBus.getInstance().registerListener(this, MessageChannel.SYSTEM);
    }

    public static void showDialog(final Frame parent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Resource rb = Resource.get();
                GenericCloseDialog d = new GenericCloseDialog((Window)parent, new RecurringPanel(), rb.getString("Title.Reminders"));
                d.pack();
                d.setMinimumSize(d.getSize());
                DialogUtils.addBoundsListener(d, "panelbounds");
                d.setModal(false);
                d.setVisible(true);
            }
        });
    }

    private void initComponents() {
        JPanel toolPanel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        this.newButton = new RollOverButton(this.rb.getString("Button.New"), Resource.getIcon("/jgnash/resource/document-new.png"));
        this.modifyButton = new RollOverButton(this.rb.getString("Button.Modify"), Resource.getIcon("/jgnash/resource/document-properties.png"));
        this.deleteButton = new RollOverButton(this.rb.getString("Button.Delete"), Resource.getIcon("/jgnash/resource/edit-delete.png"));
        this.remindersButton = new RollOverButton(this.rb.getString("Button.CheckReminders"), Resource.getIcon("/jgnash/resource/view-refresh.png"));
        this.reminderTable = new FormattedJTable();
        this.reminderTable.setAutoCreateRowSorter(true);
        this.reminderTable.setFillsViewportHeight(true);
        this.reminderTable.setSelectionMode(0);
        this.reminderTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    RecurringPanel.this.deleteReminder();
                }
            }
        });
        this.reminderTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RecurringPanel.this.showModifyDialog();
                }
            }
        });
        this.setLayout(new BorderLayout());
        toolBar.add(this.newButton);
        toolBar.add(this.modifyButton);
        toolBar.add(this.deleteButton);
        toolBar.addSeparator();
        toolBar.add(this.remindersButton);
        toolPanel.add((Component)toolBar, "North");
        toolPanel.add((Component)new JSeparator(), "Center");
        this.add((Component)toolPanel, "North");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setAutoscrolls(true);
        scrollPane.setViewportView(this.reminderTable);
        this.add((Component)scrollPane, "Center");
        this.deleteButton.addActionListener(this);
        this.modifyButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.remindersButton.addActionListener(this);
    }

    public static void setConfirmReminderDeleteEnabled(boolean enabled) {
        confirmReminderDelete = enabled;
        Preferences p = Preferences.userNodeForPackage(RecurringPanel.class);
        p.putBoolean(CONFIRMDELETE, confirmReminderDelete);
    }

    public static boolean isConfirmReminderDeleteEnabled() {
        return confirmReminderDelete;
    }

    private void deleteReminder() {
        int index = this.reminderTable.getSelectedRow();
        if (index != -1) {
            if (RecurringPanel.isConfirmReminderDeleteEnabled() && !this.confirmReminderRemoval()) {
                return;
            }
            EngineFactory.getEngine("default").removeReminder(this.getReminderByRow(index));
        }
    }

    private Reminder getReminderByRow(int row) {
        RecurringTableModel model = (RecurringTableModel)this.reminderTable.getModel();
        int modelRow = this.reminderTable.convertRowIndexToModel(row);
        return model.getReminderAt(modelRow);
    }

    private boolean confirmReminderRemoval() {
        return YesNoDialog.showYesNoDialog(UIApplication.getFrame(), new JLabel(this.rb.getString("Message.ConfirmReminderDelete")), this.rb.getString("Title.Confirm"));
    }

    private static void showNewDialog() {
        Reminder r = RecurringEntryDialog.showDialog();
        if (r != null) {
            EngineFactory.getEngine("default").addReminder(r);
        }
    }

    private void showModifyDialog() {
        int index = this.reminderTable.getSelectedRow();
        if (index != -1) {
            Reminder old = this.getReminderByRow(index);
            try {
                Engine engine;
                Reminder modified = RecurringEntryDialog.showDialog((Reminder)old.clone());
                if (modified != null && (engine = EngineFactory.getEngine("default")).removeReminder(old)) {
                    engine.addReminder(modified);
                }
            }
            catch (CloneNotSupportedException e) {
                Logger.getLogger(RecurringPanel.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.newButton) {
            RecurringPanel.showNewDialog();
        } else if (e.getSource() == this.modifyButton) {
            this.showModifyDialog();
        } else if (e.getSource() == this.deleteButton) {
            this.deleteReminder();
        } else if (e.getSource() == this.timer || e.getSource() == this.remindersButton) {
            this.showRecurringDialog();
        }
    }

    private synchronized void showRecurringDialog() {
        if (showingDialog || EngineFactory.getEngine("default") == null) {
            return;
        }
        SwingWorker<List<PendingReminder>, Void> worker = new SwingWorker<List<PendingReminder>, Void>(){

            @Override
            protected List<PendingReminder> doInBackground() throws Exception {
                return EngineFactory.getEngine("default").getPendingReminders();
            }

            @Override
            protected void done() {
                try {
                    List reminders = (List)this.get();
                    if (!reminders.isEmpty()) {
                        showingDialog = true;
                        Preferences p = Preferences.userNodeForPackage(this.getClass());
                        int snooze = p.getInt(RecurringPanel.SNOOZE, 900000);
                        snooze = NotificationDialog.showDialog(reminders, snooze);
                        p.putInt(RecurringPanel.SNOOZE, snooze);
                        if (RecurringPanel.this.timer != null) {
                            if (snooze != 0) {
                                RecurringPanel.this.timer.setDelay(snooze);
                                RecurringPanel.this.timer.setInitialDelay(snooze);
                                RecurringPanel.this.timer.restart();
                            } else {
                                RecurringPanel.this.timer.stop();
                            }
                        } else {
                            throw new RuntimeException("Lost the timer!");
                        }
                        showingDialog = false;
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(RecurringPanel.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        };
        worker.execute();
    }

    private void startTimer() {
        if (this.timer == null) {
            Preferences p = Preferences.userNodeForPackage(this.getClass());
            int snooze = p.getInt(SNOOZE, 900000);
            this.timer = new Timer(snooze, this);
            this.timer.setInitialDelay(30000);
            this.timer.start();
            Logger.getLogger(RecurringPanel.class.getName()).info("Recurrinng timer started");
        }
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
            Logger.getLogger(RecurringPanel.class.getName()).info("Recurrinng timer stopped");
        }
    }

    @Override
    public void messagePosted(Message event) {
        switch (event.getEvent()) {
            case FILE_CLOSING: 
            case UI_RESTARTING: {
                this.stopTimer();
                MessageBus.getInstance().unregisterListener(this, MessageChannel.SYSTEM);
                break;
            }
        }
    }

    static {
        Preferences p = Preferences.userNodeForPackage(RecurringPanel.class);
        confirmReminderDelete = p.getBoolean(CONFIRMDELETE, true);
        showingDialog = false;
    }
}

