/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import jgnash.engine.Account;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.ReconcileManager;
import jgnash.engine.ReconciledState;
import jgnash.engine.Transaction;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.ui.components.AutoCompleteFactory;
import jgnash.ui.components.AutoCompleteTextField;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.JFloatField;
import jgnash.ui.components.TransactionNumberComboBox;
import jgnash.ui.register.AbstractTransactionPanel;
import jgnash.ui.util.ValidationFactory;

public abstract class AbstractBankTransactionPanel
extends AbstractTransactionPanel
implements ActionListener,
MessageListener {
    final JButton enterButton;
    final JButton cancelButton;
    protected final JCheckBox reconciledButton;
    final JFloatField amountField;
    final DatePanel datePanel;
    final JTextField memoField;
    final JTextField payeeField;
    final TransactionNumberComboBox numberField;
    final Account account;
    Transaction modTrans;
    private boolean autoComplete = true;

    AbstractBankTransactionPanel(Account account) {
        this.account = account;
        this.enterButton = new JButton(this.rb.getString("Button.Enter"));
        this.cancelButton = new JButton(this.rb.getString("Button.Clear"));
        this.amountField = new JFloatField(account.getCurrencyNode());
        this.datePanel = new DatePanel();
        this.memoField = AutoCompleteFactory.getMemoField();
        this.numberField = new TransactionNumberComboBox(account);
        this.payeeField = AutoCompleteFactory.getPayeeField(account);
        this.reconciledButton = new JCheckBox(this.rb.getString("Button.Reconciled"));
        this.reconciledButton.setHorizontalTextPosition(10);
        this.reconciledButton.setMargin(new Insets(0, 0, 0, 0));
        this.registerListeners();
        this.registerMessageBusListeners();
        this.amountField.addKeyListener(this.keyListener);
        this.datePanel.getDateField().addKeyListener(this.keyListener);
        this.memoField.addKeyListener(this.keyListener);
        this.numberField.getEditor().getEditorComponent().addKeyListener(this.keyListener);
        this.payeeField.addKeyListener(this.keyListener);
        this.enterButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AbstractBankTransactionPanel.this.enterAction();
                }
            }
        });
        if (this.payeeField instanceof AutoCompleteTextField) {
            this.payeeField.addFocusListener(new PayeeFocusListener());
        }
        this.setFocusCycleRoot(true);
    }

    private void registerListeners() {
        this.cancelButton.addActionListener(this);
        this.enterButton.addActionListener(this);
    }

    private void registerMessageBusListeners() {
        MessageBus.getInstance().registerListener(this, MessageChannel.TRANSACTION);
    }

    @Override
    protected Account getAccount() {
        return this.account;
    }

    @Override
    public void clearForm() {
        this.amountField.setDecimal(null);
        if (!AbstractBankTransactionPanel.getRememberLastDate()) {
            this.datePanel.setDate(new Date());
        }
        this.memoField.setText(null);
        this.numberField.setText(null);
        this.payeeField.setText(null);
        this.reconciledButton.setSelected(false);
        this.modTrans = null;
    }

    public void setAutoComplete(boolean complete) {
        this.autoComplete = complete;
    }

    @Override
    protected boolean validateForm() {
        if (this.amountField.getText().length() == 0) {
            ValidationFactory.showValidationError(this.rb.getString("Message.Error.Value"), this.amountField);
            return false;
        }
        return true;
    }

    void cancelAction() {
        this.clearForm();
        this.fireCancelAction();
        this.focusFirstComponent();
    }

    @Override
    public void enterAction() {
        if (this.validateForm()) {
            if (this.modTrans == null) {
                Transaction newTrans = this.buildTransaction();
                ReconcileManager.reconcileTransaction(this.getAccount(), newTrans, this.reconciledButton.isSelected());
                EngineFactory.getEngine("default").addTransaction(newTrans);
            } else {
                Transaction newTrans = this.buildTransaction();
                newTrans.setDateEntered(this.modTrans.getDateEntered());
                for (Account a : this.modTrans.getAccounts()) {
                    if (a.equals(this.getAccount())) continue;
                    ReconcileManager.reconcileTransaction(a, newTrans, this.modTrans.getReconciled(a));
                }
                ReconcileManager.reconcileTransaction(this.getAccount(), newTrans, this.reconciledButton.isSelected());
                Engine engine = EngineFactory.getEngine("default");
                if (engine.removeTransaction(this.modTrans)) {
                    engine.addTransaction(newTrans);
                }
            }
            this.clearForm();
            this.fireOkAction();
            this.focusFirstComponent();
        }
    }

    @Override
    public void messagePosted(final Message event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (event.getEvent() == ChannelEvent.TRANSACTION_REMOVE && event.getObject(MessageProperty.TRANSACTION).equals(AbstractBankTransactionPanel.this.modTrans)) {
                    AbstractBankTransactionPanel.this.clearForm();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.cancelAction();
        } else if (e.getSource() == this.enterButton) {
            this.enterAction();
        }
    }

    protected abstract boolean canModifyTransaction(Transaction var1);

    Transaction modifyTransactionForAutoComplete(Transaction t) {
        t.setNumber(null);
        t.setReconciled(ReconciledState.NOT_RECONCILED);
        if (!AbstractBankTransactionPanel.getRememberLastDate()) {
            t.setDate(new Date());
        } else {
            t.setDate(this.datePanel.getDate());
        }
        if (!this.amountField.getText().isEmpty()) {
            Transaction newTrans = this.buildTransaction();
            t.clearTransactionEntries();
            t.addTransactionEntries(newTrans.getTransactionEntries());
        }
        if (!this.memoField.getText().isEmpty()) {
            t.setMemo(this.memoField.getText());
        }
        return t;
    }

    private class PayeeFocusListener
    extends FocusAdapter {
        private PayeeFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            Transaction t;
            AutoCompleteTextField f;
            if (AbstractBankTransactionPanel.this.modTrans == null && AbstractBankTransactionPanel.this.autoComplete && (f = (AutoCompleteTextField)AbstractBankTransactionPanel.this.payeeField).getText() != null && !f.getText().isEmpty() && (t = (Transaction)f.getModel().getExtraInfo(f.getText())) != null && AbstractBankTransactionPanel.this.canModifyTransaction(t)) {
                try {
                    AbstractBankTransactionPanel.this.modifyTransaction(AbstractBankTransactionPanel.this.modifyTransactionForAutoComplete((Transaction)t.clone()));
                }
                catch (CloneNotSupportedException ex) {
                    Logger.getLogger(AbstractBankTransactionPanel.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                }
                AbstractBankTransactionPanel.this.modTrans = null;
            }
        }
    }
}

