/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import java.awt.Color;
import java.util.List;
import java.util.prefs.Preferences;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.AccountType;
import jgnash.engine.TransactionEntry;
import jgnash.ui.register.AbstractRegisterPanel;
import jgnash.ui.register.LiabilityRegisterPanel;
import jgnash.ui.register.RegisterPanel;
import jgnash.ui.register.invest.InvestmentRegisterPanel;
import jgnash.ui.register.table.AbstractRegisterTableModel;
import jgnash.ui.register.table.ClippingDecorator;
import jgnash.ui.register.table.ClippingModel;
import jgnash.ui.register.table.FilterDecorator;
import jgnash.ui.register.table.FilterModel;
import jgnash.ui.register.table.InvestmentRegisterTableModel;
import jgnash.ui.register.table.RegisterTable;
import jgnash.ui.register.table.RegisterTableModel;
import jgnash.ui.register.table.RegisterTableWithSplitEntriesModel;
import jgnash.ui.register.table.SortableTableModel;
import jgnash.ui.register.table.SortedInvestmentTableModel;
import jgnash.ui.register.table.SortedRegisterTable;
import jgnash.ui.register.table.SortedTableModel;
import jgnash.ui.register.table.SplitsRegisterTableModel;
import jgnash.util.Resource;

public class RegisterFactory {
    private static final String ACCOUNTINGTERMS = "accountingterms";
    private static final String EVENCOLOR = "EvenColor";
    private static final String ODDCOLOR = "OddColor";
    private static final Resource rb = Resource.get();
    private static boolean sortable;
    private static boolean useAccountingTerms;
    private static boolean confirmTransactionDelete;
    private static final String SORTABLE = "sortable";
    private static final String CONFIRMDELETE = "confirmdelete";
    private static Color evenBackgroundColor;
    private static Color oddBackgroundColor;
    private static String[] BANK_NAMES;
    private static String[] GENERIC_NAMES;
    private static String[] CASH_NAMES;
    private static String[] EXPENSE_NAMES;
    private static String[] INCOME_NAMES;
    private static String[] CREDIT_NAMES;
    private static String[] EQUITY_NAMES;
    private static String[] LIABILITY_NAMES;
    private static String[] ACCOUNTING_NAMES;
    private static String[] SPLIT_ACCOUNTING_NAMES;
    private static String[] SPLIT_CREDIT_NAMES;
    private static String[] SPLIT_EXPENSE_NAMES;
    private static String[] SPLIT_INCOME_NAMES;
    private static String[] SPLIT_CASH_NAMES;
    private static String[] SPLIT_EQUITY_NAMES;
    private static String[] SPLIT_LIABILITY_NAMES;
    private static String[] SPLIT_BANK_NAMES;
    private static String[] SPLIT_GAINLOSS_NAMES;
    private static String[] SPLIT_GENERIC_NAMES;

    private RegisterFactory() {
    }

    public static void setOddColor(Color color) {
        Preferences p = Preferences.userNodeForPackage(RegisterFactory.class);
        p.putInt(ODDCOLOR, color.getRGB());
        oddBackgroundColor = color;
    }

    public static Color getOddColor() {
        return oddBackgroundColor;
    }

    public static Color getEvenColor() {
        return evenBackgroundColor;
    }

    public static void setEvenColor(Color color) {
        Preferences p = Preferences.userNodeForPackage(RegisterFactory.class);
        p.putInt(EVENCOLOR, color.getRGB());
        evenBackgroundColor = color;
    }

    public static void setSortingEnabled(boolean enabled) {
        sortable = enabled;
        Preferences p = Preferences.userNodeForPackage(RegisterFactory.class);
        p.putBoolean(SORTABLE, sortable);
    }

    public static boolean isSortingEnabled() {
        return sortable;
    }

    public static void setConfirmTransactionDeleteEnabled(boolean enabled) {
        confirmTransactionDelete = enabled;
        Preferences p = Preferences.userNodeForPackage(RegisterFactory.class);
        p.putBoolean(CONFIRMDELETE, confirmTransactionDelete);
    }

    public static boolean isConfirmTransactionDeleteEnabled() {
        return confirmTransactionDelete;
    }

    public static void setAccountingTermsEnabled(boolean enabled) {
        useAccountingTerms = enabled;
        Preferences p = Preferences.userNodeForPackage(RegisterFactory.class);
        p.putBoolean(ACCOUNTINGTERMS, useAccountingTerms);
    }

    public static boolean isAccountingTermsEnabled() {
        return useAccountingTerms;
    }

    public static RegisterTable generateTable(Account account) {
        AbstractRegisterTableModel m = RegisterFactory.getTableModel(account);
        if (m instanceof SortableTableModel) {
            return new SortedRegisterTable(m);
        }
        return new RegisterTable(m);
    }

    private static AbstractRegisterTableModel getTableModel(Account account) {
        return RegisterFactory.getTableModel(sortable, account, false);
    }

    public static ClippingModel getClippingTableModel(Account account, boolean detailSplits) {
        return new ClippingDecorator(RegisterFactory.getTableModel(false, account, detailSplits));
    }

    public static FilterModel getFilterTableModel(Account account, boolean detailSplits) {
        return new FilterDecorator(RegisterFactory.getTableModel(false, account, detailSplits));
    }

    private static String[] getColumnNames(Account account) {
        String[] names = useAccountingTerms ? ACCOUNTING_NAMES : (account.getAccountType() == AccountType.CREDIT ? CREDIT_NAMES : (account.getAccountType() == AccountType.EXPENSE ? EXPENSE_NAMES : (account.getAccountType() == AccountType.INCOME ? INCOME_NAMES : (account.getAccountType() == AccountType.CASH ? CASH_NAMES : (account.getAccountType() == AccountType.EQUITY ? EQUITY_NAMES : (account.getAccountType() == AccountType.LIABILITY ? LIABILITY_NAMES : (account.getAccountType().getAccountGroup() == AccountGroup.ASSET ? BANK_NAMES : GENERIC_NAMES)))))));
        return names;
    }

    private static AbstractRegisterTableModel getTableModel(boolean sort, Account account, boolean detailSplits) {
        if (account.memberOf(AccountGroup.INVEST)) {
            if (sort) {
                return new SortedInvestmentTableModel(account);
            }
            return new InvestmentRegisterTableModel(account);
        }
        String[] names = RegisterFactory.getColumnNames(account);
        RegisterTableModel model = sort ? new SortedTableModel(account, names) : new RegisterTableWithSplitEntriesModel(account, names, detailSplits);
        return model;
    }

    protected static RegisterTable generateSplitsTable(Account account, List<TransactionEntry> splits) {
        String[] names = useAccountingTerms ? SPLIT_ACCOUNTING_NAMES : (account.getAccountType() == AccountType.CREDIT ? SPLIT_CREDIT_NAMES : (account.getAccountType() == AccountType.EXPENSE ? SPLIT_EXPENSE_NAMES : (account.getAccountType() == AccountType.INCOME ? SPLIT_INCOME_NAMES : (account.getAccountType() == AccountType.CASH ? SPLIT_CASH_NAMES : (account.getAccountType() == AccountType.EQUITY ? SPLIT_EQUITY_NAMES : (account.getAccountType() == AccountType.LIABILITY ? SPLIT_LIABILITY_NAMES : (account.memberOf(AccountGroup.ASSET) ? SPLIT_BANK_NAMES : SPLIT_GENERIC_NAMES)))))));
        return new RegisterTable(new SplitsRegisterTableModel(account, names, splits));
    }

    public static RegisterTable generateInvestmentFeesTable(Account account, List<TransactionEntry> splits) {
        if (!account.memberOf(AccountGroup.INVEST)) {
            throw new RuntimeException("The supplied account does not belong to the Investment group");
        }
        String[] names = useAccountingTerms ? SPLIT_ACCOUNTING_NAMES : SPLIT_GENERIC_NAMES;
        return new RegisterTable(new SplitsRegisterTableModel(account, names, splits));
    }

    public static RegisterTable generateInvestmentGainsLossTable(Account account, List<TransactionEntry> splits) {
        if (!account.memberOf(AccountGroup.INVEST)) {
            throw new RuntimeException("The supplied account does not belong to the Investment group");
        }
        String[] names = useAccountingTerms ? SPLIT_ACCOUNTING_NAMES : SPLIT_GAINLOSS_NAMES;
        return new RegisterTable(new SplitsRegisterTableModel(account, names, splits));
    }

    protected static AbstractRegisterPanel createRegisterPanel(Account account) {
        if (account.memberOf(AccountGroup.INVEST)) {
            return new InvestmentRegisterPanel(account);
        }
        if (account.getAccountType() == AccountType.LIABILITY) {
            return new LiabilityRegisterPanel(account);
        }
        return new RegisterPanel(account);
    }

    public static String[] getCreditDebitTabNames(Account account) {
        if (RegisterFactory.isAccountingTermsEnabled()) {
            if (account.memberOf(AccountGroup.INCOME) || account.memberOf(AccountGroup.EXPENSE) || account.memberOf(AccountGroup.ASSET) || account.memberOf(AccountGroup.INVEST) || account.memberOf(AccountGroup.LIABILITY)) {
                return new String[]{rb.getString("Column.Debit"), rb.getString("Column.Credit")};
            }
            return new String[]{rb.getString("Column.Credit"), rb.getString("Column.Debit")};
        }
        if (account.getAccountType() == AccountType.CREDIT) {
            return new String[]{rb.getString("Column.Payment"), rb.getString("Column.Charge")};
        }
        if (account.getAccountType() == AccountType.EXPENSE) {
            return new String[]{rb.getString("Column.Expense"), rb.getString("Column.Rebate")};
        }
        if (account.getAccountType() == AccountType.INCOME) {
            return new String[]{rb.getString("Column.Charge"), rb.getString("Column.Income")};
        }
        if (account.getAccountType() == AccountType.CASH) {
            return new String[]{rb.getString("Column.Receive"), rb.getString("Column.Spend")};
        }
        if (account.getAccountType() == AccountType.LIABILITY) {
            return new String[]{rb.getString("Column.Decrease"), rb.getString("Column.Increase")};
        }
        if (account.getAccountType() == AccountType.EQUITY) {
            return new String[]{rb.getString("Column.Decrease"), rb.getString("Column.Increase")};
        }
        if (account.getAccountType().getAccountGroup() == AccountGroup.ASSET) {
            return new String[]{rb.getString("Column.Deposit"), rb.getString("Column.Withdrawal")};
        }
        return new String[]{rb.getString("Column.Increase"), rb.getString("Column.Decrease")};
    }

    public static String[] getGainLossTabNames() {
        if (RegisterFactory.isAccountingTermsEnabled()) {
            return new String[]{rb.getString("Column.Debit"), rb.getString("Column.Credit")};
        }
        return new String[]{rb.getString("Column.Gain"), rb.getString("Column.Loss")};
    }

    static {
        Preferences p = Preferences.userNodeForPackage(RegisterFactory.class);
        sortable = p.getBoolean(SORTABLE, true);
        useAccountingTerms = p.getBoolean(ACCOUNTINGTERMS, false);
        confirmTransactionDelete = p.getBoolean(CONFIRMDELETE, false);
        oddBackgroundColor = new Color(p.getInt(ODDCOLOR, Color.WHITE.getRGB()));
        evenBackgroundColor = new Color(p.getInt(EVENCOLOR, 14809055));
        BANK_NAMES = new String[]{rb.getString("Column.Date"), rb.getString("Column.Num"), rb.getString("Column.Payee"), rb.getString("Column.Memo"), rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Deposit"), rb.getString("Column.Withdrawal"), rb.getString("Column.Balance")};
        GENERIC_NAMES = new String[]{rb.getString("Column.Date"), rb.getString("Column.Num"), rb.getString("Column.Payee"), rb.getString("Column.Memo"), rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Increase"), rb.getString("Column.Decrease"), rb.getString("Column.Balance")};
        CASH_NAMES = new String[]{rb.getString("Column.Date"), rb.getString("Column.Num"), rb.getString("Column.Payee"), rb.getString("Column.Memo"), rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Receive"), rb.getString("Column.Spend"), rb.getString("Column.Balance")};
        EXPENSE_NAMES = new String[]{rb.getString("Column.Date"), rb.getString("Column.Num"), rb.getString("Column.Payee"), rb.getString("Column.Memo"), rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Expense"), rb.getString("Column.Rebate"), rb.getString("Column.Balance")};
        INCOME_NAMES = new String[]{rb.getString("Column.Date"), rb.getString("Column.Num"), rb.getString("Column.Payee"), rb.getString("Column.Memo"), rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Charge"), rb.getString("Column.Income"), rb.getString("Column.Balance")};
        CREDIT_NAMES = new String[]{rb.getString("Column.Date"), rb.getString("Column.Num"), rb.getString("Column.Payee"), rb.getString("Column.Memo"), rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Payment"), rb.getString("Column.Charge"), rb.getString("Column.Balance")};
        EQUITY_NAMES = new String[]{rb.getString("Column.Date"), rb.getString("Column.Num"), rb.getString("Column.Payee"), rb.getString("Column.Memo"), rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Decrease"), rb.getString("Column.Increase"), rb.getString("Column.Balance")};
        LIABILITY_NAMES = EQUITY_NAMES;
        ACCOUNTING_NAMES = new String[]{rb.getString("Column.Date"), rb.getString("Column.Num"), rb.getString("Column.Payee"), rb.getString("Column.Memo"), rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Debit"), rb.getString("Column.Credit"), rb.getString("Column.Balance")};
        SPLIT_ACCOUNTING_NAMES = new String[]{rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Memo"), rb.getString("Column.Debit"), rb.getString("Column.Credit"), rb.getString("Column.Balance")};
        SPLIT_CREDIT_NAMES = new String[]{rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Memo"), rb.getString("Column.Payment"), rb.getString("Column.Charge"), rb.getString("Column.Balance")};
        SPLIT_EXPENSE_NAMES = new String[]{rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Memo"), rb.getString("Column.Expense"), rb.getString("Column.Rebate"), rb.getString("Column.Balance")};
        SPLIT_INCOME_NAMES = new String[]{rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Memo"), rb.getString("Column.Charge"), rb.getString("Column.Income"), rb.getString("Column.Balance")};
        SPLIT_CASH_NAMES = new String[]{rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Memo"), rb.getString("Column.Receive"), rb.getString("Column.Spend"), rb.getString("Column.Balance")};
        SPLIT_EQUITY_NAMES = new String[]{rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Memo"), rb.getString("Column.Decrease"), rb.getString("Column.Increase"), rb.getString("Column.Balance")};
        SPLIT_LIABILITY_NAMES = SPLIT_EQUITY_NAMES;
        SPLIT_BANK_NAMES = new String[]{rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Memo"), rb.getString("Column.Deposit"), rb.getString("Column.Withdrawal"), rb.getString("Column.Balance")};
        SPLIT_GAINLOSS_NAMES = new String[]{rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Memo"), rb.getString("Column.Gain"), rb.getString("Column.Loss"), rb.getString("Column.Balance")};
        SPLIT_GENERIC_NAMES = new String[]{rb.getString("Column.Account"), rb.getString("Column.Clr"), rb.getString("Column.Memo"), rb.getString("Column.Deposit"), rb.getString("Column.Withdrawal"), rb.getString("Column.Balance")};
    }
}

