/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import jgnash.engine.EngineFactory;
import jgnash.ui.components.JTextFieldEx;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class TransactionNumberDialog
extends JDialog
implements ActionListener {
    private JList list;
    private DefaultListModel model;
    private JTextField entryField;
    private JButton insertButton;
    private JButton okButton;
    private JButton cancelButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;

    public static void showDialog(JFrame parent) {
        try {
            TransactionNumberDialog dlg = new TransactionNumberDialog(parent);
            dlg.setVisible(true);
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, e.toString(), e);
        }
    }

    private TransactionNumberDialog(JFrame parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.layoutDialog();
        this.setDefaultCloseOperation(2);
        DialogUtils.addBoundsListener(this);
    }

    private void initComponents() {
        Resource rb = Resource.get();
        this.setTitle(rb.getString("Title.DefTranNum"));
        this.okButton = new JButton(rb.getString("Button.Ok"));
        this.cancelButton = new JButton(rb.getString("Button.Cancel"));
        this.insertButton = new JButton(rb.getString("Button.Insert"));
        this.removeButton = new JButton(rb.getString("Button.Remove"));
        this.upButton = new JButton(Resource.getIcon("/jgnash/resource/stock_up-16.png"));
        this.downButton = new JButton(Resource.getIcon("/jgnash/resource/stock_down-16.png"));
        this.insertButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.model = new DefaultListModel();
        List<String> items = EngineFactory.getEngine("default").getTransactionNumberList();
        for (String s : items) {
            this.model.addElement(s);
        }
        this.list = new JList(this.model);
        this.entryField = new JTextFieldEx(10);
    }

    private void layoutDialog() {
        FormLayout layout = new FormLayout("p:g", "f:p:g(1.0)");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)this.layoutPanel());
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    private JPanel layoutPanel() {
        FormLayout layout = new FormLayout("75dlu:g, 8dlu, p", "f:p:g(1.0)");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        JScrollPane scrollPane = new JScrollPane(this.list);
        builder.append((Component)scrollPane, (Component)this.layoutButtonPanel());
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)this.entryField, (Component)this.insertButton);
        return builder.getPanel();
    }

    private JPanel layoutButtonPanel() {
        FormLayout layout = new FormLayout("p:g", "d, 6dlu, d, f:p:g(1.0), d");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append((Component)this.upButton);
        builder.nextLine();
        builder.nextLine();
        builder.append((Component)this.downButton);
        builder.nextLine();
        builder.nextLine();
        builder.append((Component)this.removeButton);
        return builder.getPanel();
    }

    private void close() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void okAction() {
        ListModel listModel = this.list.getModel();
        int size = listModel.getSize();
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            items.add(listModel.getElementAt(i).toString());
        }
        EngineFactory.getEngine("default").setTransactionNumberList(items);
        this.close();
    }

    private void addAction() {
        if (this.entryField.getText().length() > 0) {
            if (this.list.getSelectedIndex() >= 0) {
                this.model.add(this.list.getSelectedIndex(), this.entryField.getText());
            } else {
                this.model.addElement(this.entryField.getText());
            }
            this.entryField.setText(null);
        }
    }

    private void removeAction() {
        if (this.list.getSelectedIndex() >= 0) {
            this.model.remove(this.list.getSelectedIndex());
        }
    }

    private void upAction() {
        if (this.list.getSelectedIndex() >= 1) {
            int index = this.list.getSelectedIndex();
            this.model.add(index - 1, this.model.remove(index));
        }
    }

    private void downAction() {
        if (this.list.getSelectedIndex() < this.model.getSize() - 1) {
            int index = this.list.getSelectedIndex();
            this.model.add(index + 1, this.model.remove(index));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.okAction();
        } else if (e.getSource() == this.cancelButton) {
            this.close();
        } else if (e.getSource() == this.insertButton) {
            this.addAction();
        } else if (e.getSource() == this.removeButton) {
            this.removeAction();
        } else if (e.getSource() == this.upButton) {
            this.upAction();
        } else if (e.getSource() == this.downButton) {
            this.downAction();
        }
    }
}

