/*
 * Decompiled with CFR 0.152.
 */
package jgnash.util;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import jgnash.util.ObjectPool;

public class DateUtils {
    private static final int DAYS_PER_YEAR = 365;
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    private static final long AVERAGE_MILLISECONDS_PER_MONTH = 2628000000L;
    private static String[] localizedMonthNames;
    private static Locale lastLocale;
    private static final ObjectPool<GregorianCalendar> calendarPool;
    private static final Pattern MONTH_PATTERN;
    private static final Pattern DAY_PATTERN;

    private DateUtils() {
    }

    private static void updateMonthNames() {
        if (lastLocale != Locale.getDefault()) {
            DateFormatSymbols symbols = new DateFormatSymbols();
            localizedMonthNames = symbols.getMonths();
            lastLocale = Locale.getDefault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNameOfMonth(Date date) {
        DateUtils.updateMonthNames();
        GregorianCalendar c = calendarPool.take();
        try {
            c.setTime(date);
            String string = localizedMonthNames[c.get(2)];
            return string;
        }
        finally {
            calendarPool.put(c);
        }
    }

    public static Date addDay(Date date) {
        return DateUtils.addDays(date, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date addDays(Date date, int days) {
        GregorianCalendar c = calendarPool.take();
        try {
            c.setTime(date);
            c.add(5, days);
            Date date2 = c.getTime();
            return date2;
        }
        finally {
            calendarPool.put(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date addMonth(Date date) {
        GregorianCalendar c = calendarPool.take();
        try {
            c.setTime(date);
            c.add(2, 1);
            Date date2 = c.getTime();
            return date2;
        }
        finally {
            calendarPool.put(c);
        }
    }

    public static boolean after(Date d1, Date d2) {
        return DateUtils.before(d2, d1, true);
    }

    public static boolean after(Date d1, Date d2, boolean inclusive) {
        return DateUtils.before(d2, d1, inclusive);
    }

    public static boolean before(Date d1, Date d2) {
        return DateUtils.before(d1, d2, true);
    }

    public static boolean before(Date d1, Date d2, boolean inclusive) {
        if (inclusive) {
            return d1.getTime() <= d2.getTime();
        }
        return d1.getTime() < d2.getTime();
    }

    public static int getCurrentYear() {
        return DateUtils.getYear(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getYear(Date date) {
        GregorianCalendar c = calendarPool.take();
        try {
            c.setTime(date);
            int n = c.get(1);
            return n;
        }
        finally {
            calendarPool.put(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDateOfTheYear(int year, int dayOfYear) {
        GregorianCalendar c = calendarPool.take();
        try {
            c.setTime(DateUtils.trimDate(c.getTime()));
            c.set(1, year);
            c.set(6, dayOfYear);
            Date date = c.getTime();
            return date;
        }
        finally {
            calendarPool.put(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDayOfTheYear(Date dateOfYear) {
        GregorianCalendar c = calendarPool.take();
        try {
            c.setTime(dateOfYear);
            int n = c.get(6);
            return n;
        }
        finally {
            calendarPool.put(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDaysInMonth(Date date) {
        GregorianCalendar c = calendarPool.take();
        try {
            c.setTime(date);
            c.set(c.get(1), c.get(2), c.getActualMaximum(5));
            int n = c.get(5);
            return n;
        }
        finally {
            calendarPool.put(c);
        }
    }

    public static int getDaysInYear(int year) {
        if (DateUtils.isLeapYear(year)) {
            return 366;
        }
        return 365;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDifferenceInDays(Date startDate, Date endDate) {
        GregorianCalendar c = calendarPool.take();
        try {
            c.setTime(DateUtils.trimDate(startDate));
            long startMilli = c.getTimeInMillis() + (long)c.getTimeZone().getOffset(c.getTimeInMillis());
            c.setTime(DateUtils.trimDate(endDate));
            long endMilli = c.getTimeInMillis() + (long)c.getTimeZone().getOffset(c.getTimeInMillis());
            int n = (int)((endMilli - startMilli) / 86400000L);
            return n;
        }
        finally {
            calendarPool.put(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float getDifferenceInMonths(Date startDate, Date endDate) {
        GregorianCalendar c = calendarPool.take();
        try {
            c.setTime(DateUtils.trimDate(startDate));
            long startMilli = c.getTimeInMillis() + (long)c.getTimeZone().getOffset(c.getTimeInMillis());
            c.setTime(DateUtils.trimDate(endDate));
            long endMilli = c.getTimeInMillis() + (long)c.getTimeZone().getOffset(c.getTimeInMillis());
            float f = ((float)endMilli - (float)startMilli) / 2.628E9f;
            return f;
        }
        finally {
            calendarPool.put(c);
        }
    }

    public static Date[] getFirstDayBiWeekly(int year) {
        ArrayList<Date> dates = new ArrayList<Date>();
        Date[] allWeeks = DateUtils.getFirstDayWeekly(year);
        for (int i = 0; i < allWeeks.length; i += 2) {
            dates.add(allWeeks[i]);
        }
        return dates.toArray(new Date[dates.size()]);
    }

    public static Date[] getFirstDayMonthly(int year) {
        Date[] list = new Date[12];
        for (int i = 0; i < 12; ++i) {
            list[i] = DateUtils.getFirstDayOfTheMonth(i, year);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getFirstDayOfTheMonth(Date date) {
        GregorianCalendar c = calendarPool.take();
        try {
            c.setTime(date);
            c.set(c.get(1), c.get(2), c.getActualMinimum(5));
            Date date2 = DateUtils.trimDate(c.getTime());
            return date2;
        }
        finally {
            calendarPool.put(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getFirstDayOfTheMonth(int month, int year) {
        assert (month >= 0 && month <= 11);
        GregorianCalendar c = calendarPool.take();
        try {
            c.set(year, month, 15);
            c.set(c.get(1), c.get(2), c.getActualMinimum(5));
            Date date = DateUtils.trimDate(c.getTime());
            return date;
        }
        finally {
            calendarPool.put(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date[] getFirstDayQuarterly(int year) {
        GregorianCalendar c = calendarPool.take();
        try {
            Date[] bounds = new Date[4];
            c.set(year, 0, 1, 0, 0, 0);
            bounds[0] = c.getTime();
            c.set(year, 3, 1, 0, 0, 0);
            bounds[1] = c.getTime();
            c.set(year, 6, 1, 0, 0, 0);
            bounds[2] = c.getTime();
            c.set(year, 9, 1, 0, 0, 0);
            bounds[3] = c.getTime();
            Date[] dateArray = bounds;
            return dateArray;
        }
        finally {
            calendarPool.put(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date[] getFirstDayWeekly(int year) {
        GregorianCalendar cal = calendarPool.take();
        GregorianCalendar testCal = calendarPool.take();
        try {
            ArrayList<Date> dates = new ArrayList<Date>();
            cal.setTime(DateUtils.trimDate(cal.getTime()));
            cal.set(1, year);
            cal.set(2, 0);
            cal.set(3, 1);
            cal.set(7, cal.getFirstDayOfWeek());
            for (int i = 0; i < 53; ++i) {
                testCal.setTime(cal.getTime());
                testCal.set(7, 5);
                if (testCal.get(1) == year) {
                    dates.add(cal.getTime());
                }
                cal.add(5, 7);
            }
            Date[] dateArray = dates.toArray(new Date[dates.size()]);
            return dateArray;
        }
        finally {
            calendarPool.put(cal);
            calendarPool.put(testCal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date[] getAllDays(int year) {
        GregorianCalendar cal = calendarPool.take();
        try {
            ArrayList<Date> dates = new ArrayList<Date>();
            cal.setTime(DateUtils.trimDate(cal.getTime()));
            cal.set(1, year);
            cal.set(cal.get(1), cal.getActualMinimum(2), cal.getMinimum(5));
            Date startDate = cal.getTime();
            for (int i = 0; i < DateUtils.getDaysInYear(year); ++i) {
                dates.add(DateUtils.addDays(startDate, i));
            }
            Date[] dateArray = dates.toArray(new Date[dates.size()]);
            return dateArray;
        }
        finally {
            calendarPool.put(cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getLastDayOfTheMonth(Date date) {
        assert (date != null);
        GregorianCalendar c = calendarPool.take();
        try {
            c.setTime(date);
            c.set(c.get(1), c.get(2), c.getActualMaximum(5));
            Date date2 = DateUtils.trimDate(c.getTime());
            return date2;
        }
        finally {
            calendarPool.put(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getLastDayOfTheMonth(int month, int year) {
        assert (month >= 0 && month <= 11);
        GregorianCalendar c = calendarPool.take();
        try {
            c.set(year, month, 15);
            c.set(c.get(1), c.get(2), c.getActualMaximum(5));
            Date date = DateUtils.trimDate(c.getTime());
            return date;
        }
        finally {
            calendarPool.put(c);
        }
    }

    public static List<Date> getLastDayOfTheMonths(Date startDate, Date endDate) {
        ArrayList<Date> list = new ArrayList<Date>();
        Date end = DateUtils.getLastDayOfTheMonth(endDate);
        Date t = DateUtils.getLastDayOfTheMonth(startDate);
        while (DateUtils.before(t, end)) {
            list.add(t);
            t = DateUtils.getLastDayOfTheMonth(DateUtils.addMonth(t));
        }
        return list;
    }

    public static Date getLastDayOfTheQuarter(Date date) {
        Date[] bounds;
        assert (date != null);
        Date leveledDate = DateUtils.trimDate(date);
        Date result = leveledDate.compareTo((bounds = DateUtils.getQuarterBounds(leveledDate))[2]) < 0 ? bounds[1] : (leveledDate.compareTo(bounds[4]) < 0 ? bounds[3] : (leveledDate.compareTo(bounds[6]) < 0 ? bounds[5] : bounds[7]));
        return DateUtils.trimDate(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getLastDayOfTheYear(Date date) {
        assert (date != null);
        GregorianCalendar c = calendarPool.take();
        try {
            c.setTime(date);
            c.set(c.get(1), c.getActualMaximum(2), c.getMaximum(5));
            Date date2 = DateUtils.trimDate(c.getTime());
            return date2;
        }
        finally {
            calendarPool.put(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date[] getQuarterBounds(Date date) {
        assert (date != null);
        GregorianCalendar c = calendarPool.take();
        try {
            c.setTime(date);
            int year = c.get(1);
            Date[] bounds = new Date[8];
            c.set(year, 0, 1, 0, 0, 0);
            bounds[0] = c.getTime();
            c.set(year, 2, 31, 0, 0, 0);
            bounds[1] = c.getTime();
            c.set(year, 3, 1, 0, 0, 0);
            bounds[2] = c.getTime();
            c.set(year, 5, 30, 0, 0, 0);
            bounds[3] = c.getTime();
            c.set(year, 6, 1, 0, 0, 0);
            bounds[4] = c.getTime();
            c.set(year, 8, 30, 0, 0, 0);
            bounds[5] = c.getTime();
            c.set(year, 9, 1, 0, 0, 0);
            bounds[6] = c.getTime();
            c.set(year, 11, 31, 0, 0, 0);
            bounds[7] = c.getTime();
            Date[] dateArray = bounds;
            return dateArray;
        }
        finally {
            calendarPool.put(c);
        }
    }

    public static int getQuarterNumber(Date date) {
        assert (date != null);
        Date[] bounds = DateUtils.getQuarterBounds(date);
        int result = date.compareTo(bounds[2]) < 0 ? 1 : (date.compareTo(bounds[4]) < 0 ? 2 : (date.compareTo(bounds[6]) < 0 ? 3 : 4));
        return result;
    }

    public static DateFormat getShortDateFormat() {
        DateFormat df = DateFormat.getDateInstance(3);
        if (df instanceof SimpleDateFormat) {
            String pattern = ((SimpleDateFormat)df).toPattern();
            pattern = DAY_PATTERN.matcher(MONTH_PATTERN.matcher(pattern).replaceAll("MM")).replaceAll("dd");
            ((SimpleDateFormat)df).applyPattern(pattern);
        }
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getWeekOfTheYear(Date dateOfYear) {
        GregorianCalendar c = calendarPool.take();
        int minimal = c.getMinimalDaysInFirstWeek();
        try {
            c.setTime(dateOfYear);
            c.setMinimalDaysInFirstWeek(4);
            int n = c.get(3);
            return n;
        }
        finally {
            c.setMinimalDaysInFirstWeek(minimal);
            calendarPool.put(c);
        }
    }

    public static boolean isLeapYear(int year) {
        boolean isLeapYear = year % 4 == 0;
        isLeapYear = isLeapYear && year % 100 != 0;
        return isLeapYear || year % 400 == 0;
    }

    public static Date subtractDay(Date date) {
        return DateUtils.addDays(date, -1);
    }

    public static Date subtractMonth(Date date) {
        return DateUtils.subtractMonths(date, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date subtractMonths(Date date, int months) {
        GregorianCalendar c = calendarPool.take();
        try {
            c.setTime(date);
            c.add(2, months * -1);
            Date date2 = c.getTime();
            return date2;
        }
        finally {
            calendarPool.put(c);
        }
    }

    public static Date subtractYear(Date date) {
        return DateUtils.addYears(date, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date addYears(Date date, int years) {
        GregorianCalendar c = calendarPool.take();
        try {
            c.setTime(date);
            c.add(1, years);
            Date date2 = c.getTime();
            return date2;
        }
        finally {
            calendarPool.put(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date trimDate(Date date) {
        GregorianCalendar c = calendarPool.take();
        try {
            c.setTime(date);
            c.set(14, 0);
            c.set(13, 0);
            c.set(12, 0);
            c.set(11, 0);
            Date date2 = c.getTime();
            return date2;
        }
        finally {
            calendarPool.put(c);
        }
    }

    static {
        calendarPool = new ObjectPool<GregorianCalendar>(){

            @Override
            public GregorianCalendar createInstance() {
                return new GregorianCalendar();
            }
        };
        MONTH_PATTERN = Pattern.compile("M{1,2}");
        DAY_PATTERN = Pattern.compile("d{1,2}");
    }
}

