/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.editor;

import EDU.purdue.cs.bloat.editor.ConstantPool;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.editor.EditorVisitor;
import EDU.purdue.cs.bloat.editor.FieldEditor;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.FieldInfo;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import EDU.purdue.cs.bloat.util.Assert;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class ClassEditor {
    public static boolean DEBUG = Boolean.getBoolean("ClassEditor.DEBUG");
    private ConstantPool constants;
    private ClassInfo classInfo;
    private Type type;
    private Type superclass;
    private Type[] interfaces;
    private EditorContext context;
    private boolean dirty;

    public ClassEditor(EditorContext context, ClassInfo classInfo) {
        this.context = context;
        this.classInfo = classInfo;
        this.dirty = false;
        this.constants = new ConstantPool(classInfo.constants());
        int index = classInfo.classIndex();
        this.type = (Type)this.constants.constantAt(index);
        index = classInfo.superclassIndex();
        this.superclass = (Type)this.constants.constantAt(index);
        int[] ifs = classInfo.interfaceIndices();
        this.interfaces = new Type[ifs.length];
        int i = 0;
        while (i < ifs.length) {
            this.interfaces[i] = (Type)this.constants.constantAt(ifs[i]);
            ++i;
        }
        if (DEBUG) {
            System.out.println("Editing class " + this.type);
        }
        this.setDirty(false);
    }

    public ClassEditor(EditorContext context, int modifiers, String className, Type superType, Type[] interfaces) {
        ConstantPool cp;
        if (className == null) {
            String s = "Cannot have a null class name";
            throw new IllegalArgumentException("Cannot have a null class name");
        }
        if (superType == null) {
            superType = Type.OBJECT;
        }
        if (interfaces == null) {
            interfaces = new Type[]{};
        }
        if (DEBUG) {
            System.out.println("Creating new class " + className + " extends " + superType.className());
        }
        this.context = context;
        this.superclass = superType;
        this.interfaces = interfaces;
        this.constants = cp = new ConstantPool();
        this.type = Type.getType(Type.classDescriptor(className));
        int classNameIndex = cp.getClassIndex(this.type);
        int superTypeIndex = cp.getClassIndex(superType);
        int[] interfaceIndexes = new int[interfaces.length];
        int i = 0;
        while (i < interfaces.length) {
            interfaceIndexes[i] = cp.getClassIndex(interfaces[i]);
            ++i;
        }
        this.classInfo = context.newClassInfo(modifiers, classNameIndex, superTypeIndex, interfaceIndexes, cp.getConstantsList());
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String name() {
        return this.classInfo().name();
    }

    public EditorContext context() {
        return this.context;
    }

    public ClassInfo classInfo() {
        return this.classInfo;
    }

    public boolean isPublic() {
        return (this.classInfo.modifiers() & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.classInfo.modifiers() & 2) != 0;
    }

    public boolean isProtected() {
        return (this.classInfo.modifiers() & 4) != 0;
    }

    public boolean isStatic() {
        return (this.classInfo.modifiers() & 8) != 0;
    }

    public boolean isFinal() {
        return (this.classInfo.modifiers() & 0x10) != 0;
    }

    public boolean isSuper() {
        return (this.classInfo.modifiers() & 0x20) != 0;
    }

    public boolean isAbstract() {
        return (this.classInfo.modifiers() & 0x400) != 0;
    }

    public boolean isInterface() {
        return (this.classInfo.modifiers() & 0x200) != 0;
    }

    public void setPublic(boolean flag) {
        int modifiers = this.classInfo.modifiers();
        modifiers = flag ? (modifiers |= 1) : (modifiers &= 0xFFFFFFFE);
        this.classInfo.setModifiers(modifiers);
        this.setDirty(true);
    }

    public void setPrivate(boolean flag) {
        int modifiers = this.classInfo.modifiers();
        modifiers = flag ? (modifiers |= 2) : (modifiers &= 0xFFFFFFFD);
        this.classInfo.setModifiers(modifiers);
        this.setDirty(true);
    }

    public void setProtected(boolean flag) {
        int modifiers = this.classInfo.modifiers();
        modifiers = flag ? (modifiers |= 4) : (modifiers &= 0xFFFFFFFB);
        this.classInfo.setModifiers(modifiers);
        this.setDirty(true);
    }

    public void setStatic(boolean flag) {
        int modifiers = this.classInfo.modifiers();
        modifiers = flag ? (modifiers |= 8) : (modifiers &= 0xFFFFFFF7);
        this.classInfo.setModifiers(modifiers);
        this.setDirty(true);
    }

    public void setFinal(boolean flag) {
        int modifiers = this.classInfo.modifiers();
        modifiers = flag ? (modifiers |= 0x10) : (modifiers &= 0xFFFFFFEF);
        this.classInfo.setModifiers(modifiers);
        this.setDirty(true);
    }

    public void setSuper(boolean flag) {
        int modifiers = this.classInfo.modifiers();
        modifiers = flag ? (modifiers |= 0x20) : (modifiers &= 0xFFFFFFDF);
        this.classInfo.setModifiers(modifiers);
        this.setDirty(true);
    }

    public void setAbstract(boolean flag) {
        int modifiers = this.classInfo.modifiers();
        modifiers = flag ? (modifiers |= 0x400) : (modifiers &= 0xFFFFFBFF);
        this.classInfo.setModifiers(modifiers);
        this.setDirty(true);
    }

    public void setInterface(boolean flag) {
        int modifiers = this.classInfo.modifiers();
        modifiers = flag ? (modifiers |= 0x200) : (modifiers &= 0xFFFFFDFF);
        this.classInfo.setModifiers(modifiers);
        this.setDirty(true);
    }

    public void setType(Type type) {
        this.type = type;
        Assert.isTrue(type.isObject(), "Cannot set class type to " + type);
        this.setDirty(true);
    }

    public Type type() {
        return this.type;
    }

    public Type superclass() {
        return this.superclass;
    }

    public void addInterface(Class interfaceClass) {
        if (!interfaceClass.isInterface()) {
            String s = "Cannot add non-interface type: " + interfaceClass.getName();
            throw new IllegalArgumentException(s);
        }
        this.addInterface(Type.getType(interfaceClass));
    }

    public void addInterface(Type interfaceType) {
        Type[] interfaces = new Type[this.interfaces.length + 1];
        int i = 0;
        while (i < this.interfaces.length) {
            interfaces[i] = this.interfaces[i];
            ++i;
        }
        interfaces[interfaces.length - 1] = interfaceType;
        this.setInterfaces(interfaces);
    }

    public void setInterfaces(Type[] interfaces) {
        this.interfaces = interfaces;
        this.setDirty(true);
    }

    public Type[] interfaces() {
        return this.interfaces;
    }

    public int modifiers() {
        return this.classInfo.modifiers();
    }

    public FieldInfo[] fields() {
        return this.classInfo.fields();
    }

    public MethodInfo[] methods() {
        return this.classInfo.methods();
    }

    public ConstantPool constants() {
        return this.constants;
    }

    public void commit() {
        this.commitOnly(null, null);
    }

    public void commitOnly(Set methods, Set fields) {
        this.classInfo.setClassIndex(this.constants.addConstant(7, this.type));
        this.classInfo.setSuperclassIndex(this.constants.addConstant(7, this.superclass));
        int[] ifs = new int[this.interfaces.length];
        int i = 0;
        while (i < ifs.length) {
            ifs[i] = this.constants.addConstant(7, this.interfaces[i]);
            ++i;
        }
        this.classInfo.setInterfaceIndices(ifs);
        this.classInfo.setConstants(this.constants.constants());
        this.classInfo.commitOnly(methods, fields);
        this.setDirty(false);
    }

    public void visit(EditorVisitor visitor) {
        visitor.visitClassEditor(this);
        EditorContext context = this.context();
        FieldInfo[] fields = this.fields();
        int i = 0;
        while (i < fields.length) {
            FieldEditor fieldEditor = context.editField(fields[i]);
            visitor.visitFieldEditor(fieldEditor);
            context.release(fields[i]);
            ++i;
        }
        ArrayList<MethodInfo> regularMethods = new ArrayList<MethodInfo>();
        MethodInfo[] methods = this.methods();
        int i2 = 0;
        while (i2 < methods.length) {
            MethodEditor methodEditor = context.editMethod(methods[i2]);
            if (methodEditor.name().charAt(0) != '<') {
                regularMethods.add(methods[i2]);
            } else {
                visitor.visitMethodEditor(methodEditor);
            }
            context.release(methods[i2]);
            ++i2;
        }
        Iterator iter = ((AbstractList)regularMethods).iterator();
        while (iter.hasNext()) {
            MethodInfo info = (MethodInfo)iter.next();
            MethodEditor me = context.editMethod(info);
            visitor.visitMethodEditor(me);
            context.release(info);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ClassEditor) {
            ClassEditor other = (ClassEditor)o;
            return other.type().equals(this.type());
        }
        return false;
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    public String toString() {
        return this.type().toString();
    }
}

