/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.expr.build;

import com.db4o.nativequery.expr.AndExpression;
import com.db4o.nativequery.expr.BinaryExpression;
import com.db4o.nativequery.expr.BoolConstExpression;
import com.db4o.nativequery.expr.ComparisonExpression;
import com.db4o.nativequery.expr.Expression;
import com.db4o.nativequery.expr.NotExpression;
import com.db4o.nativequery.expr.OrExpression;
import com.db4o.nativequery.expr.cmp.operand.ConstValue;

public class ExpressionBuilder {
    public Expression not(Expression expression) {
        ConstValue constValue;
        ComparisonExpression comparisonExpression;
        if (expression.equals(BoolConstExpression.TRUE)) {
            return BoolConstExpression.FALSE;
        }
        if (expression.equals(BoolConstExpression.FALSE)) {
            return BoolConstExpression.TRUE;
        }
        if (expression instanceof NotExpression) {
            return ((NotExpression)expression).expr();
        }
        if (expression instanceof ComparisonExpression && (comparisonExpression = (ComparisonExpression)expression).right() instanceof ConstValue && (constValue = (ConstValue)comparisonExpression.right()).value() instanceof Boolean) {
            Boolean bl = (Boolean)constValue.value();
            return new ComparisonExpression(comparisonExpression.left(), new ConstValue(new Boolean(bl == false)), comparisonExpression.op());
        }
        return new NotExpression(expression);
    }

    public Expression and(Expression expression, Expression expression2) {
        if (expression.equals(BoolConstExpression.FALSE) || expression2.equals(BoolConstExpression.FALSE)) {
            return BoolConstExpression.FALSE;
        }
        if (expression.equals(BoolConstExpression.TRUE)) {
            return expression2;
        }
        if (expression2.equals(BoolConstExpression.TRUE)) {
            return expression;
        }
        if (expression.equals(expression2)) {
            return expression;
        }
        if (this.negatives(expression, expression2)) {
            return BoolConstExpression.FALSE;
        }
        return new AndExpression(expression, expression2);
    }

    public Expression or(Expression expression, Expression expression2) {
        if (expression.equals(BoolConstExpression.TRUE) || expression2.equals(BoolConstExpression.TRUE)) {
            return BoolConstExpression.TRUE;
        }
        if (expression.equals(BoolConstExpression.FALSE)) {
            return expression2;
        }
        if (expression2.equals(BoolConstExpression.FALSE)) {
            return expression;
        }
        if (expression.equals(expression2)) {
            return expression;
        }
        if (this.negatives(expression, expression2)) {
            return BoolConstExpression.TRUE;
        }
        return new OrExpression(expression, expression2);
    }

    public BoolConstExpression constant(Boolean bl) {
        return BoolConstExpression.expr(bl);
    }

    public Expression ifThenElse(Expression expression, Expression expression2, Expression expression3) {
        Expression expression4 = this.checkBoolean(expression, expression2, expression3);
        if (expression4 != null) {
            return expression4;
        }
        return this.or(this.and(expression, expression2), this.and(this.not(expression), expression3));
    }

    private Expression checkBoolean(Expression expression, Expression expression2, Expression expression3) {
        Expression expression4;
        Expression expression5;
        Expression expression6;
        Expression expression7;
        if (expression instanceof BoolConstExpression) {
            return null;
        }
        if (expression2 instanceof BoolConstExpression) {
            boolean bl = expression2.equals(BoolConstExpression.FALSE);
            if (!bl) {
                return this.or(expression, expression3);
            }
            return this.and(this.not(expression), expression3);
        }
        if (expression3 instanceof BoolConstExpression) {
            boolean bl = expression3.equals(BoolConstExpression.FALSE);
            if (!bl) {
                return this.and(expression, expression2);
            }
            return this.or(this.not(expression), expression3);
        }
        if (expression instanceof NotExpression) {
            expression = ((NotExpression)expression).expr();
            expression7 = expression2;
            expression2 = expression3;
            expression3 = expression7;
        }
        if (expression2 instanceof OrExpression) {
            expression7 = (OrExpression)expression2;
            expression6 = ((BinaryExpression)expression7).left();
            expression5 = ((BinaryExpression)expression7).right();
            if (expression3.equals(expression5)) {
                expression4 = expression5;
                expression5 = expression6;
                expression6 = expression4;
            }
            if (expression3.equals(expression6)) {
                return this.or(expression6, this.and(expression, expression5));
            }
        }
        if (expression3 instanceof AndExpression) {
            expression7 = (AndExpression)expression3;
            expression6 = ((BinaryExpression)expression7).left();
            expression5 = ((BinaryExpression)expression7).right();
            if (expression2.equals(expression5)) {
                expression4 = expression5;
                expression5 = expression6;
                expression6 = expression4;
            }
            if (expression2.equals(expression6)) {
                return this.and(expression6, this.or(expression, expression5));
            }
        }
        return null;
    }

    private boolean negatives(Expression expression, Expression expression2) {
        return this.negativeOf(expression, expression2) || this.negativeOf(expression2, expression);
    }

    private boolean negativeOf(Expression expression, Expression expression2) {
        return expression instanceof NotExpression && ((NotExpression)expression).expr().equals(expression2);
    }
}

