/*
 * Decompiled with CFR 0.152.
 */
package BlowfishJ;

import BlowfishJ.BinConverter;
import BlowfishJ.BlowfishCBC;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class BlowfishEasy {
    BlowfishCBC m_bfish;
    static SecureRandom m_secRnd = new SecureRandom();

    public BlowfishEasy(String sPassword) {
        MessageDigest mds = null;
        try {
            mds = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        int nC = sPassword.length();
        for (int nI = 0; nI < nC; ++nI) {
            mds.update((byte)(sPassword.charAt(nI) & 0xFF));
        }
        byte[] hash = mds.digest();
        this.m_bfish = new BlowfishCBC(hash, 0, hash.length, 0L);
    }

    public String encryptString(String sPlainText) {
        long lCBCIV;
        SecureRandom secureRandom = m_secRnd;
        synchronized (secureRandom) {
            try {
                lCBCIV = m_secRnd.nextLong();
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                throw throwable;
            }
        }
        return this.encStr(sPlainText, lCBCIV);
    }

    public String encryptString(String sPlainText, Random rndGen) {
        long lCBCIV = rndGen.nextLong();
        return this.encStr(sPlainText, lCBCIV);
    }

    private String encStr(String sPlainText, long lNewCBCIV) {
        int nStrLen = sPlainText.length();
        byte[] buf = new byte[(nStrLen << 1 & 0xFFFFFFF8) + 8];
        int nPos = 0;
        for (int nI = 0; nI < nStrLen; ++nI) {
            char cActChar = sPlainText.charAt(nI);
            buf[nPos++] = (byte)(cActChar >> 8 & 0xFF);
            buf[nPos++] = (byte)(cActChar & 0xFF);
        }
        byte bPadVal = (byte)(buf.length - (nStrLen << 1));
        while (nPos < buf.length) {
            buf[nPos++] = bPadVal;
        }
        this.m_bfish.setCBCIV(lNewCBCIV);
        this.m_bfish.encrypt(buf, 0, buf, 0, buf.length);
        byte[] newCBCIV = new byte[8];
        BinConverter.longToByteArray(lNewCBCIV, newCBCIV, 0);
        return String.valueOf(BinConverter.bytesToBinHex(newCBCIV, 0, 8)).concat(String.valueOf(BinConverter.bytesToBinHex(buf, 0, buf.length)));
    }

    public String decryptString(String sCipherText) {
        int nLen = sCipherText.length() >> 1 & 0xFFFFFFF8;
        if (nLen < 8) {
            return null;
        }
        byte[] cbciv = new byte[8];
        int nNumOfBytes = BinConverter.binHexToBytes(sCipherText, cbciv, 0, 0, 8);
        if (nNumOfBytes < 8) {
            return null;
        }
        this.m_bfish.setCBCIV(cbciv, 0);
        if ((nLen -= 8) == 0) {
            return "";
        }
        byte[] buf = new byte[nLen];
        nNumOfBytes = BinConverter.binHexToBytes(sCipherText, buf, 16, 0, nLen);
        if (nNumOfBytes < nLen) {
            return null;
        }
        this.m_bfish.decrypt(buf, 0, buf, 0, buf.length);
        int nPadByte = buf[buf.length - 1] & 0xFF;
        if (nPadByte > 8 || nPadByte < 0) {
            nPadByte = 0;
        }
        if ((nNumOfBytes -= nPadByte) < 0) {
            return "";
        }
        return BinConverter.byteArrayToUNCString(buf, 0, nNumOfBytes);
    }

    public void destroy() {
        this.m_bfish.cleanUp();
    }
}

