/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.allday.ui;

import com.lightdev.app.allday.ui.MonthBoxModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;

public class MonthBox
extends JTable {
    private GregorianCalendar calendar;
    private DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
    private int sundayColumn;
    private int today;
    private Point todayCell = new Point(0, 0);

    public MonthBox() {
        super(new MonthBoxModel());
        this.calendar = new GregorianCalendar();
        this.setDefaults();
        this.initComponent();
        this.addFocusListener(new MonthBoxFocusListener());
    }

    public MonthBox(GregorianCalendar calendar) {
        super(new MonthBoxModel());
        this.calendar = calendar;
        this.setDefaults();
        this.initComponent();
        this.addFocusListener(new MonthBoxFocusListener());
    }

    public MonthBox(MonthBoxModel model, GregorianCalendar calendar) {
        super(model);
        this.calendar = calendar;
        this.setDefaults();
        this.initComponent();
        this.addFocusListener(new MonthBoxFocusListener());
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.handleSelectionChange()) {
            super.valueChanged(e);
        }
    }

    public Point getRowCol(int day) {
        Object o = this.getValueAt(2, 1);
        if (o != null) {
            int col;
            int shiftedDay = day + 8 - Integer.valueOf(o.toString());
            int row = shiftedDay / 7;
            if (shiftedDay % 7 > 0) {
                ++row;
            }
            if ((col = (shiftedDay - shiftedDay / 7 * 7) % 8) > 7) {
                col -= 7;
            } else if (col == 0) {
                col = 7;
            }
            return new Point(row, col);
        }
        return new Point(0, 0);
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.handleSelectionChange()) {
            super.columnSelectionChanged(e);
        }
    }

    private boolean handleSelectionChange() {
        try {
            String text;
            Object obj;
            int col;
            int row = this.getSelectedRow();
            if (row > 0 && (col = this.getSelectedColumn()) > 0 && (obj = this.getValueAt(row, col)) != null && (text = obj.toString()).trim().length() > 0) {
                this.calendar.set(5, Integer.parseInt(text));
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private void setDefaults() {
        this.setBackground(Color.WHITE);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
        this.setRowSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
        this.sundayColumn = this.getColumnForDayOfWeek(((MonthBoxModel)this.getModel()).getSundayDay());
    }

    private void initComponent() {
        this.buildWeekDayHeader(this.calendar);
        this.fillDayNumbers(this.calendar);
    }

    private void buildWeekDayHeader(Calendar calendar) {
        String[] wkDayNames = this.dateFormatSymbols.getShortWeekdays();
        int wkDay = ((MonthBoxModel)this.getModel()).getFirstDayOfWeek();
        MonthBoxCellRenderer renderer = new MonthBoxCellRenderer();
        this.getColumnModel().getColumn(0).setCellRenderer(renderer);
        int col = 1;
        while (col < 8) {
            this.getColumnModel().getColumn(col).setCellRenderer(renderer);
            this.setValueAt(wkDayNames[wkDay], 0, col);
            if (++wkDay > 7) {
                wkDay = 1;
            }
            ++col;
        }
    }

    private void fillDayNumbers(Calendar calendar) {
        calendar.set(5, 1);
        int col = this.getColumnForDayOfWeek(calendar.get(7));
        int row = 1;
        int day = 1;
        int lastDay = calendar.getActualMaximum(5);
        this.fillWeekNumber(row, day);
        int i = 1;
        while (i < col) {
            this.setValueAt("", row, i);
            ++i;
        }
        while (day <= lastDay) {
            this.setValueAt(Integer.toString(day++), row, col);
            if (++col <= 7) continue;
            col = 1;
            ++row;
            if (day > lastDay) continue;
            this.fillWeekNumber(row, day);
        }
        while (row < 7) {
            this.setValueAt("", row, col);
            if (++col <= 7) continue;
            col = 1;
            if (++row >= 7) continue;
            this.setValueAt("", row, 0);
        }
    }

    private void fillWeekNumber(int row, int day) {
        this.calendar.set(5, day);
        this.setValueAt(Integer.toString(this.calendar.get(3)), row, 0);
    }

    private int getColumnForDayOfWeek(int dayOfWeek) {
        int col = dayOfWeek - (((MonthBoxModel)this.getModel()).getFirstDayOfWeek() - 1);
        if (col <= 0) {
            col += 7;
        }
        return col;
    }

    public Color getMonthBoxBackground() {
        return this.getBackground();
    }

    public void setCalendar(GregorianCalendar calendar) {
        this.calendar = calendar;
        this.fillDayNumbers(calendar);
    }

    public void setSelectionVisible(boolean showSelection) {
        this.setRowSelectionAllowed(showSelection);
        this.setCellSelectionEnabled(showSelection);
    }

    public boolean isSelectionVisible() {
        return this.getRowSelectionAllowed() && this.getCellSelectionEnabled();
    }

    public void setToday(int today) {
        this.today = today;
        this.todayCell = this.getRowCol(today);
        if (today > 0) {
            this.setBackground(new Color(255, 255, 204));
        } else {
            this.setBackground(Color.WHITE);
        }
    }

    private class MonthBoxCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private MonthBoxCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int colIndex) {
            if (rowIndex == 0) {
                this.setForeground(this.getCellForegroundColor(isSelected, ((MonthBoxModel)table.getModel()).getHeaderColor(), rowIndex, colIndex));
                this.setFont(new Font("verdana", 1, 12));
                this.setBackground(this.getCellBackgroundColor(isSelected, MonthBox.this.getMonthBoxBackground(), rowIndex, colIndex));
            } else if (colIndex == 0) {
                this.setFont(new Font("verdana", 0, 12));
                this.setForeground(this.getCellForegroundColor(isSelected, Color.GRAY, rowIndex, colIndex));
                this.setBackground(this.getCellBackgroundColor(isSelected, MonthBox.this.getMonthBoxBackground(), rowIndex, colIndex));
            } else {
                if (rowIndex == ((MonthBox)MonthBox.this).todayCell.x && colIndex == ((MonthBox)MonthBox.this).todayCell.y) {
                    this.setFont(new Font("verdana", 1, 12));
                    this.setBackground(this.getCellBackgroundColor(isSelected, Color.WHITE, rowIndex, colIndex));
                } else {
                    this.setFont(new Font("verdana", 0, 12));
                    this.setBackground(this.getCellBackgroundColor(isSelected, MonthBox.this.getMonthBoxBackground(), rowIndex, colIndex));
                }
                if (colIndex == MonthBox.this.sundayColumn) {
                    this.setForeground(this.getCellForegroundColor(isSelected, ((MonthBoxModel)table.getModel()).getSundayColor(), rowIndex, colIndex));
                } else {
                    this.setForeground(this.getCellForegroundColor(isSelected, Color.BLACK, rowIndex, colIndex));
                }
            }
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            if (value != null) {
                this.setText(value.toString());
            } else {
                this.setText("");
            }
            return this;
        }

        private Color getCellForegroundColor(boolean isSelected, Color color, int row, int col) {
            if (isSelected && row > 0 && col > 0) {
                return MonthBox.this.getSelectionForeground();
            }
            return color;
        }

        private Color getCellBackgroundColor(boolean isSelected, Color color, int row, int col) {
            if (isSelected && row > 0 && col > 0) {
                return MonthBox.this.getSelectionBackground();
            }
            return color;
        }
    }

    private class MonthBoxFocusListener
    implements FocusListener {
        private MonthBoxFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            MonthBox.this.setSelectionVisible(true);
        }

        public void focusLost(FocusEvent e) {
            if (e.getOppositeComponent() instanceof MonthBox) {
                MonthBox.this.setSelectionVisible(false);
            }
        }
    }
}

