/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model;

import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.model.CategoryModel;
import net.sf.borg.model.LinkModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.SearchCriteria;
import net.sf.borg.model.Searchable;
import net.sf.borg.model.db.DBHelper;
import net.sf.borg.model.db.EntityDB;
import net.sf.borg.model.entity.Address;
import net.sf.borg.model.entity.Link;
import net.sf.borg.model.undo.AddressUndoItem;
import net.sf.borg.model.undo.UndoLog;

public class AddressModel
extends Model
implements Searchable<Address> {
    private static AddressModel self_ = new AddressModel();
    private HashMap<Integer, LinkedList<Address>> bdmap_ = new HashMap();
    private EntityDB<Address> db_ = DBHelper.getFactory().createAddressDB();

    public static AddressModel getReference() {
        return self_;
    }

    private static int birthdayKey(Date d) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(d);
        return g.get(2) * 100 + g.get(5);
    }

    private AddressModel() {
        this.load_map();
    }

    public void delete(Address addr) {
        this.delete(addr, false);
    }

    public void delete(Address addr, boolean undo) {
        try {
            Address orig_addr = this.getAddress(addr.getKey());
            LinkModel.getReference().deleteLinksFromEntity(addr);
            LinkModel.getReference().deleteLinksToEntity(addr);
            this.db_.delete(addr.getKey());
            if (!undo) {
                UndoLog.getReference().addItem(AddressUndoItem.recordDelete(orig_addr));
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        this.refresh();
    }

    @Override
    public void export(Writer fw) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Marshaller m = jc.createMarshaller();
        XmlContainer container = new XmlContainer();
        container.Address = this.getAddresses();
        m.marshal((Object)container, fw);
    }

    public Address getAddress(int num) throws Exception {
        return this.db_.readObj(num);
    }

    public Collection<Address> getAddresses() throws Exception {
        Collection<Address> addrs = this.db_.readAll();
        return addrs;
    }

    public Collection<Address> getAddresses(Date d) {
        int bdkey = AddressModel.birthdayKey(d);
        return this.bdmap_.get(new Integer(bdkey));
    }

    @Deprecated
    public EntityDB<Address> getDB() {
        return this.db_;
    }

    @Override
    public void importXml(InputStream is) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Unmarshaller u = jc.createUnmarshaller();
        XmlContainer container = (XmlContainer)u.unmarshal(is);
        if (container.Address == null) {
            return;
        }
        int nextkey = this.db_.nextkey();
        boolean use_keys = nextkey == 1;
        for (Address addr : container.Address) {
            if (!use_keys) {
                addr.setKey(nextkey++);
            }
            this.db_.addObj(addr);
        }
        this.refresh();
    }

    private void load_map() {
        this.bdmap_.clear();
        try {
            Collection<Address> addrs = this.getAddresses();
            for (Address addr : addrs) {
                Date bd = addr.getBirthday();
                if (bd == null) continue;
                int bdkey = AddressModel.birthdayKey(bd);
                LinkedList<Address> o = this.bdmap_.get(new Integer(bdkey));
                if (o == null) {
                    o = new LinkedList();
                    this.bdmap_.put(new Integer(bdkey), o);
                }
                o.add(addr);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            return;
        }
    }

    public Address newAddress() {
        return this.db_.newObj();
    }

    public void refresh() {
        this.load_map();
        this.refreshListeners();
    }

    public void saveAddress(Address addr) {
        this.saveAddress(addr, false);
    }

    public void saveAddress(Address addr, boolean undo) {
        int num = addr.getKey();
        try {
            Address orig_addr = this.getAddress(addr.getKey());
            if (num == -1 || orig_addr == null) {
                int newkey = this.db_.nextkey();
                if (undo && num != -1 && orig_addr == null) {
                    newkey = num;
                }
                addr.setKey(newkey);
                this.db_.addObj(addr);
                if (!undo) {
                    UndoLog.getReference().addItem(AddressUndoItem.recordAdd(addr));
                }
            } else {
                this.db_.updateObj(addr);
                if (!undo) {
                    UndoLog.getReference().addItem(AddressUndoItem.recordUpdate(orig_addr));
                }
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        this.refresh();
    }

    @Override
    public void sync() {
        this.db_.sync();
        this.refresh();
    }

    @Override
    public Collection<Address> search(SearchCriteria criteria) {
        ArrayList<Address> res = new ArrayList<Address>();
        try {
            if (!criteria.getCategory().equals("") && !criteria.getCategory().equals(CategoryModel.UNCATEGORIZED)) {
                return res;
            }
            Collection<Address> addresses = this.getAddresses();
            for (Address addr : addresses) {
                String addrString = addr.getFirstName() + " " + addr.getLastName() + " " + addr.getStreetAddress() + " " + addr.getWorkStreetAddress() + " " + addr.getCompany() + " " + addr.getCity() + " " + addr.getCountry() + " " + addr.getWorkCity() + " " + addr.getWorkCountry() + " " + addr.getEmail() + " " + addr.getState() + " " + addr.getWorkState() + " " + addr.getNickname() + " " + addr.getCellPhone();
                if (!criteria.search(addrString)) continue;
                if (criteria.hasLinks()) {
                    LinkModel lm = LinkModel.getReference();
                    try {
                        Collection<Link> lnks = lm.getLinks(addr);
                        if (lnks.isEmpty()) {
                            continue;
                        }
                    }
                    catch (Exception e) {
                        Errmsg.getErrorHandler().errmsg(e);
                    }
                }
                res.add(addr);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        return res;
    }

    @Override
    public String getExportName() {
        return "ADDRESSES";
    }

    @Override
    public String getInfo() throws Exception {
        return Resource.getResourceString((String)"addresses") + ": " + this.getAddresses().size();
    }

    @XmlRootElement(name="ADDRESSES")
    private static class XmlContainer {
        public Collection<Address> Address;

        private XmlContainer() {
        }
    }
}

