/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.common.SendJavaMail;
import net.sf.borg.model.AddressModel;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.CategoryModel;
import net.sf.borg.model.CheckListModel;
import net.sf.borg.model.EmailReminder;
import net.sf.borg.model.LinkModel;
import net.sf.borg.model.MemoModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.TaskModel;

public class ExportImport {
    private static final Map<String, String> legacyFileMap = new HashMap<String, String>();

    public static void exportToZip(String dir, boolean backup_email) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String uniq = sdf.format(new Date());
        String backupFilename = dir + "/borg" + uniq + ".zip";
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(backupFilename));
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)out, "UTF8");
        AppointmentModel.getReference();
        MemoModel.getReference();
        CheckListModel.getReference();
        AddressModel.getReference();
        TaskModel.getReference();
        LinkModel.getReference();
        for (Model model : Model.getExistingModels()) {
            if (model instanceof LinkModel || model.getExportName() == null) continue;
            out.putNextEntry(new ZipEntry(model.getExportName() + ".xml"));
            model.export(fw);
            ((Writer)fw).flush();
            out.closeEntry();
        }
        out.putNextEntry(new ZipEntry(LinkModel.getReference().getExportName() + ".xml"));
        LinkModel.getReference().export(fw);
        ((Writer)fw).flush();
        out.closeEntry();
        out.close();
        if (backup_email) {
            if (!Prefs.getBoolPref((PrefName)PrefName.EMAILENABLED)) {
                return;
            }
            String host = Prefs.getPref((PrefName)PrefName.EMAILSERVER);
            String addr = Prefs.getPref((PrefName)PrefName.EMAILADDR);
            String from = Prefs.getPref((PrefName)PrefName.EMAILFROM);
            StringTokenizer stk = new StringTokenizer(addr, ",;");
            if (stk.hasMoreTokens()) {
                addr = stk.nextToken();
            }
            String f = from == null || from.isEmpty() ? addr : from;
            SendJavaMail.sendMailWithAttachments((String)host, (String)Resource.getResourceString((String)"borg_backup"), (String)Resource.getResourceString((String)"borg_backup"), (String)f, (String)addr, (String)Prefs.getPref((PrefName)PrefName.EMAILUSER), (String)EmailReminder.gep(), (String[])new String[]{backupFilename});
        }
    }

    public static void importFromXmlFile(Model model, InputStream is) throws Exception {
        model.importXml(is);
        CategoryModel.getReference().sync();
        CategoryModel.getReference().showAll();
    }

    public static Model getImportModelForXML(BufferedReader in) throws IOException {
        for (int i = 0; i < 10; ++i) {
            String line = in.readLine();
            if (line == null) continue;
            for (Model model : Model.getExistingModels()) {
                if (model.getExportName() == null || !line.contains(model.getExportName())) continue;
                in.close();
                return model;
            }
        }
        in.close();
        return null;
    }

    public static void importFromZip(String zipFileName) throws Exception {
        UncloseableZipInputStream in = new UncloseableZipInputStream(new FileInputStream(zipFileName));
        LinkModel.getReference();
        ZipEntry entry = in.getNextEntry();
        while (entry != null) {
            String legacyFileName = legacyFileMap.get(entry.getName());
            AppointmentModel.getReference();
            MemoModel.getReference();
            CheckListModel.getReference();
            AddressModel.getReference();
            TaskModel.getReference();
            LinkModel.getReference();
            boolean import_done = false;
            for (Model model : Model.getExistingModels()) {
                if (!entry.getName().equals(model.getExportName() + ".xml") && (legacyFileName == null || !legacyFileName.equals(model.getExportName() + ".xml"))) continue;
                ExportImport.importFromXmlFile(model, in);
                import_done = true;
                break;
            }
            if (!import_done) {
                throw new Exception("Unknown file in ZIP - " + entry.getName() + " ...skipping");
            }
            entry = in.getNextEntry();
        }
        in.myClose();
    }

    static {
        legacyFileMap.put("borg.xml", "APPTS.xml");
        legacyFileMap.put("task.xml", "TASKS.xml");
        legacyFileMap.put("addr.xml", "ADDRESSES.xml");
        legacyFileMap.put("memo.xml", "MEMOS.xml");
        legacyFileMap.put("link.xml", "LINKS.xml");
        legacyFileMap.put("checklist.xml", "CHECKLISTS.xml");
    }

    private static class UncloseableZipInputStream
    extends ZipInputStream {
        public UncloseableZipInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }

        public void myClose() throws IOException {
            super.close();
        }
    }
}

