/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.Model;
import net.sf.borg.model.db.DBHelper;
import net.sf.borg.model.db.EntityDB;
import net.sf.borg.model.db.LinkDB;
import net.sf.borg.model.entity.Address;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.CheckList;
import net.sf.borg.model.entity.KeyedEntity;
import net.sf.borg.model.entity.Link;
import net.sf.borg.model.entity.Memo;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Task;

public class LinkModel
extends Model {
    private static LinkModel self_ = new LinkModel();
    private static HashMap<Class<?>, LinkType> typemap = new HashMap();
    private EntityDB<Link> db_ = DBHelper.getFactory().createLinkDB();

    public static String attachmentFolder() {
        String dbtype = Prefs.getPref((PrefName)PrefName.DBTYPE);
        if (dbtype.equals("hsqldb")) {
            String path = Prefs.getPref((PrefName)PrefName.HSQLDBDIR) + "/attachments";
            File f = new File(path);
            if (!f.exists() && !f.mkdir()) {
                Errmsg.getErrorHandler().notice(Resource.getResourceString((String)"att_folder_err") + path);
                return null;
            }
            return path;
        }
        if (dbtype.equals("h2")) {
            String path = Prefs.getPref((PrefName)PrefName.H2DIR) + "/attachments";
            File f = new File(path);
            if (!f.exists() && !f.mkdir()) {
                Errmsg.getErrorHandler().notice(Resource.getResourceString((String)"att_folder_err") + path);
                return null;
            }
            return path;
        }
        return null;
    }

    public static LinkModel getReference() {
        return self_;
    }

    public void addLink(KeyedEntity<?> owner, String pathIn, LinkType linkType) throws Exception {
        Link at2way;
        String path = pathIn;
        if (owner == null) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString((String)"att_owner_null"));
            return;
        }
        if (linkType == LinkType.ATTACHMENT) {
            File newfile;
            String atfolder = LinkModel.attachmentFolder();
            if (atfolder == null) {
                throw new Exception("attachments not supported");
            }
            File orig = new File(path);
            String fname = orig.getName();
            String newpath = atfolder + "/" + fname;
            int i = 1;
            while ((newfile = new File(newpath)).exists()) {
                fname = Integer.toString(i) + orig.getName();
                newpath = atfolder + "/" + fname;
                ++i;
            }
            LinkModel.copyFile(path, newpath);
            path = fname;
        }
        Link at = this.newLink();
        at.setKey(-1);
        at.setOwnerKey(new Integer(owner.getKey()));
        LinkType type = typemap.get(owner.getClass());
        if (type == null) {
            throw new Exception("illegal link owner type");
        }
        at.setOwnerType(type.toString());
        at.setPath(path);
        at.setLinkType(linkType.toString());
        this.saveLink(at);
        if (linkType == LinkType.APPOINTMENT || linkType == LinkType.PROJECT || linkType == LinkType.TASK) {
            at2way = this.newLink();
            at2way.setKey(-1);
            at2way.setOwnerKey(new Integer(at.getPath()));
            at2way.setOwnerType(at.getLinkType());
            at2way.setPath(at.getOwnerKey().toString());
            at2way.setLinkType(at.getOwnerType());
            this.saveLink(at2way);
        } else if (!(linkType != LinkType.ADDRESS || owner instanceof Address && at.getOwnerKey().toString().equals(at.getPath()))) {
            at2way = this.newLink();
            at2way.setKey(-1);
            at2way.setOwnerKey(new Integer(at.getPath()));
            at2way.setOwnerType(at.getLinkType());
            at2way.setPath(at.getOwnerKey().toString());
            at2way.setLinkType(at.getOwnerType());
            this.saveLink(at2way);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(String fromFile, String toFile) throws Exception {
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(fromFile);
            to = new FileOutputStream(toFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException e) {}
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void delete(int key) throws Exception {
        Link l = this.getLink(key);
        this.delete(l);
    }

    public void delete(Link l) throws Exception {
        if (l.getLinkType().equals(LinkType.ATTACHMENT.toString())) {
            File f = new File(LinkModel.attachmentFolder() + "/" + l.getPath());
            f.delete();
        }
        this.db_.delete(l.getKey());
        this.refresh();
    }

    public void deleteLinksFromEntity(KeyedEntity<?> owner) throws Exception {
        Collection<Link> atts = this.getLinks(owner);
        for (Link at : atts) {
            this.delete(at);
        }
    }

    public void deleteLinksToEntity(Object target) throws Exception {
        if (target == null) {
            return;
        }
        LinkType type = typemap.get(target.getClass());
        if (type == null) {
            return;
        }
        Collection<Link> links = this.getLinks();
        for (Link link : links) {
            if (!link.getLinkType().equals(type.toString())) continue;
            if (type == LinkType.MEMO && ((Memo)target).getMemoName().equals(link.getPath()) || type == LinkType.CHECKLIST && ((CheckList)target).getCheckListName().equals(link.getPath())) {
                this.delete(link);
                continue;
            }
            if (!(target instanceof KeyedEntity)) continue;
            int key = ((KeyedEntity)target).getKey();
            if (!link.getPath().equals(Integer.toString(key))) continue;
            this.delete(link);
        }
    }

    @Override
    public void export(Writer fw) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Marshaller m = jc.createMarshaller();
        XmlContainer container = new XmlContainer();
        container.Link = this.getLinks();
        m.marshal((Object)container, fw);
    }

    public EntityDB<Link> getDB() {
        return this.db_;
    }

    public Link getLink(int key) throws Exception {
        return this.db_.readObj(key);
    }

    public Collection<Link> getLinks() throws Exception {
        return this.db_.readAll();
    }

    public Collection<Link> getLinks(KeyedEntity<?> ownerbean) throws Exception {
        LinkDB adb = (LinkDB)this.db_;
        if (ownerbean == null) {
            return new ArrayList<Link>();
        }
        LinkType type = typemap.get(ownerbean.getClass());
        if (type == null) {
            return new ArrayList<Link>();
        }
        return adb.getLinks(ownerbean.getKey(), type.toString());
    }

    @Override
    public void importXml(InputStream is) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Unmarshaller u = jc.createUnmarshaller();
        XmlContainer container = (XmlContainer)u.unmarshal(is);
        if (container.Link == null) {
            return;
        }
        int nextkey = this.db_.nextkey();
        boolean use_keys = nextkey == 1;
        for (Link link : container.Link) {
            if (!use_keys) {
                link.setKey(nextkey++);
            }
            this.db_.addObj(link);
        }
        this.refresh();
    }

    public void moveLinks(KeyedEntity<?> oldOwner, KeyedEntity<?> newOwner) throws Exception {
        Collection<Link> atts = this.getLinks(oldOwner);
        for (Link at : atts) {
            at.setOwnerKey(new Integer(newOwner.getKey()));
            LinkType type = typemap.get(newOwner.getClass());
            if (type == null) {
                throw new Exception("illegal link owner type");
            }
            at.setOwnerType(type.toString());
            this.db_.updateObj(at);
        }
    }

    public Link newLink() {
        return this.db_.newObj();
    }

    private LinkModel() {
    }

    public void refresh() {
        this.refreshListeners();
    }

    public void saveLink(Link link) throws Exception {
        int num = link.getKey();
        if (num == -1) {
            int newkey = this.db_.nextkey();
            link.setKey(newkey);
            this.db_.addObj(link);
        } else {
            this.db_.updateObj(link);
        }
        this.refresh();
    }

    @Override
    public String getExportName() {
        return "LINKS";
    }

    @Override
    public String getInfo() throws Exception {
        return Resource.getResourceString((String)"links") + ": " + this.getLinks().size();
    }

    static {
        typemap.put(Appointment.class, LinkType.APPOINTMENT);
        typemap.put(Memo.class, LinkType.MEMO);
        typemap.put(Task.class, LinkType.TASK);
        typemap.put(Address.class, LinkType.ADDRESS);
        typemap.put(Project.class, LinkType.PROJECT);
        typemap.put(CheckList.class, LinkType.CHECKLIST);
    }

    public static enum LinkType {
        FILELINK("file"),
        ATTACHMENT("attachment"),
        URL("url"),
        APPOINTMENT("appointment"),
        MEMO("memo"),
        PROJECT("project"),
        TASK("task"),
        ADDRESS("address"),
        CHECKLIST("net.sf.borg.ui.checklist");

        private final String value;

        private LinkType(String n2) {
            this.value = n2;
        }

        public String toString() {
            return this.value;
        }
    }

    @XmlRootElement(name="LINKS")
    private static class XmlContainer {
        public Collection<Link> Link;

        private XmlContainer() {
        }
    }
}

