/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model;

import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public abstract class Model {
    private static List<Model> modelList = new ArrayList<Model>();
    private ArrayList<Listener> listeners;

    public static List<Model> getExistingModels() {
        return modelList;
    }

    public static void syncModels() {
        for (Model m : modelList) {
            m.sync();
        }
    }

    protected void sync() {
    }

    public Model() {
        modelList.add(this);
        this.listeners = new ArrayList();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    protected void refreshListeners() {
        ChangeEvent ev = new ChangeEvent(null, ChangeEvent.ChangeAction.CHANGE);
        ev.model = this;
        this.refreshListeners(ev);
    }

    protected void refreshListeners(ChangeEvent event) {
        event.model = this;
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener v = this.listeners.get(i);
            v.update(event);
        }
    }

    public void remove() {
        this.removeListeners();
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    protected void removeListeners() {
        this.listeners.clear();
    }

    public abstract void export(Writer var1) throws Exception;

    public abstract void importXml(InputStream var1) throws Exception;

    public abstract String getExportName();

    public abstract String getInfo() throws Exception;

    public static interface Listener {
        public void update(ChangeEvent var1);
    }

    public static class ChangeEvent {
        private ChangeAction action;
        private final Object object;
        private Model model;

        public ChangeEvent(Object object, ChangeAction action) {
            this.object = object;
            this.action = action;
        }

        public ChangeAction getAction() {
            return this.action;
        }

        public Object getObject() {
            return this.object;
        }

        public Model getModel() {
            return this.model;
        }

        public void setAction(ChangeAction action) {
            this.action = action;
        }

        public void setModel(Model model) {
            this.model = model;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChangeEvent)) {
                return false;
            }
            ChangeEvent other = (ChangeEvent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ChangeAction this$action = this.getAction();
            ChangeAction other$action = other.getAction();
            if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
                return false;
            }
            Object this$object = this.getObject();
            Object other$object = other.getObject();
            if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
                return false;
            }
            Model this$model = this.getModel();
            Model other$model = other.getModel();
            return !(this$model == null ? other$model != null : !this$model.equals(other$model));
        }

        public boolean canEqual(Object other) {
            return other instanceof ChangeEvent;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            ChangeAction $action = this.getAction();
            result = result * 31 + ($action == null ? 0 : ((Object)((Object)$action)).hashCode());
            Object $object = this.getObject();
            result = result * 31 + ($object == null ? 0 : $object.hashCode());
            Model $model = this.getModel();
            result = result * 31 + ($model == null ? 0 : $model.hashCode());
            return result;
        }

        public String toString() {
            return "Model.ChangeEvent(action=" + (Object)((Object)this.getAction()) + ", object=" + this.getObject() + ", model=" + this.getModel() + ")";
        }

        public static enum ChangeAction {
            ADD,
            CHANGE,
            DELETE;

        }
    }
}

