/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import net.sf.borg.common.Resource;
import net.sf.borg.model.entity.Appointment;

public class Repeat {
    public static final String TTH = "tth";
    public static final String MWF = "mwf";
    public static final String WEEKENDS = "weekends";
    public static final String WEEKDAYS = "weekdays";
    public static final String YEARLY = "yearly";
    public static final String MONTHLY_DAY = "monthly_day";
    public static final String MONTHLY = "monthly";
    public static final String BIWEEKLY = "biweekly";
    public static final String WEEKLY = "weekly";
    public static final String DAILY = "daily";
    public static final String NDAYS = "ndays";
    public static final String NWEEKS = "nweeks";
    public static final String NMONTHS = "nmonths";
    public static final String NYEARS = "nyears";
    public static final String DAYLIST = "dlist";
    public static final String ONCE = "once";
    public static final int MAGIC_RPT_FOREVER_VALUE = 9999;
    private Calendar start_;
    private Calendar cal;
    private Calendar current_;
    private final String frequency_;
    private String freq_;
    private int field;
    private int dayOfWeekMonth;
    private int dayOfWeek;
    private int incr;
    private static String[] freqs = new String[]{"once", "daily", "weekly", "biweekly", "monthly", "monthly_day", "yearly", "weekdays", "weekends", "mwf", "tth", "ndays", "nweeks", "nmonths", "nyears", "dlist"};

    public static boolean isCompatible(Calendar date, String freq, Collection<Integer> daylist) {
        String f = Repeat.freqToEnglish(freq);
        int day = date.get(7);
        if (f.equals(WEEKDAYS) && (day == 7 || day == 1)) {
            return false;
        }
        if (f.equals(WEEKENDS) && day != 7 && day != 1) {
            return false;
        }
        if (f.equals(MWF) && day != 2 && day != 4 && day != 6) {
            return false;
        }
        if (f.equals(TTH) && day != 3 && day != 5) {
            return false;
        }
        return !f.equals(DAYLIST) || daylist.contains(new Integer(day));
    }

    public static String getFreqString(int i) {
        if (i < 0 || i >= freqs.length) {
            return null;
        }
        return Resource.getResourceString((String)freqs[i]);
    }

    public static String getFreqString(String fr) {
        return Resource.getResourceString((String)(fr == null ? ONCE : fr));
    }

    public static String freqToEnglish(String fr) {
        for (int i = 0; i < freqs.length; ++i) {
            if (!fr.equals(Resource.getResourceString((String)freqs[i]))) continue;
            return freqs[i];
        }
        return ONCE;
    }

    public static String freqString(String uistring, Integer ndays, boolean rptnum, Collection<Integer> daylist) {
        String f = Repeat.freqToEnglish(uistring);
        if (f.equals(NDAYS) || f.equals(NWEEKS) || f.equals(NMONTHS) || f.equals(NYEARS)) {
            f = f + "," + ndays;
        }
        if (f.equals(DAYLIST)) {
            f = f + ",";
            if (daylist != null) {
                if (daylist.contains(new Integer(1))) {
                    f = f + "1";
                }
                if (daylist.contains(new Integer(2))) {
                    f = f + "2";
                }
                if (daylist.contains(new Integer(3))) {
                    f = f + "3";
                }
                if (daylist.contains(new Integer(4))) {
                    f = f + "4";
                }
                if (daylist.contains(new Integer(5))) {
                    f = f + "5";
                }
                if (daylist.contains(new Integer(6))) {
                    f = f + "6";
                }
                if (daylist.contains(new Integer(7))) {
                    f = f + "7";
                }
            }
        }
        if (rptnum) {
            f = f + ",Y";
        }
        return f;
    }

    public static String getFreq(String f) {
        if (f == null) {
            return null;
        }
        int i = f.indexOf(44);
        if (i == -1) {
            return f;
        }
        return f.substring(0, i);
    }

    public static boolean getRptNum(String f) {
        if (f == null) {
            return false;
        }
        return f.endsWith(",Y");
    }

    public static Collection<Integer> getDaylist(String f) {
        ArrayList<Integer> daylist = new ArrayList<Integer>();
        if (f == null || !f.startsWith(DAYLIST)) {
            return daylist;
        }
        int i2 = f.indexOf(44, DAYLIST.length() + 1);
        String list = null;
        list = i2 != -1 ? f.substring(DAYLIST.length() + 1, i2) : f.substring(DAYLIST.length() + 1);
        if (list.indexOf("1") != -1) {
            daylist.add(new Integer(1));
        }
        if (list.indexOf("2") != -1) {
            daylist.add(new Integer(2));
        }
        if (list.indexOf("3") != -1) {
            daylist.add(new Integer(3));
        }
        if (list.indexOf("4") != -1) {
            daylist.add(new Integer(4));
        }
        if (list.indexOf("5") != -1) {
            daylist.add(new Integer(5));
        }
        if (list.indexOf("6") != -1) {
            daylist.add(new Integer(6));
        }
        if (list.indexOf("7") != -1) {
            daylist.add(new Integer(7));
        }
        return daylist;
    }

    public static int getNValue(String f) {
        if (f == null) {
            return 0;
        }
        String freq = Repeat.getFreq(f);
        if (!(freq.equals(NDAYS) || freq.equals(NWEEKS) || freq.equals(NMONTHS) || freq.equals(NYEARS))) {
            return 0;
        }
        int i2 = f.indexOf(44, freq.length() + 1);
        if (i2 != -1) {
            return Integer.parseInt(f.substring(freq.length() + 1, i2));
        }
        return Integer.parseInt(f.substring(freq.length() + 1));
    }

    public Repeat(Calendar start, String frequency) {
        this.start_ = start;
        this.frequency_ = frequency;
        this.cal = new GregorianCalendar(0, 0, 0);
        this.cal.setTime(start.getTime());
        this.current_ = this.cal;
        this.incr = 1;
        this.field = 5;
        this.dayOfWeek = 0;
        this.dayOfWeekMonth = 0;
        if (!this.isRepeating()) {
            return;
        }
        this.freq_ = Repeat.getFreq(frequency);
        if (this.freq_.equals(WEEKLY)) {
            this.incr = 7;
        } else if (this.freq_.equals(BIWEEKLY)) {
            this.incr = 14;
        } else if (this.freq_.equals(MONTHLY)) {
            this.field = 2;
        } else if (this.freq_.equals(MONTHLY_DAY)) {
            this.incr = 0;
            this.dayOfWeek = start.get(7);
            this.dayOfWeekMonth = start.get(8);
        } else if (this.freq_.equals(YEARLY)) {
            this.field = 2;
            this.incr = 12;
        } else if (this.freq_.equals(MWF)) {
            this.incr = 0;
        } else if (this.freq_.equals(TTH)) {
            this.incr = 0;
        } else if (this.freq_.equals(NDAYS)) {
            this.incr = Repeat.getNValue(this.frequency_);
        } else if (this.freq_.equals(NWEEKS)) {
            this.incr = 7 * Repeat.getNValue(this.frequency_);
        } else if (this.freq_.equals(NMONTHS)) {
            this.incr = Repeat.getNValue(this.frequency_);
            this.field = 2;
        } else if (this.freq_.equals(NYEARS)) {
            this.incr = Repeat.getNValue(this.frequency_) * 12;
            this.field = 2;
        } else if (this.freq_.equals(DAYLIST)) {
            this.incr = 0;
        }
    }

    public final boolean isRepeating() {
        String f = Repeat.getFreq(this.frequency_);
        return f != null && !f.equals(ONCE);
    }

    public static boolean isRepeating(Appointment ap) {
        String f = Repeat.getFreq(ap.getFrequency());
        return f != null && !f.equals(ONCE);
    }

    public final Calendar current() {
        return this.current_;
    }

    public static final int calculateRepeatNumber(Calendar current, Appointment appt) {
        GregorianCalendar start;
        Calendar c = start = new GregorianCalendar();
        start.setTime(appt.getDate());
        Repeat r = new Repeat(start, appt.getFrequency());
        int i = 1;
        while (c.get(1) != current.get(1) || c.get(6) != current.get(6)) {
            if (c.after(current)) {
                return 0;
            }
            c = r.next();
            if (c == null) {
                return 0;
            }
            ++i;
        }
        return i;
    }

    public final Calendar next() {
        Collection<Integer> daylist;
        if (!this.isRepeating()) {
            this.current_ = null;
            return this.current_;
        }
        this.current_ = this.cal;
        if (this.incr != 0) {
            this.cal.add(this.field, this.incr);
        }
        if (this.freq_.equals(WEEKDAYS)) {
            int dow = this.cal.get(7);
            if (dow == 7) {
                this.cal.add(5, 2);
            } else if (dow == 1) {
                this.cal.add(5, 1);
            }
        } else if (this.freq_.equals(WEEKENDS)) {
            int dow = this.cal.get(7);
            if (dow == 2) {
                this.cal.add(5, 5);
            } else if (dow == 3) {
                this.cal.add(5, 4);
            } else if (dow == 4) {
                this.cal.add(5, 3);
            } else if (dow == 5) {
                this.cal.add(5, 2);
            } else if (dow == 6) {
                this.cal.add(5, 1);
            }
        } else if (this.freq_.equals(MWF)) {
            int dow = this.cal.get(7);
            if (dow == 6) {
                this.cal.add(5, 3);
            } else {
                this.cal.add(5, 2);
            }
        } else if (this.freq_.equals(TTH)) {
            int dow = this.cal.get(7);
            if (dow == 5) {
                this.cal.add(5, 5);
            } else {
                this.cal.add(5, 2);
            }
        } else if (this.freq_.equals(MONTHLY_DAY)) {
            int dowm;
            do {
                this.cal.add(2, 1);
                this.cal.set(7, this.dayOfWeek);
                this.cal.set(8, this.dayOfWeekMonth);
            } while ((dowm = this.cal.get(8)) != this.dayOfWeekMonth);
        } else if (this.freq_.equals(DAYLIST) && (daylist = Repeat.getDaylist(this.frequency_)) != null && !daylist.isEmpty()) {
            int dow;
            do {
                this.cal.add(5, 1);
            } while (!daylist.contains(new Integer(dow = this.cal.get(7))));
        }
        int startDate = this.start_.get(5);
        int maxDate = this.cal.getActualMaximum(5);
        if (this.field == 2) {
            if (startDate <= maxDate) {
                this.cal.set(5, startDate);
            } else {
                this.cal.set(5, maxDate);
            }
        }
        return this.current_;
    }

    public static Date calculateLastRepeat(Appointment appt) {
        if (!Repeat.isRepeating(appt)) {
            return appt.getDate();
        }
        if (appt.getTimes() == 9999) {
            return null;
        }
        if (appt.getRepeatUntil() != null) {
            return appt.getRepeatUntil();
        }
        GregorianCalendar start = new GregorianCalendar();
        Calendar c = start;
        start.setTime(appt.getDate());
        Repeat r = new Repeat(start, appt.getFrequency());
        for (int i = 1; i < appt.getTimes(); ++i) {
            c = r.next();
        }
        if (c == null) {
            return null;
        }
        return c.getTime();
    }

    public static int calculateTimes(Appointment appt) {
        if (!Repeat.isRepeating(appt)) {
            return 1;
        }
        if (appt.getRepeatUntil() == null) {
            if (appt.getTimes() != null) {
                return appt.getTimes();
            }
            return 1;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(appt.getDate());
        Repeat repeat = new Repeat(cal, appt.getFrequency());
        GregorianCalendar until = new GregorianCalendar();
        until.setTime(appt.getRepeatUntil());
        until.set(11, 23);
        until.set(12, 59);
        int times = 0;
        while (repeat.current() != null && !repeat.current().after(until)) {
            ++times;
            repeat.next();
        }
        return times;
    }
}

