/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.util.Date;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.common.Warning;
import net.sf.borg.model.db.AppointmentDB;
import net.sf.borg.model.db.CheckListDB;
import net.sf.borg.model.db.EntityDB;
import net.sf.borg.model.db.LinkDB;
import net.sf.borg.model.db.MemoDB;
import net.sf.borg.model.db.OptionDB;
import net.sf.borg.model.db.TaskDB;
import net.sf.borg.model.entity.Address;

public class DBHelper {
    private static Factory factory;
    private static Controller controller;

    public static void checkTimestamp() throws Exception {
        long dblong;
        long preflong;
        String preftime;
        OptionDB odb = DBHelper.getFactory().createOptionDB();
        String option = odb.getOption(PrefName.SHUTDOWNTIME.getName());
        if (option != null && !option.equals(PrefName.SHUTDOWNTIME.getDefault()) && !(preftime = Prefs.getPref((PrefName)PrefName.SHUTDOWNTIME)).equals(PrefName.SHUTDOWNTIME.getDefault()) && (preflong = Long.parseLong(preftime)) > (dblong = Long.parseLong(option))) {
            Date pdate = new Date(preflong);
            Date dbdate = new Date(dblong);
            throw new Warning(Resource.getResourceString((String)"db_time_error") + "\n\n[" + DateFormat.getDateTimeInstance().format(pdate) + " > " + DateFormat.getDateTimeInstance().format(dbdate) + "]");
        }
    }

    public static Factory getFactory() {
        return factory;
    }

    public static void setFactory(Factory factory) {
        DBHelper.factory = factory;
    }

    public static Controller getController() {
        return controller;
    }

    public static void setController(Controller controller) {
        DBHelper.controller = controller;
    }

    public static interface Controller {
        public String buildURL();

        public void connect(String var1) throws Exception;

        public void close() throws Exception;

        public void execSQL(String var1) throws Exception;

        public ResultSet execQuery(String var1) throws Exception;

        public void beginTransaction() throws Exception;

        public void commitTransaction() throws Exception;

        public void rollbackTransaction() throws Exception;

        public Connection getConnection();
    }

    public static interface Factory {
        public AppointmentDB createAppointmentDB();

        public CheckListDB createCheckListDB();

        public LinkDB createLinkDB();

        public MemoDB createMemoDB();

        public OptionDB createOptionDB();

        public TaskDB createTaskDB();

        public EntityDB<Address> createAddressDB();
    }
}

