/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.db.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.model.db.jdbc.JdbcDBUpgrader;
import net.sf.borg.model.db.jdbc.OptionJdbcDB;
import net.sf.borg.model.entity.Option;

final class JdbcDB {
    private static final Logger log = Logger.getLogger("net.sf.borg");
    protected static Connection connection_ = null;
    private static String url_;

    JdbcDB() {
    }

    public static void beginTransaction() throws Exception {
        connection_.setAutoCommit(false);
    }

    public static final void commitTransaction() throws Exception {
        PreparedStatement stmt = connection_.prepareStatement("COMMIT");
        stmt.execute();
        stmt.close();
        connection_.setAutoCommit(true);
    }

    public static final void rollbackTransaction() throws Exception {
        PreparedStatement stmt = connection_.prepareStatement("ROLLBACK");
        stmt.execute();
        stmt.close();
        connection_.setAutoCommit(true);
    }

    public static void connect(String urlIn) throws Exception {
        String url = urlIn;
        if (url == null) {
            url = JdbcDB.buildDbDir();
        }
        url_ = url;
        if (url.startsWith("jdbc:mysql")) {
            Class.forName("com.mysql.jdbc.Driver");
            if (connection_ == null) {
                connection_ = DriverManager.getConnection(url);
            }
        } else if (url.startsWith("jdbc:hsqldb")) {
            Class.forName("org.hsqldb.jdbcDriver");
            if (connection_ == null) {
                Properties props = new Properties();
                props.setProperty("user", "sa");
                props.setProperty("password", "");
                if (url.startsWith("jdbc:hsqldb:file")) {
                    props.setProperty("shutdown", "true");
                    props.setProperty("ifexists", "true");
                }
                try {
                    connection_ = DriverManager.getConnection(url, props);
                }
                catch (SQLException se) {
                    if (se.getSQLState().equals("08003")) {
                        int ch;
                        log.info("Creating Database");
                        InputStream is = JdbcDB.class.getResourceAsStream("/borg_hsqldb.sql");
                        StringBuffer sb = new StringBuffer();
                        InputStreamReader r = new InputStreamReader(is);
                        while ((ch = r.read()) != -1) {
                            sb.append((char)ch);
                        }
                        r.close();
                        props.setProperty("ifexists", "false");
                        connection_ = DriverManager.getConnection(url, props);
                        JdbcDB.execSQL(sb.toString());
                    }
                    if (se.getMessage().indexOf("locked") != -1) {
                        throw se;
                    }
                    throw se;
                }
                if (url.startsWith("jdbc:hsqldb:mem")) {
                    int ch;
                    log.info("Creating Database");
                    InputStream is = JdbcDB.class.getResourceAsStream("/borg_hsqldb.sql");
                    StringBuffer sb = new StringBuffer();
                    InputStreamReader r = new InputStreamReader(is);
                    while ((ch = r.read()) != -1) {
                        sb.append((char)ch);
                    }
                    r.close();
                    props.setProperty("ifexists", "false");
                    connection_ = DriverManager.getConnection(url, props);
                    JdbcDB.execSQL(sb.toString());
                }
            }
        } else if (url.startsWith("jdbc:h2")) {
            if (connection_ == null) {
                Properties props = new Properties();
                props.setProperty("user", "sa");
                props.setProperty("password", "");
                props.setProperty("shutdown", "true");
                props.setProperty("ifexists", "true");
                try {
                    connection_ = DriverManager.getConnection(url, props);
                }
                catch (SQLException se) {
                    if (se.getSQLState().equals("90013")) {
                        int ch;
                        log.info("Creating Database");
                        InputStream is = JdbcDB.class.getResourceAsStream("/borg_hsqldb.sql");
                        StringBuffer sb = new StringBuffer();
                        InputStreamReader r = new InputStreamReader(is);
                        while ((ch = r.read()) != -1) {
                            sb.append((char)ch);
                        }
                        r.close();
                        props.setProperty("ifexists", "false");
                        connection_ = DriverManager.getConnection(url, props);
                        JdbcDB.execSQL(sb.toString());
                    }
                    if (se.getMessage().indexOf("locked") != -1) {
                        throw se;
                    }
                    throw se;
                }
            }
        } else if (connection_ == null) {
            connection_ = DriverManager.getConnection(url);
        }
        JdbcDB.doDBUpgrades();
    }

    private static final void cleanup() {
        try {
            if (connection_ != null && !connection_.isClosed() && url_.startsWith("jdbc:hsqldb:file")) {
                JdbcDB.execSQL("SHUTDOWN");
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    public static final String toStr(Vector<String> v) {
        String val = "";
        if (v == null) {
            return "";
        }
        try {
            while (true) {
                String s = v.remove(0);
                val = val + s;
                val = val + ",";
            }
        }
        catch (Exception exception) {
            return val;
        }
    }

    public static final int toInt(Integer in) {
        if (in == null) {
            return 0;
        }
        return in;
    }

    public static final int toInt(boolean in) {
        if (!in) {
            return 0;
        }
        return 1;
    }

    public static final Vector<String> toVect(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        StringTokenizer stk = new StringTokenizer(s, ",");
        Vector<String> vect = new Vector<String>();
        while (stk.hasMoreTokens()) {
            String stt = stk.nextToken();
            if (stt.equals("")) continue;
            vect.add(stt);
        }
        return vect;
    }

    public static final void execSQL(String sql) throws Exception {
        PreparedStatement stmt = connection_.prepareStatement(sql);
        stmt.execute();
        stmt.close();
    }

    public static final ResultSet execQuery(String sql) throws Exception {
        PreparedStatement stmt = connection_.prepareStatement(sql);
        stmt.execute();
        return stmt.getResultSet();
    }

    public static Connection getConnection() {
        return connection_;
    }

    public static void close() throws Exception {
        JdbcDB.writeTimestamp();
        JdbcDB.cleanup();
        if (connection_ != null) {
            connection_.close();
        }
        connection_ = null;
    }

    private static void writeTimestamp() throws Exception {
        Date now = new Date();
        Prefs.putPref((PrefName)PrefName.SHUTDOWNTIME, (Object)Long.toString(now.getTime()));
        Option option = new Option(PrefName.SHUTDOWNTIME.getName(), Long.toString(now.getTime()));
        new OptionJdbcDB().setOption(option);
    }

    public static String buildDbDir() {
        String dbdir = "";
        String dbtype = Prefs.getPref((PrefName)PrefName.DBTYPE);
        if (dbtype.equals("hsqldb")) {
            String hdir = Prefs.getPref((PrefName)PrefName.HSQLDBDIR);
            if (hdir.equals("not-set")) {
                return hdir;
            }
            dbdir = "jdbc:hsqldb:file:" + Prefs.getPref((PrefName)PrefName.HSQLDBDIR) + "/borg_";
        } else if (dbtype.equals("h2")) {
            String hdir = Prefs.getPref((PrefName)PrefName.H2DIR);
            if (hdir.equals("not-set")) {
                return hdir;
            }
            dbdir = "jdbc:h2:file:" + Prefs.getPref((PrefName)PrefName.H2DIR) + "/borgdb;USER=sa";
        } else {
            dbdir = dbtype.equals("jdbc") ? Prefs.getPref((PrefName)PrefName.JDBCURL) : "jdbc:mysql://" + Prefs.getPref((PrefName)PrefName.DBHOST) + ":" + Prefs.getPref((PrefName)PrefName.DBPORT) + "/" + Prefs.getPref((PrefName)PrefName.DBNAME) + "?user=" + Prefs.getPref((PrefName)PrefName.DBUSER) + "&password=" + Prefs.getPref((PrefName)PrefName.DBPASS) + "&autoReconnect=true";
        }
        log.info("DB URL is: " + dbdir);
        return dbdir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doDBUpgrades() throws Exception {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = connection_.createStatement();
            rs = st.executeQuery("select * from options");
            ResultSetMetaData md = rs.getMetaData();
            if (md.getColumnDisplaySize(1) == 10) {
                new JdbcDBUpgrader(null, "alter table options alter name varchar(30)").upgrade();
            }
            rs.close();
            rs = st.executeQuery("select street, work_street from addresses");
            md = rs.getMetaData();
            if (md.getColumnDisplaySize(1) < 40) {
                new JdbcDBUpgrader(null, "alter table addresses alter street varchar(40)").upgrade();
            }
            if (md.getColumnDisplaySize(2) < 40) {
                new JdbcDBUpgrader(null, "alter table addresses alter work_street varchar(40)").upgrade();
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
    }
}

