/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.db.jdbc;

import java.sql.SQLException;
import java.util.logging.Logger;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.db.jdbc.JdbcDB;

public class JdbcDBUpgrader {
    private static final Logger log = Logger.getLogger("net.sf.borg");
    private String checkSql;
    private String[] updSql;

    public JdbcDBUpgrader(String checkSql, String usql) {
        this.updSql = new String[1];
        this.updSql[0] = usql;
        this.checkSql = checkSql;
    }

    public JdbcDBUpgrader(String checkSql, String[] usql) {
        this.updSql = usql;
        this.checkSql = checkSql;
    }

    private boolean needsUpgrade() throws Exception {
        block3: {
            if (this.checkSql == null) {
                return true;
            }
            try {
                JdbcDB.execSQL(this.checkSql);
            }
            catch (Exception e) {
                if (!(e instanceof SQLException)) break block3;
                return true;
            }
        }
        return false;
    }

    private void performUpgrade() throws Exception {
        String dbtype = Prefs.getPref((PrefName)PrefName.DBTYPE);
        for (int i = 0; i < this.updSql.length; ++i) {
            if (dbtype.equals("mysql")) {
                Errmsg.getErrorHandler().notice(Resource.getResourceString((String)"update_error") + this.updSql[i]);
                continue;
            }
            log.info("Running Upgrade SQL:" + this.updSql[i]);
            JdbcDB.execSQL(this.updSql[i]);
        }
    }

    public void upgrade() {
        try {
            if (this.needsUpgrade()) {
                this.performUpgrade();
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }
}

