/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.entity;

import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.CalendarEntity;
import net.sf.borg.model.entity.KeyedEntity;
import net.sf.borg.model.entity.Task;

@XmlRootElement(name="Subtask")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Subtask
extends KeyedEntity<Subtask>
implements CalendarEntity {
    private static final long serialVersionUID = -5794908342032518360L;
    private Date StartDate;
    private Date CloseDate;
    private Date DueDate;
    private String Description;
    private Integer Task;
    private String taskDesc = null;

    @Override
    protected Subtask clone() {
        Subtask dst = new Subtask();
        dst.setKey(this.getKey());
        dst.setStartDate(this.getStartDate());
        dst.setCloseDate(this.getCloseDate());
        dst.setDueDate(this.getDueDate());
        dst.setDescription(this.getDescription());
        dst.setTask(this.getTask());
        return dst;
    }

    @Override
    public String getColor() {
        return "navy";
    }

    @Override
    public Date getDate() {
        return this.getDueDate();
    }

    @Override
    public Integer getDuration() {
        return new Integer(0);
    }

    @Override
    public Date getNextTodo() {
        return null;
    }

    @Override
    public String getText() {
        String showabb = Prefs.getPref((PrefName)PrefName.TASK_SHOW_ABBREV);
        String abb = "";
        if (showabb.equals("true")) {
            abb = "BT" + this.getTask() + "/ST" + this.getKey() + " ";
        } else {
            if (this.taskDesc == null) {
                try {
                    Task t = TaskModel.getReference().getTask(this.Task);
                    if (t != null) {
                        this.taskDesc = t.getSummary();
                    }
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
            abb = "[" + this.taskDesc + "] ";
        }
        String de = abb + this.getDescription();
        String tx = de.replace('\n', ' ');
        return tx;
    }

    @Override
    public boolean isTodo() {
        return true;
    }

    @Override
    public Integer getPriority() {
        return null;
    }

    public Date getStartDate() {
        return this.StartDate;
    }

    public Date getCloseDate() {
        return this.CloseDate;
    }

    public Date getDueDate() {
        return this.DueDate;
    }

    public String getDescription() {
        return this.Description;
    }

    public Integer getTask() {
        return this.Task;
    }

    public String getTaskDesc() {
        return this.taskDesc;
    }

    public void setStartDate(Date StartDate) {
        this.StartDate = StartDate;
    }

    public void setCloseDate(Date CloseDate) {
        this.CloseDate = CloseDate;
    }

    public void setDueDate(Date DueDate) {
        this.DueDate = DueDate;
    }

    public void setDescription(String Description) {
        this.Description = Description;
    }

    public void setTask(Integer Task2) {
        this.Task = Task2;
    }

    public void setTaskDesc(String taskDesc) {
        this.taskDesc = taskDesc;
    }

    @Override
    public String toString() {
        return "Subtask(StartDate=" + this.getStartDate() + ", CloseDate=" + this.getCloseDate() + ", DueDate=" + this.getDueDate() + ", Description=" + this.getDescription() + ", Task=" + this.getTask() + ", taskDesc=" + this.getTaskDesc() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subtask)) {
            return false;
        }
        Subtask other = (Subtask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Date this$StartDate = this.getStartDate();
        Date other$StartDate = other.getStartDate();
        if (this$StartDate == null ? other$StartDate != null : !((Object)this$StartDate).equals(other$StartDate)) {
            return false;
        }
        Date this$CloseDate = this.getCloseDate();
        Date other$CloseDate = other.getCloseDate();
        if (this$CloseDate == null ? other$CloseDate != null : !((Object)this$CloseDate).equals(other$CloseDate)) {
            return false;
        }
        Date this$DueDate = this.getDueDate();
        Date other$DueDate = other.getDueDate();
        if (this$DueDate == null ? other$DueDate != null : !((Object)this$DueDate).equals(other$DueDate)) {
            return false;
        }
        String this$Description = this.getDescription();
        String other$Description = other.getDescription();
        if (this$Description == null ? other$Description != null : !this$Description.equals(other$Description)) {
            return false;
        }
        Integer this$Task = this.getTask();
        Integer other$Task = other.getTask();
        if (this$Task == null ? other$Task != null : !((Object)this$Task).equals(other$Task)) {
            return false;
        }
        String this$taskDesc = this.getTaskDesc();
        String other$taskDesc = other.getTaskDesc();
        return !(this$taskDesc == null ? other$taskDesc != null : !this$taskDesc.equals(other$taskDesc));
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof Subtask;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + super.hashCode();
        Date $StartDate = this.getStartDate();
        result = result * 31 + ($StartDate == null ? 0 : ((Object)$StartDate).hashCode());
        Date $CloseDate = this.getCloseDate();
        result = result * 31 + ($CloseDate == null ? 0 : ((Object)$CloseDate).hashCode());
        Date $DueDate = this.getDueDate();
        result = result * 31 + ($DueDate == null ? 0 : ((Object)$DueDate).hashCode());
        String $Description = this.getDescription();
        result = result * 31 + ($Description == null ? 0 : $Description.hashCode());
        Integer $Task = this.getTask();
        result = result * 31 + ($Task == null ? 0 : ((Object)$Task).hashCode());
        String $taskDesc = this.getTaskDesc();
        result = result * 31 + ($taskDesc == null ? 0 : $taskDesc.hashCode());
        return result;
    }
}

