/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.ical;

import biz.source_code.base64Coder.Base64Coder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.model.ical.AppointmentIcalAdapter;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class IcalFTP {
    private static void checkReply(FTPClient c) throws Exception {
        int reply = c.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            throw new Exception("FTP Error: " + reply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportftp(Integer years) throws Exception {
        String icalString = "";
        if (years != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.add(1, -1 * years);
            icalString = AppointmentIcalAdapter.exportIcalToString(cal.getTime());
        } else {
            icalString = AppointmentIcalAdapter.exportIcalToString(null);
        }
        FTPClient client = new FTPClient();
        try {
            client.connect(Prefs.getPref((PrefName)PrefName.FTPSERVER));
            IcalFTP.checkReply(client);
            client.login(Prefs.getPref((PrefName)PrefName.FTPUSER), IcalFTP.gep());
            IcalFTP.checkReply(client);
            client.enterLocalPassiveMode();
            IcalFTP.checkReply(client);
            ByteArrayInputStream is = new ByteArrayInputStream(icalString.getBytes());
            client.storeFile(Prefs.getPref((PrefName)PrefName.FTPPATH), (InputStream)is);
            IcalFTP.checkReply(client);
            client.logout();
        }
        finally {
            client.disconnect();
        }
    }

    public static void sep(String s) throws Exception {
        SecretKey key;
        if ("".equals(s)) {
            Prefs.putPref((PrefName)PrefName.FTPPW, (Object)s);
            return;
        }
        String p1 = Prefs.getPref((PrefName)PrefName.FTPPW2);
        if ("".equals(p1)) {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            key = keyGen.generateKey();
            p1 = new String(Base64Coder.encode((byte[])key.getEncoded()));
            Prefs.putPref((PrefName)PrefName.FTPPW2, (Object)p1);
        }
        byte[] ba = Base64Coder.decode((String)p1);
        key = new SecretKeySpec(ba, "AES");
        Cipher enc = Cipher.getInstance("AES");
        enc.init(1, key);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CipherOutputStream os = new CipherOutputStream(baos, enc);
        ((OutputStream)os).write(s.getBytes());
        ((OutputStream)os).close();
        ba = baos.toByteArray();
        Prefs.putPref((PrefName)PrefName.FTPPW, (Object)new String(Base64Coder.encode((byte[])ba)));
    }

    public static String gep() throws Exception {
        String p1 = Prefs.getPref((PrefName)PrefName.FTPPW2);
        String p2 = Prefs.getPref((PrefName)PrefName.FTPPW);
        if ("".equals(p2)) {
            return p2;
        }
        if ("".equals(p1)) {
            IcalFTP.sep(p2);
            return p2;
        }
        byte[] ba = Base64Coder.decode((String)p1);
        SecretKeySpec key = new SecretKeySpec(ba, "AES");
        Cipher dec = Cipher.getInstance("AES");
        dec.init(2, key);
        byte[] decba = Base64Coder.decode((String)p2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CipherOutputStream os = new CipherOutputStream(baos, dec);
        ((OutputStream)os).write(decba);
        ((OutputStream)os).close();
        return baos.toString();
    }
}

