/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.undo;

import net.sf.borg.common.Resource;
import net.sf.borg.model.CheckListModel;
import net.sf.borg.model.entity.CheckList;
import net.sf.borg.model.undo.UndoItem;

public class CheckListUndoItem
extends UndoItem<CheckList> {
    @Override
    public void executeUndo() {
        if (this.action == UndoItem.actionType.DELETE) {
            CheckListModel.getReference().saveCheckList((CheckList)this.item, true);
        } else if (this.action == UndoItem.actionType.UPDATE) {
            CheckListModel.getReference().saveCheckList((CheckList)this.item, true);
        } else if (this.action == UndoItem.actionType.ADD) {
            CheckListModel.getReference().delete(((CheckList)this.item).getCheckListName(), true);
        }
    }

    private CheckListUndoItem() {
    }

    private static String checkListString(CheckList checkList) {
        return checkList.getCheckListName();
    }

    public static CheckListUndoItem recordUpdate(CheckList checkList) {
        CheckListUndoItem undoItem = new CheckListUndoItem();
        undoItem.item = checkList;
        undoItem.action = UndoItem.actionType.UPDATE;
        undoItem.setDescription(Resource.getResourceString((String)"Change") + " " + Resource.getResourceString((String)"CheckList") + " " + CheckListUndoItem.checkListString(checkList));
        return undoItem;
    }

    public static CheckListUndoItem recordAdd(CheckList checkList) {
        CheckListUndoItem undoItem = new CheckListUndoItem();
        undoItem.item = checkList;
        undoItem.action = UndoItem.actionType.ADD;
        undoItem.setDescription(Resource.getResourceString((String)"Add") + " " + Resource.getResourceString((String)"checkList") + " " + CheckListUndoItem.checkListString(checkList));
        return undoItem;
    }

    public static CheckListUndoItem recordDelete(CheckList checkList) {
        CheckListUndoItem undoItem = new CheckListUndoItem();
        undoItem.item = checkList;
        undoItem.action = UndoItem.actionType.DELETE;
        undoItem.setDescription(Resource.getResourceString((String)"Delete") + " " + Resource.getResourceString((String)"checkList") + " " + CheckListUndoItem.checkListString(checkList));
        return undoItem;
    }
}

