/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.undo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Subtask;
import net.sf.borg.model.entity.Task;
import net.sf.borg.model.undo.SubtaskUndoItem;
import net.sf.borg.model.undo.UndoItem;
import net.sf.borg.model.undo.UndoLog;

public class TaskUndoItem
extends UndoItem<Task> {
    private Collection<SubtaskUndoItem> subtasks = new ArrayList<SubtaskUndoItem>();

    @Override
    public void executeUndo() {
        try {
            if (this.action == UndoItem.actionType.DELETE) {
                Project p;
                Integer pid = ((Task)this.item).getProject();
                if (pid != null && (p = TaskModel.getReference().getProject(pid)) == null) {
                    ((Task)this.item).setProject(null);
                }
                TaskModel.getReference().savetask((Task)this.item, true);
                for (SubtaskUndoItem s : this.subtasks) {
                    ((Subtask)s.item).setTask(new Integer(((Task)this.item).getKey()));
                    s.executeUndo();
                }
            } else if (this.action == UndoItem.actionType.UPDATE) {
                for (SubtaskUndoItem s : this.subtasks) {
                    s.executeUndo();
                }
                TaskModel.getReference().savetask((Task)this.item, true);
            } else if (this.action == UndoItem.actionType.ADD) {
                TaskModel.getReference().delete(((Task)this.item).getKey(), true);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private TaskUndoItem() {
    }

    private static String itemString(Task st) {
        return st.getSummary();
    }

    public static TaskUndoItem recordUpdate(Task task) {
        TaskUndoItem undoItem = new TaskUndoItem();
        undoItem.item = task;
        undoItem.action = UndoItem.actionType.UPDATE;
        undoItem.setDescription(Resource.getResourceString((String)"Change") + " " + Resource.getResourceString((String)"task") + " " + TaskUndoItem.itemString(task));
        return undoItem;
    }

    public static TaskUndoItem recordAdd(Task task) {
        TaskUndoItem undoItem = new TaskUndoItem();
        undoItem.item = task;
        undoItem.action = UndoItem.actionType.ADD;
        undoItem.setDescription(Resource.getResourceString((String)"Add") + " " + Resource.getResourceString((String)"task") + " " + TaskUndoItem.itemString(task));
        return undoItem;
    }

    public static TaskUndoItem recordDelete(Task task) {
        TaskUndoItem undoItem = new TaskUndoItem();
        undoItem.item = task;
        undoItem.action = UndoItem.actionType.DELETE;
        undoItem.setDescription(Resource.getResourceString((String)"Delete") + " " + Resource.getResourceString((String)"task") + " " + TaskUndoItem.itemString(task));
        return undoItem;
    }

    static TaskUndoItem getLastTaskItem() {
        Stack<UndoItem<?>> items = UndoLog.getReference().getItems();
        for (int idx = items.size() - 1; idx >= 0; --idx) {
            UndoItem item = (UndoItem)items.elementAt(idx);
            if (!TaskUndoItem.class.isInstance(item)) continue;
            return (TaskUndoItem)TaskUndoItem.class.cast(item);
        }
        return null;
    }

    void addSubtask(SubtaskUndoItem st) {
        this.subtasks.add(st);
    }
}

