/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.common;

import java.util.logging.Logger;
import net.sf.borg.common.ErrorHandler;
import net.sf.borg.common.Warning;

public class Errmsg {
    private static final Logger log = Logger.getLogger("net.sf.borg");
    private static ErrorHandler errorHandler = new DefaultErrorHandler();

    public static ErrorHandler getErrorHandler() {
        return errorHandler;
    }

    public static void setErrorHandler(ErrorHandler errorHandler) {
        Errmsg.errorHandler = errorHandler;
    }

    public static void logError(Exception e) {
        log.severe(e.toString());
        e.printStackTrace();
    }

    private static class DefaultErrorHandler
    implements ErrorHandler {
        private DefaultErrorHandler() {
        }

        @Override
        public void errmsg(Exception e) {
            if (e instanceof Warning) {
                this.notice(e.getMessage());
                return;
            }
            log.severe(e.toString());
            e.printStackTrace();
        }

        @Override
        public void notice(String s) {
            log.info(s);
        }
    }
}

