/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Logger;
import net.sf.borg.common.SocketHandler;

public class SocketServer
extends Thread {
    private static final Logger log = Logger.getLogger("net.sf.borg");
    protected ServerSocket listen_socket;
    private SocketHandler handler_;

    private static void fail(Exception e, String msg) {
        log.severe(msg + ": " + e);
    }

    public SocketServer(int port, SocketHandler handler) {
        this.handler_ = handler;
        try {
            this.listen_socket = new ServerSocket(port);
        }
        catch (IOException e) {
            SocketServer.fail(e, "Exception creating server socket");
        }
        log.info("Server: listening on port " + port);
        this.setName("Socket Server");
        this.start();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Socket client_socket = this.listen_socket.accept();
                new Connection(client_socket, this.handler_);
            }
        }
        catch (IOException e) {
            SocketServer.fail(e, "Exception while listening for connections");
            return;
        }
    }

    private class Connection
    extends Thread {
        protected Socket client;
        protected BufferedReader in;
        protected PrintStream out;
        private SocketHandler handler_1;

        public Connection(Socket client_socket, SocketHandler handler) {
            this.client = client_socket;
            this.handler_1 = handler;
            try {
                this.in = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
                this.out = new PrintStream(this.client.getOutputStream());
            }
            catch (IOException e) {
                try {
                    this.client.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                log.severe("Exception while getting socket streams: " + e);
                return;
            }
            this.setName("Socket Connection");
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String line;
                while ((line = this.in.readLine()) != null) {
                    String output = this.handler_1.processMessage(line);
                    this.out.println(output);
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    this.client.close();
                }
                catch (IOException e2) {}
            }
        }
    }
}

