/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import net.fortuna.ical4j.connector.FailedOperationException;
import net.fortuna.ical4j.connector.ObjectCollection;
import net.fortuna.ical4j.connector.ObjectStore;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.dav.DavClient;
import net.fortuna.ical4j.connector.dav.PathResolver;
import net.fortuna.ical4j.connector.dav.enums.SupportedFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDavObjectStore<C extends ObjectCollection<?>>
implements ObjectStore<C> {
    private DavClient davClient;
    private String username;
    private final URL rootUrl;
    private ArrayList<SupportedFeature> supportedFeatures;
    protected final PathResolver pathResolver;

    public AbstractDavObjectStore(URL url, PathResolver pathResolver) {
        this.rootUrl = url;
        this.pathResolver = pathResolver;
    }

    public final String getPath() {
        return this.pathResolver.getUserPath(this.getUserName());
    }

    @Override
    public final boolean connect() throws ObjectStoreException {
        String principalPath = this.pathResolver.getPrincipalPath(this.username);
        String userPath = this.pathResolver.getUserPath(this.getUserName());
        this.davClient = new DavClient(this.rootUrl, principalPath, userPath);
        this.davClient.begin();
        return true;
    }

    @Override
    public final boolean connect(String username, char[] password) throws ObjectStoreException {
        try {
            String principalPath = this.pathResolver.getPrincipalPath(username);
            String userPath = this.pathResolver.getUserPath(this.getUserName());
            this.davClient = new DavClient(this.rootUrl, principalPath, userPath);
            this.supportedFeatures = this.davClient.begin(username, password);
            this.username = username;
        }
        catch (IOException ioe) {
            throw new ObjectStoreException(ioe);
        }
        catch (FailedOperationException foe) {
            throw new ObjectStoreException(foe);
        }
        return true;
    }

    @Override
    public final void disconnect() {
        this.davClient = null;
        this.username = null;
    }

    @Override
    public final boolean isConnected() {
        return this.davClient != null;
    }

    protected String getUserName() {
        return this.username;
    }

    public DavClient getClient() {
        return this.davClient;
    }

    public URL getHostURL() {
        return this.rootUrl;
    }

    public ArrayList<SupportedFeature> supportedFeatures() {
        return this.supportedFeatures;
    }

    public boolean isSupportCalendarProxy() {
        return this.supportedFeatures.contains((Object)SupportedFeature.CALENDAR_PROXY);
    }
}

