/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.connector.CardCollection;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.dav.AbstractDavObjectCollection;
import net.fortuna.ical4j.connector.dav.CardDavStore;
import net.fortuna.ical4j.connector.dav.DavConstants;
import net.fortuna.ical4j.connector.dav.MkCalendar;
import net.fortuna.ical4j.connector.dav.enums.ResourceType;
import net.fortuna.ical4j.connector.dav.method.MkCalendarMethod;
import net.fortuna.ical4j.connector.dav.method.PutMethod;
import net.fortuna.ical4j.connector.dav.method.ReportMethod;
import net.fortuna.ical4j.connector.dav.property.BaseDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CalDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CardDavPropertyName;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.property.Uid;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyIterator;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CardDavCollection
extends AbstractDavObjectCollection<VCard>
implements CardCollection {
    CardDavCollection(CardDavStore CardDavCalendarStore, String id) {
        this(CardDavCalendarStore, id, null, null);
    }

    CardDavCollection(CardDavStore CardDavCalendarStore, String id, String displayName, String description) {
        super(CardDavCalendarStore, id);
        this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.DISPLAYNAME, (Object)displayName));
        this.properties.add((DavProperty)new DefaultDavProperty(CalDavPropertyName.CALENDAR_DESCRIPTION, (Object)description));
    }

    CardDavCollection(CardDavStore CardDavCalendarStore, String id, DavPropertySet _properties) {
        this(CardDavCalendarStore, id, null, null);
        this.properties = _properties;
    }

    final void create() throws IOException, ObjectStoreException {
        MkCalendarMethod mkCalendarMethod = new MkCalendarMethod(this.getPath());
        MkCalendar mkcalendar = new MkCalendar();
        mkcalendar.setProperties(this.properties);
        System.out.println("properties: " + this.properties.getContentSize());
        mkCalendarMethod.setRequestBody(mkcalendar);
        this.getStore().getClient().execute((HttpMethodBase)mkCalendarMethod);
        if (!mkCalendarMethod.succeeded()) {
            throw new ObjectStoreException(String.valueOf(mkCalendarMethod.getStatusCode()) + ": " + mkCalendarMethod.getStatusText());
        }
    }

    @Override
    public String getDisplayName() {
        try {
            return this.getProperty(DavPropertyName.DISPLAYNAME, String.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ObjectStoreException e) {
            e.printStackTrace();
        }
        catch (DavException e) {
            e.printStackTrace();
        }
        return null;
    }

    public long getMaxResourceSize() {
        try {
            Long size = this.getProperty(CalDavPropertyName.MAX_RESOURCE_SIZE, Long.class);
            if (size != null) {
                return size;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ObjectStoreException e) {
            e.printStackTrace();
        }
        catch (DavException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public Calendar export() throws ObjectStoreException {
        return null;
    }

    public static final DavPropertyNameSet propertiesForFetch() {
        DavPropertyNameSet principalsProps = new DavPropertyNameSet();
        principalsProps.add(DavPropertyName.DISPLAYNAME);
        principalsProps.add(BaseDavPropertyName.CURRENT_USER_PRIVILEGE_SET);
        principalsProps.add(BaseDavPropertyName.RESOURCETYPE);
        principalsProps.add(SecurityConstants.OWNER);
        principalsProps.add(CardDavPropertyName.MAX_RESOURCE_SIZE);
        principalsProps.add(BaseDavPropertyName.RESOURCE_ID);
        principalsProps.add(BaseDavPropertyName.SUPPORTED_REPORT_SET);
        principalsProps.add(BaseDavPropertyName.SYNC_TOKEN);
        principalsProps.add(BaseDavPropertyName.ADD_MEMBER);
        principalsProps.add(CardDavPropertyName.MAX_IMAGE_SIZE);
        principalsProps.add(CardDavPropertyName.SUPPORTED_ADDRESS_DATA);
        return principalsProps;
    }

    protected static List<CardDavCollection> collectionsFromResponse(CardDavStore store, MultiStatusResponse[] responses) {
        ArrayList<CardDavCollection> collections = new ArrayList<CardDavCollection>();
        System.out.println(responses.length);
        int i = 0;
        while (i < responses.length) {
            MultiStatusResponse msResponse = responses[i];
            DavPropertySet foundProperties = msResponse.getProperties(200);
            String collectionUri = msResponse.getHref();
            int j = 0;
            while (j < responses[i].getStatus().length) {
                if (responses[i].getStatus()[j].getStatusCode() == 200) {
                    boolean isAddressBookCollection = false;
                    DavPropertySet _properties = new DavPropertySet();
                    DavPropertyIterator iNames = foundProperties.iterator();
                    while (iNames.hasNext()) {
                        Object value;
                        DavProperty property = iNames.nextProperty();
                        if (property == null) continue;
                        _properties.add(property);
                        if (!"resourcetype".equals(property.getName().getName()) || !DavConstants.NAMESPACE.equals((Object)property.getName().getNamespace()) || !((value = property.getValue()) instanceof ArrayList)) continue;
                        for (Node child : (ArrayList)value) {
                            ResourceType type;
                            String nameNode;
                            if (!(child instanceof Element) || (nameNode = child.getLocalName()) == null || (type = ResourceType.findByDescription(nameNode)) == null || !type.equals((Object)ResourceType.ADRESSBOOK)) continue;
                            isAddressBookCollection = true;
                        }
                    }
                    if (isAddressBookCollection) {
                        collections.add(new CardDavCollection(store, collectionUri, _properties));
                    }
                }
                ++j;
            }
            ++i;
        }
        return collections;
    }

    @Override
    public String getDescription() {
        return null;
    }

    public VCard[] getComponents() throws ObjectStoreException {
        try {
            DavPropertyNameSet properties = new DavPropertyNameSet();
            properties.add(DavPropertyName.GETETAG);
            properties.add(CardDavPropertyName.ADDRESS_DATA);
            ReportInfo info = new ReportInfo(ReportMethod.ADDRESSBOOK_QUERY, 1, properties);
            ReportMethod method = new ReportMethod(this.getPath(), info);
            this.getStore().getClient().execute((HttpMethodBase)method);
            if (method.getStatusCode() == 207) {
                return method.getVCards();
            }
            if (method.getStatusCode() == 404) {
                return new VCard[0];
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (DavException e) {
            e.printStackTrace();
        }
        return new VCard[0];
    }

    @Override
    public void addCard(VCard card) throws ObjectStoreException, ConstraintViolationException {
        Uid uid = (Uid)card.getProperty(Property.Id.UID);
        String path = this.getPath();
        if (!path.endsWith("/")) {
            path = path.concat("/");
        }
        PutMethod putMethod = new PutMethod(String.valueOf(path) + uid.getValue() + ".vcf");
        try {
            putMethod.setVCard(card);
        }
        catch (Exception e) {
            throw new ObjectStoreException("Invalid vcard", e);
        }
        try {
            this.getStore().getClient().execute((HttpMethodBase)putMethod);
            if (putMethod.getStatusCode() != 201 && putMethod.getStatusCode() != 204) {
                throw new ObjectStoreException("Error creating calendar on server: " + putMethod.getStatusLine());
            }
        }
        catch (IOException ioe) {
            throw new ObjectStoreException("Error creating calendar on server", ioe);
        }
    }
}

